/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.elements;

import androidx.annotation.Nullable;
import com.liveperson.messaging.structuredcontent.model.actions.BaseAction;
import com.liveperson.messaging.structuredcontent.model.actions.PublishTextAction;
import com.liveperson.messaging.structuredcontent.model.elements.SimpleElement;
import com.liveperson.messaging.structuredcontent.parsers.ActionParser;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ActionableElement
extends SimpleElement {
    public static final String TAG = ActionableElement.class.getSimpleName();
    protected JSONArray mMetadata;
    protected List<BaseAction> mActionList;
    private static Comparator<BaseAction> comparator = new Comparator<BaseAction>(){

        @Override
        public int compare(BaseAction left, BaseAction right) {
            return left instanceof PublishTextAction ? -1 : 0;
        }
    };

    public ActionableElement(String type) {
        super(type);
    }

    public ActionableElement(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        this.parseClick(jsonObject);
    }

    protected void parseClick(JSONObject jsonObject) {
        JSONObject clickObject = jsonObject.optJSONObject("click");
        if (clickObject == null) {
            return;
        }
        this.mMetadata = clickObject.optJSONArray("metadata");
        this.parseActions(clickObject);
    }

    protected void parseActions(JSONObject jsonObject) {
        JSONArray actionArray = jsonObject.optJSONArray("actions");
        if (actionArray != null) {
            this.mActionList = ActionParser.parse(actionArray, this.mMetadata);
            if (this.mActionList.size() > 1) {
                Collections.sort(this.mActionList, comparator);
            }
        }
    }

    public List<BaseAction> getActions() {
        return this.mActionList;
    }

    @Nullable
    public JSONArray getMetadata() {
        return this.mMetadata;
    }
}

