package com.liveperson.messaging.commands;

import androidx.annotation.Nullable;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.socket.requests.CloseDialogRequest;

/**
 * Created by Perry Sh on 13/05/2018.
 */
public class CloseDialogCommand implements Command {
    private static final String TAG = CloseDialogCommand.class.getSimpleName();

    private final AmsDialogs mAmsDialogs;
    private String mDialogId;
    private String mSocketUrl;

    // LE-88344: This value should always be it, until the Product team will guide us otherwise.
    private static final String CLOSING_CAUSE = "Closed by Consumer";
    @Nullable
    private ICallback<Integer, Exception> callback;
    @Nullable
    private CloseDialogRequest closeDialogRequest;

    public CloseDialogCommand(AmsDialogs amsDialogs, String dialogId, String socketUrl) {
        mAmsDialogs = amsDialogs;
        mSocketUrl = socketUrl;
        mDialogId = dialogId;
    }

    public CloseDialogCommand setCallback(@Nullable ICallback<Integer, Exception> callback) {
        this.callback = callback;
        if (closeDialogRequest != null) {
            closeDialogRequest.setCallback(callback);
        }

        return this;
    }

    @Override
    public void execute() {
        Dialog dialog = mAmsDialogs.getActiveDialog();

        if (dialog != null) {
            String dialogId = dialog.getDialogId();
            if (dialogId.equalsIgnoreCase(mDialogId)) {
                closeDialogRequest = new CloseDialogRequest(mSocketUrl, dialogId, dialog.getConversationId(), CLOSING_CAUSE);
                closeDialogRequest.setCallback(callback);
                SocketManager.getInstance().send(closeDialogRequest);
            } else {
                LPMobileLog.e(TAG, "The dialog with this ID (" + mDialogId + ") is not an active dialog");
            }
        } else {
            LPMobileLog.e(TAG, "No open dialog found. Aborting resolve conversation command.");
        }
    }
}