package com.liveperson.messaging.commands.tasks;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.liveperson.api.request.GetUserProfile;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.network.socket.requests.GetUserProfileRequest;

/**
 * Created by Ilya Gazman on 11/16/2015.
 * <p/>
 * Base connection task to obtain user data
 */
public class GetConsumerUserTask extends BaseAmsSocketConnectionTask {

    private static final String TAG = GetConsumerUserTask.class.getSimpleName();
    private final Messaging mController;

    public GetConsumerUserTask(Messaging controller) {
        mController = controller;
    }

    @Override
    public void execute() {

        String consumerId = mController.amsUsers.getConsumerId(mBrandId);
        if (!TextUtils.isEmpty(consumerId)) {
            mCallback.onTaskSuccess();
        } else {
            LPMobileLog.i(TAG, "Running get user task...");
            // TODO: 11/15/2015 Handler networking errors
            //This code support only consumer side --> BrandId == TargetId
            GetUserProfileRequest userProfileRequest = new GetUserProfileRequest(mController, mBrandId, mBrandId, UserProfile.UserType.CONSUMER);
            userProfileRequest.addCallback(new ResponseCallback<GetUserProfile.Response>() {
                public LocalBroadcastReceiver receiver;

                @Override
                public void onSuccess(GetUserProfile.Response data) {
                    receiver = new LocalBroadcastReceiver.Builder()
                            .addAction(AmsUsers.BROADCAST_CONSUMER_ID_ACTION)
                            .build(new LocalBroadcastReceiver.IOnReceive() {
                                @Override
                                public void onBroadcastReceived(Context context, Intent intent) {
                                    if (mBrandId.equals(intent.getStringExtra(AmsUsers.BRAND_ID_EXTRA))) {
                                        receiver.unregister();
                                        mCallback.onTaskSuccess();
                                    }
                                }
                            });
                }

                @Override
                public void onError() {
                    mCallback.onTaskError(SocketTaskType.GET_USER, new Exception(TAG));
                }
            });
            SocketManager.getInstance().send(userProfileRequest);
        }
    }
}