package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.SynchronizedAmsConnectionUpdateCallback;

/**
 * Created by shiranr on 16/06/2016.
 */
public class HandlePendingMessagesTask extends BaseAmsSocketConnectionTask {

    private AmsMessages amsMessages;
    private AmsConversations amsConversations;
    private AmsDialogs amsDialogs;
    private ConnectionsController mConnectionController;


    private static final String TAG = "HandlePendingMessagesTask";

    public HandlePendingMessagesTask(AmsMessages amsMessages, AmsConversations amsConversations, AmsDialogs amsDialogs, ConnectionsController connectionController) {
        this.amsMessages = amsMessages;
        this.amsConversations = amsConversations;
        this.amsDialogs = amsDialogs;
        mConnectionController = connectionController;
    }

    @Override
    public void execute() {
        LPMobileLog.d(TAG, "Running mark all pending messages as failed task...");


        new SynchronizedAmsConnectionUpdateCallback(mConnectionController, mBrandId, new Runnable() {
            @Override
            public void run() {
                    amsMessages.resendAllPendingMessages(mBrandId);
            }
        }).execute();

        amsConversations.markAllPendingConversationsAsFailed(mBrandId);
        amsDialogs.markPendingDialogsAsFailed(mBrandId);
        mCallback.onTaskSuccess();
    }

}
