package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import androidx.annotation.NonNull;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/3/17.
 * Navigate action. This action has longitude and latitude of the location to navigate to
 */
public class NavigateAction extends BaseAction {

	public static final String TAG = "NavigateAction";

	/**
	 * The location longitude
	 */
	private String mLongitude;
	/**
	 * The location latitude
	 */
	private String mLatitude;

	public NavigateAction(JSONObject jsonObject) throws JSONException {
		super(jsonObject);

		mLongitude = jsonObject.getString(ElementType.LO); // Mandatory
		mLatitude = jsonObject.getString(ElementType.LA); // Mandatory
	}

	public NavigateAction(String type, String name, String longitude, String latitude) {
		super(type, name);
		mLongitude = longitude;
		mLatitude = latitude;
	}

	@Override
	public OnActionClickListener getOnClickListener(final Context context, final String brandId) {
		return () -> {
			LPMobileLog.d(TAG, "onClick: navigate to La,Lo: " + mLatitude + "," + mLongitude);

			// Set the location to the URI
			Uri gmmIntentUri = Uri.parse("geo:" + mLatitude + "," + mLongitude + "?q=" + mLatitude + "," + mLongitude);
			Intent mapIntent = new Intent(Intent.ACTION_VIEW, gmmIntentUri);

			// Start the map intent if available on the device
			if (mapIntent.resolveActivity(context.getPackageManager()) != null) {
				context.startActivity(mapIntent);
			}
		};
	}

	@Override
	@NonNull
	public String toString() {
		return getClass().getSimpleName() + "(" + "\n";
	}

	@Override
	public void accept(ElementVisitor visitor) {
	}

	public String getLongitude() {
		return mLongitude;
	}

	public String getLatitude() {
		return mLatitude;
	}
}
