package com.liveperson.messaging.structuredcontent.model.elements.basic;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;

import com.liveperson.messaging.structuredcontent.parsers.ElementType;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by shiranr on 4/3/17.
 */

public class ElementStyle {

    public enum ElementSize {small, medium, large}

    private boolean mBold = false;
    private boolean mItalic = false;
    private @ColorInt Integer mTextColor = null;
	private ElementSize mSize;
    private @ColorInt Integer mBackgroundColor;
    private @ColorInt Integer mBorderColor;
    private Integer mBorderRadius;

    public ElementStyle(JSONObject style) throws JSONException {

    	setDefaultValues();

        if (style != null){
            mBold = style.optBoolean(ElementType.BOLD, false);
            mItalic = style.optBoolean(ElementType.ITALIC, false);

			try {
				String color = style.getString(ElementType.COLOR); // Not mandatory
				mTextColor = Color.parseColor(color);
			}catch (IllegalArgumentException | JSONException e){
				// Default value in case of parse error or value missing. Using the one in the XML
			}

			try {
				String backgroundColor = style.getString(ElementType.BACKGROUND_COLOR); // Not mandatory
				mBackgroundColor = Color.parseColor(backgroundColor);
			}catch (IllegalArgumentException | JSONException e){
				// Default value in case of parse error or value missing
			}

			try {
				String borderColor = style.getString(ElementType.BORDER_COLOR); // Not mandatory
				mBorderColor = Color.parseColor(borderColor);
			}catch (IllegalArgumentException | JSONException e){
				// Default value in case of parse error or value missing

			}

			try {
				mBorderRadius = style.getInt(ElementType.BORDER_RADIUS);
			} catch (JSONException e) {
				// Leave the radius null
			}

			try {
				String size = style.getString(ElementType.SIZE); // Not mandatory
				mSize = ElementSize.valueOf(size.toLowerCase());
			}catch (IllegalArgumentException | JSONException e){
				// Default value in case of parse error or value missing
				mSize = ElementSize.small;
			}
        }
    }

    protected void setDefaultValues(){
		mBold = false;
		mItalic = false;
		mBackgroundColor = null;
		mBorderColor = null;
		mSize = ElementSize.small;
		mBorderRadius = null;
	}

    public boolean isBold() {
        return mBold;
    }

    public boolean isItalic() {
        return mItalic;
    }

    @Nullable
    public Integer getTextColor() {
        return mTextColor;
    }

    public ElementSize getSize() {
        return mSize;
    }

	@Nullable
	public Integer getBackgroundColor() {
		return mBackgroundColor;
	}

	@Nullable
	public Integer getBorderColor() {
		return mBorderColor;
	}

	@Nullable
	public Integer getBorderRadius() {
		return mBorderRadius;
	}
}
