package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.messaging.structuredcontent.model.elements.SimpleElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**ko
 * Created by nirni on 2/3/17.
 * Link element. Holds title and URI properties
 */

public class LinkElement extends SimpleElement {

	/**
	 * The URI
	 */
	private String mUri;
	/**
	 * The title of the link
	 */
	private String mTitle;

	public LinkElement() {
		super(ElementType.LINK);
	}

	/**
	 * This sets title and URI of the link from the given json.
	 * @param jsonObject
	 * @throws JSONException
	 */
	public LinkElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);
		mUri = jsonObject.getString(ElementType.URI); // Mandatory
		mTitle = jsonObject.optString(ElementType.TITLE); // Not mandatory
	}

	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + " - " + mTitle + "\n");

		return sb.toString();
	}

	@Override
	public void accept(ElementVisitor visitor) {
		visitor.visit(this);
	}

	public String getUri() {
		return mUri;
	}

	public void setUri(String uri) {
		mUri = uri;
	}

	public String getTitle() {
		return mTitle;
	}

	public void setTitle(String title) {
		mTitle = title;
	}
}
