/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

import android.text.TextUtils;
import com.liveperson.infra.log.LPMobileLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class Participants {
    private static final String TAG = "Participants";
    public String[] CONSUMER = new String[0];
    public String[] ASSIGNED_AGENT = new String[0];
    public String[] MANAGER = new String[0];
    public String[] READER = new String[0];
    public String[] CONTROLLER = new String[0];
    public String[] AGENTS = new String[0];
    public String[] ALL_AGENTS = new String[0];

    public void add(ArrayList<String> id, ParticipantRole role) {
        this.add(id.toArray(new String[0]), role);
    }

    public void add(String[] id, ParticipantRole role) {
        switch (role) {
            case READER: {
                this.READER = id;
                this.mergeAgents(role);
                break;
            }
            case MANAGER: {
                this.MANAGER = id;
                this.mergeAgents(role);
                break;
            }
            case CONSUMER: {
                this.mergeConsumers(id);
                break;
            }
            case CONTROLLER: {
                this.mergeControllers(id);
                break;
            }
            case ASSIGNED_AGENT: {
                this.ASSIGNED_AGENT = id;
                this.mergeAgents(role);
                break;
            }
            case AGENT: {
                this.AGENTS = id;
                this.mergeAgents(role);
                break;
            }
            default: {
                LPMobileLog.e((String)TAG, (String)("Found new participant role: " + (Object)((Object)role) + ". Ignore it!"));
                return;
            }
        }
    }

    private void mergeAgents(ParticipantRole currentRole) {
        String[] currentAgents = new String[]{};
        if (currentRole == ParticipantRole.MANAGER) {
            currentAgents = this.MANAGER;
        } else if (currentRole == ParticipantRole.ASSIGNED_AGENT) {
            currentAgents = this.ASSIGNED_AGENT;
        } else if (currentRole == ParticipantRole.AGENT) {
            currentAgents = this.AGENTS;
        } else if (currentRole == ParticipantRole.READER) {
            currentAgents = this.READER;
        }
        String[] previousAgents = this.ALL_AGENTS;
        this.ALL_AGENTS = new String[currentAgents.length + previousAgents.length];
        System.arraycopy(currentAgents, 0, this.ALL_AGENTS, 0, currentAgents.length);
        System.arraycopy(previousAgents, 0, this.ALL_AGENTS, currentAgents.length, previousAgents.length);
    }

    private void mergeControllers(String[] controller) {
        String[] previousControllers = this.CONTROLLER;
        this.CONTROLLER = new String[controller.length + previousControllers.length];
        System.arraycopy(controller, 0, this.CONTROLLER, 0, controller.length);
        System.arraycopy(previousControllers, 0, this.CONTROLLER, controller.length, previousControllers.length);
    }

    private void mergeConsumers(String[] consumer) {
        String[] previousConsumers = this.CONSUMER;
        this.CONSUMER = new String[consumer.length + previousConsumers.length];
        System.arraycopy(consumer, 0, this.CONSUMER, 0, consumer.length);
        System.arraycopy(previousConsumers, 0, this.CONSUMER, consumer.length, previousConsumers.length);
    }

    public String[] extractAllParticipantsIds() {
        HashSet<String> result = new HashSet<String>();
        ArrayList<String[]> idsHolders = new ArrayList<String[]>();
        idsHolders.add(this.CONSUMER);
        idsHolders.add(this.ASSIGNED_AGENT);
        idsHolders.add(this.AGENTS);
        idsHolders.add(this.MANAGER);
        idsHolders.add(this.READER);
        idsHolders.add(this.CONTROLLER);
        idsHolders.add(this.ALL_AGENTS);
        Iterator iterator = idsHolders.iterator();
        while (iterator.hasNext()) {
            String[] idsHolder;
            for (String id : idsHolder = (String[])iterator.next()) {
                if (TextUtils.isEmpty((CharSequence)id)) continue;
                result.add(id);
            }
        }
        return result.toArray(new String[0]);
    }

    public static enum ParticipantRole {
        CONSUMER("CONSUMER"),
        ASSIGNED_AGENT("ASSIGNED_AGENT"),
        AGENT("AGENT"),
        MANAGER("MANAGER"),
        READER("READER"),
        CONTROLLER("CONTROLLER");

        private static final String TAG;
        String participantType;

        private ParticipantRole(String type) {
            this.participantType = type;
        }

        public static ParticipantRole getParticipantRole(String role) {
            for (ParticipantRole pr : ParticipantRole.values()) {
                if (!pr.participantType.equalsIgnoreCase(role)) continue;
                return pr;
            }
            LPMobileLog.e((String)TAG, (String)("Unknown 'ParticipantRole' named: " + role));
            return null;
        }

        public static ParticipantRole parse(String participantRoleString) {
            ParticipantRole result = null;
            try {
                result = ParticipantRole.valueOf(participantRoleString);
            }
            catch (IllegalArgumentException e) {
                ParticipantRole[] values;
                for (ParticipantRole value : values = ParticipantRole.values()) {
                    if (!value.name().equalsIgnoreCase(participantRoleString)) continue;
                    result = value;
                    break;
                }
            }
            return result;
        }

        static {
            TAG = ParticipantRole.class.getSimpleName();
        }
    }
}

