/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing;

public enum FileSharingType {
    PDF(CommonFileType.DOCUMENT),
    DOCX(CommonFileType.DOCUMENT),
    PPTX(CommonFileType.DOCUMENT),
    XLSX(CommonFileType.DOCUMENT),
    JPEG(CommonFileType.IMAGE),
    JPG(CommonFileType.IMAGE),
    PNG(CommonFileType.IMAGE),
    GIF(CommonFileType.IMAGE),
    VOICE(CommonFileType.AUDIO),
    UNKNOWN(CommonFileType.NOT_SUPPORTED);

    private CommonFileType mCommonFileType;

    private FileSharingType(CommonFileType commonFileType) {
        this.mCommonFileType = commonFileType;
    }

    public CommonFileType getCommonFileType() {
        return this.mCommonFileType;
    }

    public static FileSharingType getFileTypeFromExtension(String extension) {
        switch (extension) {
            case "pdf": {
                return PDF;
            }
            case "docx": {
                return DOCX;
            }
            case "pptx": {
                return PPTX;
            }
            case "xlsx": {
                return XLSX;
            }
            case "jpeg": {
                return JPEG;
            }
            case "jpg": {
                return JPG;
            }
            case "png": {
                return PNG;
            }
            case "gif": {
                return GIF;
            }
        }
        return null;
    }

    public static enum CommonFileType {
        IMAGE,
        DOCUMENT,
        AUDIO,
        NOT_SUPPORTED;

    }
}

