/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.net.Uri;
import android.text.TextUtils;
import com.liveperson.api.response.model.ConversationINCADetails;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.IncaGetConversationsListResponse;
import java.util.ArrayList;

public class IncaGetConversationsListRequest
implements Command {
    private static final String TAG = IncaGetConversationsListRequest.class.getSimpleName();
    private static final String GET_CONVERSATION_LIST_API_URL = "https://%s/messaging_history/api/account/%s/conversations/consumer/metadata/%s";
    private static final String SEARCH_QUERY = "search";
    private static final int REQUEST_TIMEOUT = 30000;
    public static final int MAX_LIMIT = 100;
    public static final long MAX_TIME_LIMIT = 34070400000L;
    protected final Messaging mController;
    private final long startFrom;
    private String mRequestUrl;
    private long startTo;
    private long offset;
    private String mBrand;
    ICallback<ArrayList<ConversationINCADetails>, Exception> callback;
    private ArrayList<ConversationINCADetails> fullConversationList = new ArrayList();

    public IncaGetConversationsListRequest(Messaging controller, String brand, long from, long to, long offset, ICallback<ArrayList<ConversationINCADetails>, Exception> callback) {
        this.mBrand = brand;
        this.mController = controller;
        this.callback = callback;
        long limitTime = System.currentTimeMillis() - 34070400000L;
        this.startFrom = from < limitTime ? limitTime : from;
        this.startTo = to;
        if (this.startTo < limitTime) {
            this.startTo = limitTime;
            LPMobileLog.w((String)TAG, (String)"Got startTo that is older than 13 months ago. aborting...");
            callback.onSuccess((Object)new ArrayList<ConversationINCADetails>(){});
            return;
        }
        this.offset = offset;
        if (this.startTo == this.startFrom) {
            LPMobileLog.w((String)TAG, (String)"start to == start from , no need to bring data");
            callback.onSuccess((Object)new ArrayList<ConversationINCADetails>(){});
            return;
        }
        String incaDomain = this.mController.mAccountsController.getServiceUrl(this.mBrand, "msgHist");
        if (!TextUtils.isEmpty((CharSequence)incaDomain)) {
            String historyUrl = String.format(GET_CONVERSATION_LIST_API_URL, incaDomain, this.mBrand, SEARCH_QUERY);
            Uri fullUri = Uri.parse((String)historyUrl).buildUpon().appendQueryParameter("state", "close").appendQueryParameter("startFrom", String.valueOf(this.startFrom)).appendQueryParameter("startTo", String.valueOf(this.startTo)).appendQueryParameter("offset", String.valueOf(offset)).appendQueryParameter("limit", String.valueOf(100)).appendQueryParameter("sort", "start:desc").build();
            this.mRequestUrl = fullUri.toString();
        }
    }

    public void execute() {
        if (TextUtils.isEmpty((CharSequence)this.mRequestUrl)) {
            LPMobileLog.d((String)TAG, (String)"mRequestUrl is empty");
            return;
        }
        if (this.mController.mAccountsController.getAccount(this.mBrand) == null) {
            LPMobileLog.d((String)TAG, (String)"mAccountsController is empty");
            return;
        }
        this.mController.setStillBusyFetching(true);
        LPMobileLog.d((String)TAG, (String)("Getting inca conversation list url " + this.mRequestUrl));
        HttpGetRequest httpGetRequest = new HttpGetRequest(this.mRequestUrl);
        httpGetRequest.addHeader("Authorization", "Bearer " + this.mController.mAccountsController.getAccount(this.mBrand).getToken());
        httpGetRequest.setCertificatePinningKeys(this.mController.mAccountsController.getCertificatePinningKeys(this.mBrand));
        httpGetRequest.setTimeout(30000);
        httpGetRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String response) {
                try {
                    LPMobileLog.d((String)TAG, (String)("onSuccess with INCA history response details " + response));
                    if (TextUtils.isEmpty((CharSequence)response)) {
                        IncaGetConversationsListRequest.this.mController.setStillBusyFetching(false);
                        IncaGetConversationsListRequest.this.callback.onError((Throwable)new Exception("Empty response"));
                        return;
                    }
                    IncaGetConversationsListResponse historyResponse = new IncaGetConversationsListResponse(response);
                    if (historyResponse.getListOfConversations() == null) {
                        IncaGetConversationsListRequest.this.mController.setStillBusyFetching(false);
                        IncaGetConversationsListRequest.this.callback.onError((Throwable)new Exception("Empty conversation list from INCA"));
                        return;
                    }
                    LPMobileLog.d((String)TAG, (String)("onSuccess with INCA history: got " + historyResponse.getListOfConversations().size() + " num of total conversations: " + historyResponse.getNumOfResults()));
                    IncaGetConversationsListRequest.this.fullConversationList.addAll(historyResponse.getListOfConversations());
                    if (!TextUtils.isEmpty((CharSequence)historyResponse.mNextUrl)) {
                        IncaGetConversationsListRequest.this.mRequestUrl = historyResponse.mNextUrl;
                        LPMobileLog.d((String)TAG, (String)"More results available, sending next request...");
                        IncaGetConversationsListRequest.this.execute();
                    } else {
                        IncaGetConversationsListRequest.this.mController.setStillBusyFetching(false);
                        IncaGetConversationsListRequest.this.callback.onSuccess((Object)IncaGetConversationsListRequest.this.fullConversationList);
                    }
                }
                catch (Exception e) {
                    IncaGetConversationsListRequest.this.mController.setStillBusyFetching(false);
                    LPMobileLog.e((String)TAG, (String)"Error parsing inca conversation list.", (Throwable)e);
                    IncaGetConversationsListRequest.this.callback.onError((Throwable)e);
                }
            }

            public void onError(Exception exception) {
                LPMobileLog.e((String)TAG, (String)"Exception running inca conversation list.", (Throwable)exception);
                IncaGetConversationsListRequest.this.mController.setStillBusyFetching(false);
                if (IncaGetConversationsListRequest.this.fullConversationList.isEmpty()) {
                    IncaGetConversationsListRequest.this.callback.onError((Throwable)exception);
                } else {
                    IncaGetConversationsListRequest.this.callback.onSuccess((Object)IncaGetConversationsListRequest.this.fullConversationList);
                }
            }
        });
        HttpHandler.execute((HttpRequest)httpGetRequest);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

