/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import androidx.annotation.Nullable;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UpdateConversationField;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import org.json.JSONException;
import org.json.JSONObject;

public class CloseDialogRequest
extends BaseAMSSocketRequest<ReqBody.StringResp, CloseDialogRequest> {
    private static final String TAG = CloseDialogRequest.class.getSimpleName();
    private final String conversationId;
    private final String dialogIdToClose;
    private final String closingCause;
    @Nullable
    private ICallback<Integer, Exception> callback;

    public CloseDialogRequest(String socketUrl, String dialogId, String conversationId, String closingCause) {
        super(socketUrl);
        this.conversationId = conversationId;
        this.dialogIdToClose = dialogId;
        this.closingCause = closingCause;
    }

    protected String getData() {
        return new UpdateConversationField(this.dialogIdToClose, this.conversationId, "DialogChange", this.closingCause, DialogState.CLOSE).toJsonString(this.getRequestId());
    }

    public CloseDialogRequest setCallback(@Nullable ICallback<Integer, Exception> callback) {
        this.callback = callback;
        return this;
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, CloseDialogRequest>(){

            public String getAPIResponseType() {
                return null;
            }

            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            protected boolean handle(ReqBody.StringResp data) {
                if (data.code >= 200 && data.code < 300) {
                    LPMobileLog.d((String)TAG, (String)("Succeeded, close dialog response code: " + data.code));
                    if (CloseDialogRequest.this.callback != null) {
                        CloseDialogRequest.this.callback.onSuccess((Object)data.code);
                    }
                } else {
                    LPMobileLog.e((String)TAG, (String)("Error, close dialog response code: " + data.code));
                    if (CloseDialogRequest.this.callback != null) {
                        CloseDialogRequest.this.callback.onError((Throwable)new Exception(String.valueOf(data.code)));
                    }
                }
                return true;
            }
        };
    }
}

