package com.liveperson.messaging.background.filesharing.voice;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.BaseUploadTask;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.commands.SendVoiceCommand;
import com.liveperson.messaging.exception.FileSharingException;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import static com.liveperson.infra.utils.Utils.getResources;

public class UploadVoiceTask extends BaseUploadTask{

	public static final String TAG = "UploadVoiceTask";

	protected UploadFileTaskBundle uploadFileTaskBundle;

	private String previewBase64;
	protected String previewContentType;

	public UploadVoiceTask(UploadFileTaskBundle params, Integer uploadTimeout) throws FileSharingException{

		super(uploadTimeout);

		if(params == null){
			throw new FileSharingException("Params is null");
		}

		uploadFileTaskBundle = params;

		// Get byte array of the voice file
		File file = new File(uploadFileTaskBundle.getFilePath());
		if (file == null) {
			throw new FileSharingException("File path is null");
		}
		int size = (int) file.length();
		byte[] bytes = new byte[size];

		try {
			BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
			buf.read(bytes, 0, bytes.length);
			buf.close();
			mOriginalFileByteArray = bytes;
		} catch (IOException e) {
			LPMobileLog.e(TAG, "UploadVoiceTask: cannot extract file byteArray. Aborting upload file", e);
			return;
		}

		generatePreviewImage();

		createSendMessageCommand(createThumbnail(), params.getFilePath());
	}

/* Getting the duration of the file was canceled for this version. This code is left here for reference and future use

	public void sendPublishFile(final boolean sendViaRest) {
		LPMobileLog.d(TAG + Thread.currentThread(), "sending PublishFile request..");

		// Before sending the message, we get the duration of the voice file and add it as the message caption.
		// If failed to get the duration we set 0 duration as the caption
		LPAudioUtils.getDuration(uploadFileTaskBundle.getFilePath(), new ICallback<Integer, Exception>() {
			@Override
			public void onSuccess(Integer durationMs) {

				LPMobileLog.d(TAG, "onSuccess: set duration " + durationMs + " ms in the message caption");
				((SendVoiceCommand)sendMessageCommand).setDurationAsCaption(durationMs);
				sendMessageCommand.setFileDetails(mRelativePath, getUploadTaskBundle().getFileTypeExtension(), getThumbnailBase64());
				sendMessageCommand.setSendViaRest(sendViaRest, getUploadTaskBundle().getRestParams());
				sendMessageCommand.execute();

			}

			@Override
			public void onError(Exception exception) {
				LPMobileLog.d(TAG, "onError: failed to get voice file duration. Set 0.");
				((SendVoiceCommand)sendMessageCommand).setDurationAsCaption(0);
				sendMessageCommand.setFileDetails(mRelativePath, getUploadTaskBundle().getFileTypeExtension(), getThumbnailBase64());
				sendMessageCommand.setSendViaRest(sendViaRest, getUploadTaskBundle().getRestParams());
				sendMessageCommand.execute();

			}
		});
	}
*/


	protected void createSendMessageCommand(String thumbnailPath, String filePath) {
		sendMessageCommand = new SendVoiceCommand(MessagingFactory.getInstance().getController(), uploadFileTaskBundle.getTargetId(), uploadFileTaskBundle.getBrandId(),
				uploadFileTaskBundle.getFileContentType(), thumbnailPath, filePath, uploadFileTaskBundle.getFileTypeExtension(), uploadFileTaskBundle.getMessage(), previewContentType);

		setSendMessageCommandCallback();
	}

	private void generatePreviewImage() {

		Bitmap bitmap = BitmapFactory.decodeResource(getResources(), R.drawable.lp_messaging_dummy_file_thumbnal);
		previewBase64 = ImageUtils.bitmapToBase64(bitmap);

		previewContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension("png");
	}

	private String createThumbnail() {
		// No need for thumbnail in voice. Only base64
		return null;
	}

	@Override
	protected UploadFileTaskBundle getUploadTaskBundle() {

		return uploadFileTaskBundle;
	}

	@Override
	protected byte[] getFileByteArray() {
		return mOriginalFileByteArray;
	}

	@Override
	public int getTaskId() {
		return uploadFileTaskBundle.getTaskId();
	}

	@Override
	public String getThumbnailBase64() {

		return previewBase64;
	}
}
