package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.requests.CSDSRequest;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsConnectionAnalytics;

import java.util.HashMap;
import java.util.List;

import javax.net.ssl.SSLPeerUnverifiedException;

/**
 * Created by Ilya Gazman on 11/16/2015.
 * <p/>
 * Base connection task to fetch CSDS
 */
public class CsdsTask extends BaseAmsAccountConnectionTask {

    private static final String TAG = "CsdsTask";
    private final AccountsController mAccountsController;

    public CsdsTask(AccountsController accountsController) {
        mAccountsController = accountsController;
    }

    @Override
    public void execute() {
        LPMobileLog.d(TAG, "Running CSDS task...");

		AmsConnectionAnalytics.csdsTaskStart();
        String domain = mAccountsController.getDomain(mBrandId);
        List<String> certificates = mAccountsController.getCertificatePinningKeys(mBrandId);

		new CSDSRequest(domain, mBrandId, certificates, new ICallback<HashMap<String, String>, Exception>() {
			@Override
			public void onSuccess(HashMap<String, String> cSDSUrls) {

				// Set the CSDS values to persistent memory. If one of the values is new, return error
				if (mAccountsController.setCSDSMap(mBrandId, cSDSUrls)){
					LPMobileLog.d(TAG, "onSuccess: One of the CSDS values had changed. Return error");
					AmsConnectionAnalytics.csdsTaskEnd();
					mCallback.onTaskError(TaskType.CSDS, new Exception("New CSDS values were set."));
					return;
				}
				AmsConnectionAnalytics.csdsTaskEnd();
				mCallback.onTaskSuccess();
			}

			@Override
			public void onError(Exception e) {
				if(e instanceof SSLPeerUnverifiedException){
					mCallback.onTaskError(TaskType.INVALID_CERTIFICATE, e);
				}else {
					mCallback.onTaskError(TaskType.CSDS, e);
				}
			}
		}).execute();
    }

    @Override
    public String getName() {
        return TAG;
    }
}