package com.liveperson.messaging.model

import com.liveperson.infra.log.LPMobileLog

/**
 * Model representing a Consumer's personal info, that an Agent may need to better
 * assist them.
 */
data class UserProfile(
		val firstName: String?,
		val lastName: String?,
		val phoneNumber: String?,
		val nickname: String?,
		val avatarUrl: String?
) {

	init {
		LPMobileLog.v(TAG, "Built a $this")
	}

	class Builder {
		private var firstName: String? = null
		private var lastName: String? = null
		private var phoneNumber: String? = null
		private var nickname: String? = null
		private var avatarUrl: String? = null

		fun firstName(firstName: String?) = apply { this.firstName = firstName }
		fun lastName(lastName: String?) = apply { this.lastName = lastName }
		fun nickname(nickname: String?) = apply { this.nickname = nickname }
		fun phoneNumber(phoneNumber: String?) = apply { this.phoneNumber = phoneNumber }
		fun avatarUrl(avatarUrl: String?) = apply { this.avatarUrl = avatarUrl }

		fun build(): UserProfile {
			return UserProfile(firstName, lastName, nickname, phoneNumber, avatarUrl)
		}
	}

	companion object {
		private const val TAG = "UserProfile"
	}
}
