package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.UnsubscribeExConversations;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by eyalv on 11/15/15.
 */
public class UnSubscribeExConversationsRequest extends BaseAMSSocketRequest<ReqBody.StringResp, UnSubscribeExConversationsRequest> {

    private static final String TAG = UnSubscribeExConversationsRequest.class.getSimpleName();
    private String mSubscriptionId;

    public UnSubscribeExConversationsRequest(String socketUrl, String subscriptionId) {
        super(socketUrl);
        mSubscriptionId = subscriptionId;
    }

    @Override
    protected String getData() {
        return new UnsubscribeExConversations(mSubscriptionId).toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler<ReqBody.StringResp, UnSubscribeExConversationsRequest> getResponseHandler() {
        return new BaseResponseHandler<ReqBody.StringResp, UnSubscribeExConversationsRequest>() {
            @Override
            public String getAPIResponseType() {
                return ReqBody.StringResp.REQ_BODY_RESPONSE_TYPE;
            }

            @Override
            protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                return new ReqBody.StringResp(jsonObject);
            }

            @Override
            protected boolean handle(ReqBody.StringResp response) {
                if (response == null){
                    LPMobileLog.w(TAG, "Received response null for UnSubscribe request");
                    return true;
                }
                switch (response.code){
                    case 200:
                        LPMobileLog.d(TAG, "Received response code 200");
                        break;
                    case 400:
                        LPMobileLog.d(TAG, "Can't un subscribe (response code 400)");
                        break;
                    default:
                        LPMobileLog.w(TAG, "Received response code other than 200 (" + response.code + ").");
                        break;

                }
                return true;
            }
        };
    }
}