package com.liveperson.messaging.structuredcontent.parsers;


import androidx.annotation.Nullable;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.structuredcontent.model.actions.BaseAction;
import com.liveperson.messaging.structuredcontent.model.actions.LinkAction;
import com.liveperson.messaging.structuredcontent.model.actions.NavigateAction;
import com.liveperson.messaging.structuredcontent.model.actions.PublishTextAction;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by nirni on 2/2/17.
 * Parser for actions
 */
public class ActionParser {

	public static final String TAG = ActionParser.class.getSimpleName();

	/**
	 * Parse the action from the given json.
	 * @param actionArray Actions array
	 * @param metadataJsonArray metadata json to be sent with a publish text action
	 * @return
	 * @throws JSONException
	 */
	public static List<BaseAction> parse(JSONArray actionArray, @Nullable JSONArray metadataJsonArray) {

		// Action to return
		List<BaseAction> actionList;
		BaseAction actionToAdd;

		if (actionArray == null) {
			LPMobileLog.w(TAG, "parse: empty json");
			return null;
		}
		try {

			actionList = new ArrayList<>();

			for (int i = 0; i < actionArray.length(); i++) {

				// Get the action
				JSONObject actionObject = actionArray.getJSONObject(i);
				// Get the type of the action
				String type = actionObject.getString(ElementType.TYPE);

				switch (type) {
					case ElementType.LINK:
						actionToAdd = new LinkAction(actionObject);
						break;
					case ElementType.NAVIGATE:
						actionToAdd = new NavigateAction(actionObject);
						break;
					case ElementType.PUBLISH_TEXT:
						actionToAdd = new PublishTextAction(actionObject, metadataJsonArray);
						break;
					default:
						return null;
				}

				actionList.add(actionToAdd);
			}

		} catch (JSONException e) {
			LPMobileLog.w(TAG, "parse: error parsing action. Return null", e);
			return null;
		}

		return actionList;
	}
}
