/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import androidx.annotation.Nullable;
import com.liveperson.api.LivePersonCallback;
import com.liveperson.api.request.GeneratedUploadTokenField;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.callbacks.InitLivePersonCallBack;
import com.liveperson.infra.callbacks.LogoutLivePersonCallBack;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.network.socket.GeneralResponseHandler;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.sdkstatemachine.init.InfraInitData;
import com.liveperson.infra.sdkstatemachine.logout.PreLogoutCompletionListener;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownAsync;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;
import com.liveperson.infra.statemachine.InitProcess;
import com.liveperson.infra.statemachine.LogoutProcess;
import com.liveperson.infra.statemachine.ShutDownProcess;
import com.liveperson.infra.utils.FileUtils;
import com.liveperson.infra.utils.LPAudioUtils;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.infra.utils.MessageValidator;
import com.liveperson.messaging.ActionFailureReason;
import com.liveperson.messaging.GeneralMessagingResponseHandler;
import com.liveperson.messaging.IMessaging;
import com.liveperson.messaging.LivePersonEventsProxy;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.MessagingInitData;
import com.liveperson.messaging.background.BackgroundActionsService;
import com.liveperson.messaging.background.FileSharingManager;
import com.liveperson.messaging.background.filesharing.FileExtensionTypes;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.commands.ChangeChatStateCommand;
import com.liveperson.messaging.commands.ChangeConversationTTRCommand;
import com.liveperson.messaging.commands.CloseDialogCommand;
import com.liveperson.messaging.commands.DeliveryStatusUpdateCommand;
import com.liveperson.messaging.commands.GetCombinedUnreadMessagesCountCommand;
import com.liveperson.messaging.commands.GetUnreadMessagesCountCommand;
import com.liveperson.messaging.commands.RegisterPusherCommand;
import com.liveperson.messaging.commands.ResendMessageCommand;
import com.liveperson.messaging.commands.ResendURLMessageCommand;
import com.liveperson.messaging.commands.ResolveConversationCommand;
import com.liveperson.messaging.commands.SendCsatCommand;
import com.liveperson.messaging.commands.SendFormSubmissionMessageCommand;
import com.liveperson.messaging.commands.SendGenerateUploadTokenCommand;
import com.liveperson.messaging.commands.SendMessageCommand;
import com.liveperson.messaging.commands.SendMessageWithURLCommand;
import com.liveperson.messaging.commands.SendSetUserProfileCommand;
import com.liveperson.messaging.commands.UnregisterPusherCommand;
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.controller.AmsReadController;
import com.liveperson.messaging.controller.ClientProperties;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.model.AgentData;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsFiles;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.Form;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.model.QuickRepliesMessageHolder;
import com.liveperson.messaging.model.UserProfile;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Messaging
implements IMessaging,
ShutDownAsync,
Clearable {
    private static final String TAG = Messaging.class.getSimpleName();
    public static final int NO_FILE_ROW_ID = -1;
    public static final String SUBMISSION_ID = "submissionId";
    public static final String INVITATION_ID = "invitationId";
    public static final String FORM_TITLE = "formTitle";
    public ConnectionsController mConnectionController;
    public AccountsController mAccountsController;
    public AmsMessages amsMessages;
    public AmsConversations amsConversations;
    public AmsDialogs amsDialogs;
    public AmsUsers amsUsers;
    public AmsFiles amsFiles;
    private boolean isStillBusyFetching;
    private boolean mUploadUsingService;
    ClientProperties mClientProperties;
    public AmsReadController amsReadController;
    public LivePersonEventsProxy mEventsProxy = new LivePersonEventsProxy();
    private MessageValidator mMessageValidator;
    private FileSharingManager mFileSharingManager;
    private PendingIntent mImageServicePendingIntent = null;
    private Notification.Builder mImageForegroundServiceUploadNotificationBuilder = null;
    private Notification.Builder mImageForegroundServiceDownloadNotificationBuilder = null;
    private boolean mEnableStructuredContent;
    private MessagingEventSubscriptionManager mMessagingEventSubscriptionManager;
    private ConversationViewParams mConversationViewParams;
    private LPAudioUtils mAudioUtils;
    private int mMaxNumberOfStoredImageFiles;
    private int mMaxNumberOfStoredVoiceFiles;
    private int mMaxNumberofStoredDocumentFiles;
    private Context mContext;

    private void initMembers(Context context) {
        this.mConnectionController = new ConnectionsController(this);
        this.mAccountsController = new AccountsController(this.mClientProperties);
        this.amsMessages = new AmsMessages(this);
        this.amsConversations = new AmsConversations(this);
        this.amsDialogs = new AmsDialogs(this);
        this.amsUsers = new AmsUsers();
        this.amsFiles = new AmsFiles();
        this.amsReadController = new AmsReadController(this);
        this.mUploadUsingService = Configuration.getBoolean((int)R.bool.upload_photo_using_service);
        this.mFileSharingManager = new FileSharingManager(this, context);
        this.mEnableStructuredContent = Configuration.getBoolean((int)R.bool.enable_structured_content);
        this.mMessagingEventSubscriptionManager = new MessagingEventSubscriptionManager();
        this.mMaxNumberOfStoredImageFiles = Configuration.getInteger((int)R.integer.max_number_stored_images);
        this.mMaxNumberOfStoredVoiceFiles = Configuration.getInteger((int)R.integer.max_number_stored_voice_files);
        this.mMaxNumberofStoredDocumentFiles = Configuration.getInteger((int)R.integer.max_number_stored_documents);
        this.mAudioUtils = new LPAudioUtils();
    }

    @Override
    public void init(final Context context, final MessagingInitData initData, final InitLivePersonCallBack callBack) {
        this.init(context, initData, new InitProcess(){

            public void init() {
                Messaging.this.initMessaging(context, initData);
            }

            public InitLivePersonCallBack getInitCallback() {
                return callBack;
            }
        });
    }

    @Override
    public void init(final Context context, final MessagingInitData initData, final InitProcess initProcess) {
        Infra.instance.init(context, (InfraInitData)initData, new InitProcess(){

            public InitLivePersonCallBack getInitCallback() {
                return initProcess.getInitCallback();
            }

            public void init() {
                Messaging.this.initMessaging(context, initData);
                initProcess.init();
            }
        });
    }

    MessageValidator getMessageValidator(String brandId) {
        if (this.mMessageValidator == null) {
            if (this.mAccountsController.getAccount(brandId) == null) {
                return null;
            }
            boolean isAuthenticated = this.mAccountsController.getAccount(brandId).isAuthenticated();
            this.mMessageValidator = new MessageValidator(this.mContext, isAuthenticated);
        }
        return this.mMessageValidator;
    }

    private void initMessaging(Context context, MessagingInitData initData) {
        LPMobileLog.d((String)TAG, (String)"Initializing...");
        this.updateClientProperties(initData);
        this.initMembers(context);
        this.mConnectionController.initConnectionReceiver();
        this.bootstrapRegistration();
        this.setContext(Infra.instance.getApplicationContext());
    }

    private void updateClientProperties(MessagingInitData initData) {
        if (initData != null) {
            this.mClientProperties = new ClientProperties(initData.getAppId(), initData.getSdkVersion());
        } else if (this.mClientProperties == null) {
            this.mClientProperties = new ClientProperties();
        }
    }

    public void updateWelcomeMessage(String brandId) {
        if (this.isConversationEmptyOrClose(brandId)) {
            LPWelcomeMessage welcomeMessage = this.mConversationViewParams.getLpWelcomeMessage();
            ConversationUtils conversationUtils = new ConversationUtils(MessagingFactory.getInstance().getController());
            conversationUtils.updateWelcomeMessage(brandId, welcomeMessage);
            this.amsMessages.resetQuickRepliesMessageHolder();
            QuickRepliesMessageHolder.updateQuickReplies(brandId, welcomeMessage.getQuickReplies(false));
        }
    }

    public boolean isConversationEmptyOrClose(String brandId) {
        Conversation conversation = this.amsConversations.getConversationFromTargetIdMap(brandId);
        return conversation == null || conversation.getState() == ConversationState.CLOSE;
    }

    protected void bootstrapRegistration() {
        SocketManager.getInstance().putGeneralHandlerMap((GeneralResponseHandler)new GeneralMessagingResponseHandler(this));
    }

    @Override
    public void connect(String brandId, LPAuthenticationParams lpAuthenticationParams, @Nullable ConversationViewParams conversationViewParams, boolean connectInBackground, boolean clearToken) {
        this.initBrand(brandId, lpAuthenticationParams, conversationViewParams);
        LPMobileLog.d((String)TAG, (String)("Connecting to brand " + brandId));
        this.mConnectionController.connect(brandId, connectInBackground, clearToken);
    }

    @Override
    public void connect(String brandId, LPAuthenticationParams lpAuthenticationParams, @Nullable ConversationViewParams conversationViewParams) {
        this.connect(brandId, lpAuthenticationParams, conversationViewParams, false, false);
    }

    @Override
    public void reconnect(String brandId, LPAuthenticationParams lpAuthenticationParams) {
        boolean isTokenExpired = this.mAccountsController.isTokenExpired(brandId);
        LPMobileLog.d((String)TAG, (String)("reconnect: set a new authentication key for brand with lpAuthenticationParams of type " + lpAuthenticationParams.getAuthType()));
        if (isTokenExpired) {
            LPMobileLog.d((String)TAG, (String)"reconnect called clearing Token as TokenExpired");
            this.connect(brandId, lpAuthenticationParams, null, false, true);
        }
    }

    @Override
    public void disconnect(String brandId) {
        LPMobileLog.d((String)TAG, (String)("Disconnecting from brand " + brandId));
        this.mConnectionController.disconnect(brandId);
    }

    @Override
    public void moveToBackground(String brandId, long timeout) {
        MessagingFactory.getInstance().getController().getAudioUtils().getPlayingAudioManager().stopAllCurrentlyPlaying();
        this.mConnectionController.moveToBackground(brandId, timeout);
    }

    @Override
    public void moveToForeground(String brandId, LPAuthenticationParams lpAuthenticationParams, @Nullable ConversationViewParams conversationViewParams) {
        LPMobileLog.d((String)TAG, (String)("moveToForeground: brandId = " + brandId));
        this.initBrand(brandId, lpAuthenticationParams, conversationViewParams);
        this.mConnectionController.moveToForeground(brandId);
    }

    @Override
    public void serviceStarted(String brandId) {
        LPMobileLog.d((String)TAG, (String)("serviceStarted: brandId = " + brandId));
        this.mConnectionController.serviceStarted(brandId);
    }

    @Override
    public void serviceStopped(String brandId) {
        LPMobileLog.d((String)TAG, (String)("serviceStopped: brandId = " + brandId));
        this.mConnectionController.serviceStopped(brandId);
    }

    protected void initBrand(String brandId, LPAuthenticationParams lpAuthenticationParams, @Nullable ConversationViewParams conversationViewParams) {
        LPMobileLog.d((String)TAG, (String)("Init brand " + brandId));
        this.mAccountsController.addNewAccount(brandId);
        this.mAccountsController.setLPAuthenticationParams(brandId, lpAuthenticationParams);
        if (conversationViewParams != null) {
            this.setConversationViewParams(conversationViewParams);
        }
        this.mConnectionController.addNewConnection(brandId);
    }

    public void onMessageTimeout(String brandId) {
        this.mConnectionController.connect(brandId);
    }

    @Override
    public void sendMessageWithURL(String targetId, String brandId, String message, String urlToParse, String title, String description, String imageURL, String siteName) {
        MaskedMessage maskedMessage = this.getMessageValidator(brandId).maskMessage(message, true);
        new SendMessageWithURLCommand(this, targetId, brandId, maskedMessage, urlToParse, title, description, imageURL, siteName).execute();
    }

    @Override
    public void sendMessage(String targetId, String brandId, String message, @Nullable DeliveryStatusUpdateInfo info) {
        MaskedMessage maskedMessage = this.getMessageValidator(brandId).maskMessage(message, true);
        new SendMessageCommand(this, targetId, brandId, maskedMessage, info).execute();
    }

    @Override
    public MaskedMessage getMaskedMessage(String brandId, String message) {
        return this.getMessageValidator(brandId).maskMessage(message, true);
    }

    @Override
    public int resendMessage(String eventId, String dialogId, MessagingChatMessage.MessageType messageType) {
        return this.resendMessage(eventId, dialogId, -1L, messageType);
    }

    @Override
    public int resendMessage(final String eventId, final String dialogId, final long fileRowId, final MessagingChatMessage.MessageType messageType) {
        if (this.isDialogClosed(dialogId)) {
            LPMobileLog.i((String)TAG, (String)"Resend message- conversation does not exists or closed.");
            return R.string.lp_resend_failed_conversation_closed;
        }
        if (MessagingChatMessage.MessageType.isConsumerMaskedMessage(messageType)) {
            LPMobileLog.i((String)TAG, (String)"Resend message- message is masked, resend is not available.");
            return R.string.lp_resend_failed_masked_message;
        }
        this.amsMessages.getMessageByEventId(eventId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<MessagingChatMessage>(){

            public void onResult(MessagingChatMessage data) {
                Dialog dialog = (Dialog)Messaging.this.amsDialogs.queryDialogById(dialogId).executeSynchronously();
                if (data != null) {
                    String message = data.getMessage();
                    if (messageType == MessagingChatMessage.MessageType.CONSUMER_IMAGE || messageType == MessagingChatMessage.MessageType.CONSUMER_DOCUMENT) {
                        String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(data.getContentType());
                        Messaging.this.reSendFileMessage(FileSharingType.getFileTypeFromExtension(extension), dialog.getBrandId(), dialog.getTargetId(), eventId, message, data.getTimeStamp(), fileRowId);
                    } else if (messageType == MessagingChatMessage.MessageType.CONSUMER_VOICE) {
                        Messaging.this.reSendFileMessage(FileSharingType.VOICE, dialog.getBrandId(), dialog.getTargetId(), eventId, message, data.getTimeStamp(), fileRowId);
                    } else if (messageType == MessagingChatMessage.MessageType.CONSUMER_URL) {
                        MaskedMessage maskedMessage = Messaging.this.getMessageValidator(dialog.getBrandId()).maskMessage(message, true);
                        new ResendURLMessageCommand(Messaging.this, eventId, dialog.getTargetId(), dialog.getBrandId(), maskedMessage).execute();
                    } else {
                        ResendMessageCommand resendMessageCommand;
                        MaskedMessage maskedMessage = Messaging.this.getMessageValidator(dialog.getBrandId()).maskMessage(message, true);
                        if (TextUtils.isEmpty((CharSequence)data.getMetadata())) {
                            resendMessageCommand = new ResendMessageCommand(Messaging.this, eventId, dialog.getTargetId(), dialog.getBrandId(), maskedMessage);
                        } else {
                            try {
                                JSONArray metadata = new JSONArray(data.getMetadata());
                                resendMessageCommand = new ResendMessageCommand(Messaging.this, eventId, dialog.getTargetId(), dialog.getBrandId(), maskedMessage, new DeliveryStatusUpdateInfo(metadata));
                            }
                            catch (JSONException e) {
                                LPMobileLog.e((String)TAG, (String)"Failed to parse JSON", (Throwable)e);
                                resendMessageCommand = new ResendMessageCommand(Messaging.this, eventId, dialog.getTargetId(), dialog.getBrandId(), maskedMessage);
                            }
                        }
                        resendMessageCommand.execute();
                    }
                }
            }
        }).execute();
        return -1;
    }

    public boolean isDialogClosed(String dialogId) {
        boolean isDialogClosed = false;
        Dialog dialog = this.amsDialogs.getDialogById(dialogId);
        if (dialog == null || dialog.getState() == DialogState.CLOSE) {
            LPMobileLog.d((String)TAG, (String)("isDialogClosed - dialog (dialogId = " + dialogId + ") does not exists or closed. (dialog = " + (dialog == null ? "null" : dialog.getState()) + ")"));
            isDialogClosed = true;
        }
        return isDialogClosed;
    }

    private void reSendFileMessage(FileSharingType fileSharingType, String brandId, String targetId, String eventId, String message, long originalMessageTime, long fileRowId) {
        Context applicationContext = Infra.instance.getApplicationContext();
        if (!this.mUploadUsingService) {
            LPMobileLog.d((String)TAG, (String)"reSendImageMessage: re-uploading photo without a service");
            this.mFileSharingManager.reUploadFile(fileSharingType, brandId, targetId, message, eventId, originalMessageTime, fileRowId, new FileSharingManager.FileUploadProgressListener(){

                @Override
                public void onDoneUpload() {
                    LPMobileLog.d((String)TAG, (String)"onDoneUpload!");
                }

                @Override
                public void onFailedUpload(Throwable exception) {
                    LPMobileLog.d((String)TAG, (String)"onFailedUpload! ", (Throwable)exception);
                }
            });
        } else {
            LPMobileLog.d((String)TAG, (String)"reSendImageMessage: re-uploading photo using a service");
            Intent intent = new Intent(applicationContext, BackgroundActionsService.class);
            intent.putExtra("extra_action_type", 3);
            intent.putExtra("extra_file_type", fileSharingType.ordinal());
            intent.putExtra("service_extra_brand_id", brandId);
            intent.putExtra("service_extra_target_id", targetId);
            intent.putExtra("service_extra_message", message);
            intent.putExtra("service_extra_event_id", eventId);
            intent.putExtra("extra_original_message_time", originalMessageTime);
            intent.putExtra("service_extra_file_row_id", fileRowId);
            applicationContext.startService(intent);
        }
    }

    @Override
    public void sendFileMessage(FileSharingType fileSharingType, String brandId, String targetId, String imageUriString, String message, boolean imageFromCamera) {
        Context applicationContext = Infra.instance.getApplicationContext();
        if (this.mUploadUsingService) {
            LPMobileLog.d((String)TAG, (String)"startUploadPhoto: uploading photo using a service");
            Intent intent = new Intent(applicationContext, BackgroundActionsService.class);
            intent.putExtra("extra_action_type", 1);
            intent.putExtra("extra_file_type", fileSharingType.ordinal());
            intent.putExtra("service_extra_brand_id", brandId);
            intent.putExtra("service_extra_target_id", targetId);
            intent.putExtra("service_extra_file_uri", imageUriString);
            intent.putExtra("service_extra_file_caption", message);
            intent.putExtra("service_extra_image_from_camera", imageFromCamera);
            applicationContext.startService(intent);
        } else {
            LPMobileLog.d((String)TAG, (String)"startUploadPhoto: uploading photo without a service");
            this.mFileSharingManager.uploadFile(fileSharingType, brandId, targetId, imageUriString, message, imageFromCamera, new FileSharingManager.FileUploadProgressListener(){

                @Override
                public void onDoneUpload() {
                    LPMobileLog.d((String)TAG, (String)"onDoneUpload!");
                }

                @Override
                public void onFailedUpload(Throwable exception) {
                    LPMobileLog.d((String)TAG, (String)"onFailedUpload! ", (Throwable)exception);
                    Infra.instance.getApplicationHandler().post(() -> Toast.makeText((Context)Infra.instance.getApplicationContext(), (int)R.string.lp_failed_upload_toast_message, (int)1).show());
                }
            });
        }
    }

    @Override
    public void downloadFile(FileSharingType fileSharingType, String brandId, String targetId, String imageSwiftPath, long messageRowId, long fileRowId, String conversationId) {
        Context applicationContext = Infra.instance.getApplicationContext();
        if (this.mUploadUsingService) {
            LPMobileLog.d((String)TAG, (String)"startUploadPhoto: uploading photo using a service");
            Intent intent = new Intent(applicationContext, BackgroundActionsService.class);
            intent.putExtra("extra_action_type", 2);
            intent.putExtra("extra_file_type", fileSharingType.ordinal());
            intent.putExtra("service_extra_brand_id", brandId);
            intent.putExtra("service_extra_target_id", targetId);
            intent.putExtra("service_extra_file_uri", imageSwiftPath);
            intent.putExtra("service_extra_file_row_id", fileRowId);
            intent.putExtra("service_extra_message_row_id", messageRowId);
            intent.putExtra("extra_conversation_id", conversationId);
            applicationContext.startService(intent);
        } else {
            this.mFileSharingManager.downloadFile(fileSharingType, brandId, targetId, imageSwiftPath, messageRowId, fileRowId, conversationId, new FileSharingManager.FileDownloadProgressListener(){

                @Override
                public void onDoneDownload() {
                    LPMobileLog.d((String)TAG, (String)"onDoneDownload!");
                }

                @Override
                public void onFailedDownload(Throwable exception) {
                    LPMobileLog.d((String)TAG, (String)"onFailedDownload! ", (Throwable)exception);
                    Infra.instance.getApplicationHandler().post(() -> Toast.makeText((Context)Infra.instance.getApplicationContext(), (int)R.string.lp_failed_download_toast_message, (int)1).show());
                }
            });
        }
    }

    @Override
    public void generateUploadToken(String formId, String brandId, final String invitationId) {
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        if (activeDialog == null) {
            LPMobileLog.e((String)TAG, (String)"Failed to generate upload token, there's no active dialog!");
            MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(invitationId).setFormStatus(Form.FormStatus.ERROR);
            MessagingFactory.getInstance().getController().amsMessages.setDeliveryStatusUpdateCommand(MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(invitationId), DeliveryStatus.ERROR);
        } else {
            new SendGenerateUploadTokenCommand(this.mAccountsController.getConnectionUrl(brandId), formId, activeDialog.getDialogId(), invitationId, new ICallback(){

                public void onSuccess(Object value) {
                    Messaging.this.amsMessages.mFormsManager.updateForm(invitationId, ((GeneratedUploadTokenField.Response.Body)value).readOtk, ((GeneratedUploadTokenField.Response.Body)value).writeOtk);
                    Form currentForm = Messaging.this.amsMessages.mFormsManager.getForm(invitationId);
                    if (currentForm == null) {
                        LPMobileLog.d((String)TAG, (String)"no form was found ");
                        return;
                    }
                    String url = currentForm.getOpenFormURL();
                    LPMobileLog.d((String)TAG, (String)("url = " + url));
                    Bundle bundle = new Bundle();
                    bundle.putString("url", url);
                    bundle.putString("invitation_id", invitationId);
                    bundle.putString("form_title", currentForm.getFormTitle());
                    LPMobileLog.d((String)TAG, (String)("Sending PCI update invitationId = " + invitationId + " form title : " + currentForm.getFormTitle()));
                    LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_FORM_URL", (Bundle)bundle);
                }

                public void onError(Throwable exception) {
                    LPMobileLog.w((String)TAG, (String)"an error during generating OTK", (Throwable)exception);
                    MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(invitationId).setFormStatus(Form.FormStatus.ERROR);
                    MessagingFactory.getInstance().getController().amsMessages.setDeliveryStatusUpdateCommand(MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(invitationId), DeliveryStatus.ERROR);
                }
            }).execute();
        }
    }

    @Override
    public void sendFormSubmissionMessageCommand(String invitationId) {
        Form currentForm = this.amsMessages.mFormsManager.getForm(invitationId);
        try {
            JSONObject jo = new JSONObject();
            jo.put(SUBMISSION_ID, (Object)currentForm.getSubmissionId());
            jo.put(INVITATION_ID, (Object)currentForm.getInvitationId());
            this.amsMessages.mFormsManager.updateForm(currentForm.getInvitationId(), currentForm.getSubmissionId());
            Dialog dialog = this.amsDialogs.getDialogById(currentForm.getDialogId());
            MaskedMessage maskedMessage = this.getMessageValidator(dialog.getBrandId()).maskMessage(jo.toString(), false);
            if (maskedMessage == null) {
                currentForm.setFormStatus(Form.FormStatus.ERROR);
                this.updateMessage(currentForm.getInvitationId(), currentForm.getDialogId(), MessagingChatMessage.MessageType.AGENT_FORM, MessagingChatMessage.MessageState.ERROR);
                return;
            }
            maskedMessage.setServerMessage(jo.toString());
            jo.put(FORM_TITLE, (Object)currentForm.getFormTitle());
            maskedMessage.setDbMessage(jo.toString());
            new SendFormSubmissionMessageCommand(currentForm, maskedMessage, this).execute();
            this.updateMessage(currentForm.getInvitationId(), currentForm.getDialogId(), MessagingChatMessage.MessageType.AGENT_FORM, MessagingChatMessage.MessageState.SUBMITTED);
        }
        catch (JSONException e) {
            LPMobileLog.e((String)TAG, (String)"JSONException while constructing JSON Object.", (Throwable)e);
        }
    }

    @Override
    public void updateMessage(String invitationId, String dialogId, MessagingChatMessage.MessageType messageType, MessagingChatMessage.MessageState messageState) {
        Form currentForm = this.amsMessages.mFormsManager.getForm(invitationId);
        if (currentForm == null) {
            LPMobileLog.i((String)TAG, (String)"pci update message- form does not exists or closed.");
            return;
        }
        Dialog dialog = this.amsDialogs.getDialogById(dialogId);
        if (dialog == null || dialog.getState() == DialogState.CLOSE) {
            LPMobileLog.i((String)TAG, (String)"pci update message- dialog does not exists or closed.");
            return;
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(currentForm.getEventId());
        LPMobileLog.i((String)TAG, (String)("pci update message- with eventID " + currentForm.getEventId() + " to state: " + (Object)((Object)messageState)));
        this.amsMessages.updateMessagesState(l, currentForm.getSiteId(), currentForm.getDialogId(), messageState);
    }

    @Override
    public void removeMultipleOlderImages(Context mContext, String targetId, String brandId) {
        LPMobileLog.d((String)TAG, (String)"removeMultipleOlderFiles without service");
        this.mFileSharingManager.removeMultipleOlderFiles(targetId, this.mMaxNumberOfStoredImageFiles, FileExtensionTypes.getImageExtensionsAsSqlString());
        this.mFileSharingManager.removeMultipleOlderFiles(targetId, this.mMaxNumberOfStoredVoiceFiles, FileExtensionTypes.getVoiceExtensionsAsSqlString());
        this.mFileSharingManager.removeMultipleOlderFiles(targetId, this.mMaxNumberofStoredDocumentFiles, FileExtensionTypes.getDocumentExtensionsAsSqlString());
    }

    @Override
    public void registerPusher(String brandId, String appId, String token, LPAuthenticationParams authenticationParams, ICallback<Void, Exception> registrationCompletedCallback) {
        new RegisterPusherCommand(this, brandId, appId, token, authenticationParams, registrationCompletedCallback).execute();
    }

    @Override
    public void updateTokenInBackground(String brandId, LPAuthenticationParams authenticationParams) {
        LPMobileLog.d((String)TAG, (String)"updateTokenInBackground: Clearing token from account");
        this.connect(brandId, authenticationParams, null, true, true);
    }

    @Override
    public void unregisterPusher(String brandId, String appId, ICallback<Void, Exception> unregisteringCompletedCallback, boolean immediately) {
        new UnregisterPusherCommand(this.mAccountsController, this.amsUsers, brandId, appId, unregisteringCompletedCallback, immediately).execute();
    }

    @Override
    public void getNumUnreadMessages(String brandId, String appId, final ICallback<Integer, Exception> callback) {
        new GetUnreadMessagesCountCommand(this, brandId, appId, new ICallback<Integer, Exception>(){

            public void onSuccess(Integer value) {
                callback.onSuccess((Object)value);
            }

            public void onError(Exception exception) {
                callback.onError((Throwable)exception);
            }
        }).execute();
    }

    @Override
    public void getUnreadMessagesCount(String brandId, String appId, final ICallback<Integer, Exception> callback) {
        new GetCombinedUnreadMessagesCountCommand(this, brandId, appId, new ICallback<Integer, Exception>(){

            public void onSuccess(Integer value) {
                callback.onSuccess((Object)value);
            }

            public void onError(Exception exception) {
                callback.onError((Throwable)exception);
            }
        }).execute();
    }

    @Override
    public ActionFailureReason changeChatState(String targetId, String brandId, ChatState state) {
        ActionFailureReason failedReason = this.getConversationActionFailedReason(targetId, brandId);
        if (failedReason != null) {
            return failedReason;
        }
        new ChangeChatStateCommand(this.amsDialogs, targetId, this.mAccountsController.getConnectionUrl(brandId), state).execute();
        return null;
    }

    @Override
    public ActionFailureReason resolveConversation(String targetId, String brandId) {
        ActionFailureReason failedReason = this.getConversationActionFailedReason(targetId, brandId);
        if (failedReason != null) {
            return failedReason;
        }
        new ResolveConversationCommand(this.amsConversations, targetId, this.mAccountsController.getConnectionUrl(brandId)).execute();
        return null;
    }

    public ActionFailureReason closeCurrentDialog() {
        ActionFailureReason actionFailureReason;
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        if (activeDialog == null) {
            LPMobileLog.e((String)TAG, (String)"There's no active dialog. Aborting from closing dialog");
            actionFailureReason = ActionFailureReason.NOT_ACTIVE;
        } else {
            actionFailureReason = this.closeDialog(activeDialog.getBrandId());
        }
        return actionFailureReason;
    }

    @Override
    public ActionFailureReason closeDialog(final String brandId) {
        boolean isDialogOpen;
        ActionFailureReason actionFailureReason = this.getConversationActionFailedReason(brandId, brandId);
        if (actionFailureReason != null) {
            return actionFailureReason;
        }
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        boolean bl = isDialogOpen = activeDialog != null && activeDialog.isOpen();
        if (isDialogOpen && AmsDialogs.isUmsSupportingDialogs()) {
            final CloseDialogCommand closeDialogCommand = new CloseDialogCommand(this.amsDialogs, activeDialog.getDialogId(), this.mAccountsController.getConnectionUrl(brandId));
            closeDialogCommand.setCallback(new ICallback<Integer, Exception>(){

                public void onSuccess(Integer value) {
                    closeDialogCommand.setCallback(null);
                }

                public void onError(Exception exception) {
                    if (Integer.parseInt(exception.getMessage(), -1) == 400) {
                        LPMobileLog.e((String)TAG, (String)"MULTI_DIALOG_FLOW", (String)"Failed to close dialog due to an error (with code 400), closing the whole conversation.", (Throwable)exception);
                        new ResolveConversationCommand(Messaging.this.amsConversations, brandId, Messaging.this.mAccountsController.getConnectionUrl(brandId)).execute();
                    }
                    closeDialogCommand.setCallback(null);
                }
            });
            closeDialogCommand.execute();
        } else {
            new ResolveConversationCommand(this.amsConversations, brandId, this.mAccountsController.getConnectionUrl(brandId)).execute();
        }
        return null;
    }

    @Override
    public ActionFailureReason markConversationAsUrgent(String targetId, String brandId) {
        ActionFailureReason failedReason = this.getConversationActionFailedReason(targetId, brandId);
        if (failedReason != null) {
            return failedReason;
        }
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        ActionFailureReason changeTTRFailedReason = this.getDialogChangeTTRActionFailedReason(activeDialog);
        if (changeTTRFailedReason != null) {
            return changeTTRFailedReason;
        }
        new ChangeConversationTTRCommand(this.amsConversations, targetId, this.mAccountsController.getConnectionUrl(brandId), TTRType.URGENT).execute();
        return null;
    }

    @Override
    public ActionFailureReason markConversationAsNormal(String targetId, String brandId) {
        ActionFailureReason failedReason = this.getConversationActionFailedReason(targetId, brandId);
        if (failedReason != null) {
            return failedReason;
        }
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        ActionFailureReason changeTTRFailedReason = this.getDialogChangeTTRActionFailedReason(activeDialog);
        if (changeTTRFailedReason != null) {
            return changeTTRFailedReason;
        }
        new ChangeConversationTTRCommand(this.amsConversations, targetId, this.mAccountsController.getConnectionUrl(brandId), TTRType.NORMAL).execute();
        return null;
    }

    @Nullable
    private ActionFailureReason getConversationActionFailedReason(String targetId, String brandId) {
        if (!this.mConnectionController.isSocketReady(brandId)) {
            LPMobileLog.d((String)TAG, (String)"Socket is not open");
            return ActionFailureReason.NO_NETWORK;
        }
        if (!this.amsConversations.isConversationActive(targetId)) {
            LPMobileLog.d((String)TAG, (String)"There's no active dialog");
            return ActionFailureReason.NOT_ACTIVE;
        }
        return null;
    }

    @Nullable
    private ActionFailureReason getDialogChangeTTRActionFailedReason(Dialog activeDialog) {
        ActionFailureReason failureReason = null;
        if (activeDialog == null || !activeDialog.isOpen()) {
            failureReason = ActionFailureReason.NOT_ACTIVE;
        } else if (activeDialog.getDialogType() == DialogType.POST_SURVEY) {
            failureReason = ActionFailureReason.POST_SURVEY_IN_PROGRESS;
        }
        return failureReason;
    }

    public boolean canActiveDialogChangeTTR() {
        Dialog activeDialog = this.amsDialogs.getActiveDialog();
        ActionFailureReason dialogFailedReason = this.getDialogChangeTTRActionFailedReason(activeDialog);
        return dialogFailedReason == null;
    }

    @Override
    public void sendCSAT(String brandId, String conversationID, int mStarsNumber, int yesNoValue) {
        new SendCsatCommand(this.mAccountsController.getConnectionUrl(brandId), conversationID, mStarsNumber, yesNoValue).execute();
    }

    @Override
    public void sendUserProfile(String brandId, UserProfile userProfile) {
        new SendSetUserProfileCommand(this, brandId, userProfile).execute();
    }

    @Override
    public void setCallback(LivePersonCallback listener) {
        this.mEventsProxy.setCallback(listener);
    }

    @Override
    public void removeCallback() {
        this.mEventsProxy.removeCallback();
    }

    @Override
    public void checkActiveConversation(String targetId, final ICallback<Boolean, Exception> callback) {
        this.amsConversations.getActiveConversation(targetId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Conversation>(){

            public void onResult(Conversation data) {
                boolean conversationOpen = false;
                if (data != null) {
                    conversationOpen = true;
                }
                callback.onSuccess((Object)conversationOpen);
            }
        }).execute();
    }

    public void queryActiveDialog(String targetId, final ICallback<Dialog, Exception> callback) {
        this.amsDialogs.queryActiveDialog(targetId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Dialog>(){

            public void onResult(Dialog data) {
                if (data != null) {
                    callback.onSuccess((Object)data);
                } else {
                    callback.onError((Throwable)new Exception("Error: No active dialog"));
                }
            }
        }).execute();
    }

    @Override
    public void checkConversationIsMarkedAsUrgent(String targetId, final ICallback<Boolean, Exception> callback) {
        this.amsConversations.getActiveConversation(targetId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Conversation>(){

            public void onResult(Conversation data) {
                boolean conversationUrgent = false;
                if (data != null && data.getConversationTTRType() == TTRType.URGENT && data.isConversationOpen()) {
                    conversationUrgent = true;
                }
                callback.onSuccess((Object)conversationUrgent);
            }
        }).execute();
    }

    @Override
    public void checkAgentID(String brandId, final ICallback<AgentData, Exception> callback) {
        this.amsDialogs.queryActiveDialog(brandId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Dialog>(){

            public void onResult(Dialog data) {
                if (data != null) {
                    Context context = Infra.instance.getApplicationContext();
                    if (context == null) {
                        callback.onSuccess(null);
                        return;
                    }
                    boolean updateAlways = Configuration.getBoolean((int)R.bool.send_agent_profile_updates_when_conversation_closed);
                    if (updateAlways || data.isOpen()) {
                        String agentOriginatorId = data.getAssignedAgentId();
                        if (TextUtils.isEmpty((CharSequence)agentOriginatorId)) {
                            callback.onSuccess(null);
                        } else {
                            Messaging.this.amsUsers.getUserById(agentOriginatorId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<MessagingUserProfile>(){

                                public void onResult(MessagingUserProfile data) {
                                    if (data != null) {
                                        AgentData agentData = new AgentData();
                                        agentData.mFirstName = data.getFirstName();
                                        agentData.mLastName = data.getLastName();
                                        agentData.mAvatarURL = data.getAvatarUrl();
                                        agentData.mEmployeeId = data.getDescription();
                                        agentData.mNickName = data.getNickname();
                                        callback.onSuccess((Object)agentData);
                                        return;
                                    }
                                    callback.onSuccess(null);
                                }
                            }).execute();
                        }
                    } else {
                        callback.onSuccess(null);
                    }
                } else {
                    callback.onSuccess(null);
                }
            }
        }).execute();
    }

    @Override
    public boolean clearHistory(String targetId) {
        boolean conversationActive = this.amsConversations.isConversationActive(targetId);
        if (conversationActive) {
            LPMobileLog.w((String)TAG, (String)"clearHistory: There is an open conversation. Cannot clear history");
            return false;
        }
        this.amsMessages.clearMessagesOfClosedConversations(targetId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Integer>(){

            public void onResult(Integer data) {
                LPMobileLog.d((String)TAG, (String)("clearHistory: Removed " + data + " messages"));
            }
        }).execute();
        this.amsDialogs.clearClosedDialogs(targetId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Integer>(){

            public void onResult(Integer data) {
                LPMobileLog.d((String)TAG, (String)("clearHistory: Removed " + data + " dialogs"));
            }
        }).execute();
        this.amsConversations.clearClosedConversations(targetId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Integer>(){

            public void onResult(Integer data) {
                LPMobileLog.d((String)TAG, (String)("clearHistory: Removed " + data + " conversations"));
            }
        }).execute();
        return true;
    }

    @Override
    public void clearAllConversationData(final String targetId) {
        LPMobileLog.d((String)TAG, (String)"clearAllConversationData");
        this.amsMessages.clearAllMessages(targetId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Integer>(){

            public void onResult(Integer data) {
                Messaging.this.amsMessages.clear();
                Messaging.this.amsDialogs.clearAllDialogs(targetId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Integer>(){

                    public void onResult(Integer data) {
                        Messaging.this.amsDialogs.clear();
                        Messaging.this.amsConversations.clearAllConversations(targetId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Integer>(){

                            public void onResult(Integer data) {
                                Messaging.this.amsConversations.clear();
                            }
                        }).execute();
                    }
                }).execute();
            }
        }).execute();
    }

    public String getOriginatorId(String targetId) {
        return this.amsUsers.getConsumerId(targetId);
    }

    public void onAgentDetailsChanged(MessagingUserProfile userProfile, boolean isDialogOpen) {
        Context context = Infra.instance.getApplicationContext();
        if (context == null) {
            return;
        }
        boolean updateAlways = Configuration.getBoolean((int)R.bool.send_agent_profile_updates_when_conversation_closed);
        if (updateAlways || isDialogOpen) {
            AgentData agentData = null;
            if (userProfile != null) {
                agentData = new AgentData();
                agentData.mFirstName = userProfile.getFirstName();
                agentData.mLastName = userProfile.getLastName();
                agentData.mAvatarURL = userProfile.getAvatarUrl();
                agentData.mEmployeeId = userProfile.getDescription();
                agentData.mNickName = userProfile.getNickname();
            }
            this.mEventsProxy.onAgentDetailsChanged(agentData);
        }
    }

    public void shutDown(ShutDownCompletionListener listener) {
        LPMobileLog.d((String)TAG, (String)"Shutting down...");
        this.messagingShutDown(listener);
    }

    @Override
    public void shutDown(final ShutDownProcess process) {
        Infra.instance.shutDown(new ShutDownProcess(){

            public void shutDown(final ShutDownCompletionListener listener) {
                process.shutDown(new ShutDownCompletionListener(){

                    public void shutDownCompleted() {
                        LPMobileLog.d((String)TAG, (String)"Shutting down...");
                        Messaging.this.messagingShutDown(listener);
                    }

                    public void shutDownFailed() {
                    }
                });
            }
        });
    }

    private void messagingShutDown(final ShutDownCompletionListener listener) {
        ShutDownCompletionListener messagingShutDownListener = new ShutDownCompletionListener(){

            public void shutDownCompleted() {
                listener.shutDownCompleted();
            }

            public void shutDownFailed() {
                listener.shutDownFailed();
            }
        };
        this.mConnectionController.shutDown(messagingShutDownListener);
        this.amsReadController.shutDown();
        this.amsMessages.shutDown();
        this.amsDialogs.shutDown();
        this.amsConversations.shutDown();
    }

    @Override
    public void logout(Context context, MessagingInitData initData, final LogoutLivePersonCallBack logoutLivePersonCallBack) {
        this.logout(context, initData, new LogoutProcess(){

            public void initForLogout() {
            }

            public void preLogout(PreLogoutCompletionListener listener) {
                listener.preLogoutCompleted();
            }

            public void shutDownForLogout(ShutDownCompletionListener listener) {
                listener.shutDownCompleted();
            }

            public void logout() {
            }

            public LogoutLivePersonCallBack getLogoutCallback() {
                return logoutLivePersonCallBack;
            }
        });
    }

    @Override
    public void logout(final Context context, final MessagingInitData initData, final LogoutProcess logoutProcess) {
        Infra.instance.logout(context, (InfraInitData)initData, new LogoutProcess(){

            public void initForLogout() {
                Messaging.this.initMessaging(context, initData);
                logoutProcess.initForLogout();
            }

            public void preLogout(final PreLogoutCompletionListener listener) {
                logoutProcess.preLogout(new PreLogoutCompletionListener(){

                    public void preLogoutCompleted() {
                        Messaging.this.unregisterPusher(initData.getBrandId(), initData.getAppId(), new ICallback<Void, Exception>(){

                            public void onSuccess(Void value) {
                                listener.preLogoutCompleted();
                            }

                            public void onError(Exception exception) {
                                listener.preLogoutFailed(exception);
                            }
                        }, true);
                    }

                    public void preLogoutFailed(Exception e) {
                        listener.preLogoutFailed(e);
                    }
                });
            }

            public LogoutLivePersonCallBack getLogoutCallback() {
                return logoutProcess.getLogoutCallback();
            }

            public void shutDownForLogout(final ShutDownCompletionListener listener) {
                logoutProcess.shutDownForLogout(new ShutDownCompletionListener(){

                    public void shutDownCompleted() {
                        Messaging.this.messagingShutDown(listener);
                    }

                    public void shutDownFailed() {
                    }
                });
            }

            public void logout() {
                logoutProcess.logout();
                Messaging.this.clear();
            }
        });
    }

    public void clear() {
        this.amsConversations.clear();
        this.amsDialogs.clear();
        this.amsMessages.clear();
        this.amsUsers.clear();
        this.mAccountsController.clear();
        this.mConnectionController.clear();
        this.mClientProperties.clear();
        FileUtils.deleteAllSharedFiles((Context)this.mContext);
        this.mMessageValidator = null;
    }

    @Override
    public boolean isSocketOpen(String brandId) {
        return this.mConnectionController.isSocketOpen(brandId);
    }

    @Override
    public boolean isInitialized() {
        return Infra.instance.isInitialized();
    }

    public String getInProgressUploadMessageRowIdsString() {
        LPMobileLog.d((String)TAG, (String)"getInProgressUploadMessageRowIdsString: direct call (no service)");
        return this.mFileSharingManager.getInProgressUploadMessageRowIdsString();
    }

    public FileSharingManager getFileSharingManager() {
        return this.mFileSharingManager;
    }

    public boolean isEnableStructuredContent() {
        return this.mEnableStructuredContent;
    }

    public void setImageServicePendingIntent(PendingIntent imageServicePendingIntent) {
        this.mImageServicePendingIntent = imageServicePendingIntent;
    }

    public PendingIntent getImageServicePendingIntent() {
        return this.mImageServicePendingIntent;
    }

    public Notification.Builder getImageForegroundServiceUploadNotificationBuilder() {
        return this.mImageForegroundServiceUploadNotificationBuilder;
    }

    public Notification.Builder getImageForegroundServiceDownloadNotificationBuilder() {
        return this.mImageForegroundServiceDownloadNotificationBuilder;
    }

    public void setImageForegroundServiceUploadNotificationBuilder(Notification.Builder imageForegroundServiceNotificationBuilder) {
        this.mImageForegroundServiceUploadNotificationBuilder = imageForegroundServiceNotificationBuilder;
    }

    public void setImageForegroundServiceDownloadNotificationBuilder(Notification.Builder imageForegroundServiceNotificationBuilder) {
        this.mImageForegroundServiceDownloadNotificationBuilder = imageForegroundServiceNotificationBuilder;
    }

    public void sendDeliveryStatusUpdateCommand(String brandId, String dialogId, String conversationId, int sequence, DeliveryStatus deliveryStatus, DeliveryStatusUpdateInfo info) {
        new DeliveryStatusUpdateCommand(this.mAccountsController.getConnectionUrl(brandId), brandId, dialogId, conversationId, sequence, deliveryStatus, info).execute();
    }

    public ConversationViewParams getConversationViewParams() {
        return this.mConversationViewParams;
    }

    public void setConversationViewParams(ConversationViewParams conversationViewParams) {
        LPMobileLog.d((String)TAG, (String)("Setting conversation view params : " + conversationViewParams));
        this.mConversationViewParams = conversationViewParams;
    }

    public MessagingEventSubscriptionManager getMessagingEventSubscriptionManager() {
        return this.mMessagingEventSubscriptionManager;
    }

    public LPAudioUtils getAudioUtils() {
        return this.mAudioUtils;
    }

    public boolean isStillBusyFetching() {
        return this.isStillBusyFetching;
    }

    public void setStillBusyFetching(boolean stillBusyFetching) {
        this.isStillBusyFetching = stillBusyFetching;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }
}

