/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing.document;

import androidx.annotation.Nullable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.UniqueID;
import com.liveperson.messaging.background.DownloadFileTask;
import com.liveperson.messaging.background.filesharing.DownloadFileTaskBundle;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class DownloadDocumentTask
extends DownloadFileTask {
    public static final String TAG = "DownloadDocumentTask";
    private FileSharingType mSubFileType;
    private File mFilesFolder;
    private static String DOCUMENTS_FOLDER = "documents/";
    private String mBrandId;

    public DownloadDocumentTask(DownloadFileTaskBundle params, FileSharingType subFileType) {
        super(params);
        this.mSubFileType = subFileType;
        this.mFilesFolder = Infra.instance.getApplicationContext().getFilesDir();
        this.mBrandId = params.getBrandId();
    }

    @Override
    protected String saveFileToDisk(byte[] byteArray) {
        return this.saveByteArrayToDisk(byteArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveByteArrayToDisk(byte[] fileByteArray) {
        File filePath = new File(this.getDocumentsFolder(), this.generateDocumentName(this.mSubFileType));
        LPMobileLog.d((String)TAG, (String)("saveByteArrayToDisk: filePath: " + filePath.getAbsolutePath()));
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            fos.write(fileByteArray);
        }
        catch (FileNotFoundException e) {
            LPMobileLog.e((String)TAG, (String)"saveByteArrayToDisk: File not found", (Throwable)e);
            String string2 = null;
            return string2;
        }
        catch (IOException e) {
            LPMobileLog.e((String)TAG, (String)"saveByteArrayToDisk: IOException", (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LPMobileLog.e((String)TAG, (String)"saveByteArrayToDisk: error closing file", (Throwable)e);
                return null;
            }
        }
        LPMobileLog.d((String)TAG, (String)("saveByteArrayToDisk: file absolute path: " + filePath.getAbsolutePath()));
        return filePath.getAbsolutePath();
    }

    private String generateDocumentName(FileSharingType fileType) {
        switch (fileType) {
            case DOCX: {
                return UniqueID.createUniqueMessageEventId() + ".docx";
            }
            case PPTX: {
                return UniqueID.createUniqueMessageEventId() + ".pptx";
            }
            case XLSX: {
                return UniqueID.createUniqueMessageEventId() + ".xlsx";
            }
        }
        return UniqueID.createUniqueMessageEventId() + ".pdf";
    }

    @Nullable
    private String getDocumentsFolder() {
        File outgoingDocumentFolder = new File(this.mFilesFolder + "/" + DOCUMENTS_FOLDER + "/" + this.mBrandId);
        if (!outgoingDocumentFolder.exists() && !outgoingDocumentFolder.mkdirs()) {
            LPMobileLog.e((String)TAG, (String)"getDocumentsFolder: /documents folder could not be created");
            return null;
        }
        return outgoingDocumentFolder.getPath();
    }
}

