/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.database.Cursor;
import com.liveperson.messaging.model.MessagingChatMessage;

public class MessagingSearchedMessage {
    private String mMessage;
    private String mBrandId;
    private String mFirstName;
    private MessagingChatMessage.MessageType mMessageType;

    public MessagingSearchedMessage() {
    }

    public MessagingSearchedMessage(String message, String brandId, String firstName, MessagingChatMessage.MessageType messageType) {
        this.mMessage = message;
        this.mBrandId = brandId;
        this.mFirstName = firstName;
        this.mMessageType = messageType;
    }

    public static MessagingSearchedMessage fromCursor(Cursor cursor) {
        if (cursor == null) {
            return null;
        }
        MessagingSearchedMessage searchedMessage = new MessagingSearchedMessage();
        searchedMessage.setBrandId(cursor.getString(cursor.getColumnIndex("brand_id")));
        searchedMessage.setMessage(cursor.getString(cursor.getColumnIndex("text")));
        searchedMessage.setFirstName(cursor.getString(cursor.getColumnIndex("firstName")));
        int messageType = cursor.getInt(cursor.getColumnIndex("type"));
        searchedMessage.setMessageType(MessagingChatMessage.MessageType.values()[messageType]);
        return searchedMessage;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public String getBrandId() {
        return this.mBrandId;
    }

    public void setBrandId(String brandId) {
        this.mBrandId = brandId;
    }

    public String getFirstName() {
        return this.mFirstName;
    }

    public void setFirstName(String firstName) {
        this.mFirstName = firstName;
    }

    public MessagingChatMessage.MessageType getMessageType() {
        return this.mMessageType;
    }

    public void setMessageType(MessagingChatMessage.MessageType messageType) {
        this.mMessageType = messageType;
    }
}

