/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.SubscribeExConversations;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.controller.ConnectionsController;
import org.json.JSONException;
import org.json.JSONObject;

public class SubscribeExConversationsRequest
extends BaseAMSSocketRequest<SubscribeExConversations.Response, SubscribeExConversationsRequest> {
    public static final String TAG = SubscribeExConversationsRequest.class.getSimpleName();
    private String consumerId;
    private long maxLastUpdatedTime = -1L;
    private long minLastUpdatedTime = -1L;
    private String[] agentIds = new String[]{""};
    private String brandId;
    private int maxETTR = 0;
    private ConnectionsController mConnectionController;

    public SubscribeExConversationsRequest(ConnectionsController connectionController, long minLastUpdatedTime, String brandId, String socketUrl, String consumerId) {
        super(socketUrl);
        this.mConnectionController = connectionController;
        this.minLastUpdatedTime = minLastUpdatedTime;
        this.brandId = brandId;
        this.consumerId = consumerId;
    }

    protected String getData() {
        String[] conversationStages = new String[]{ConversationState.OPEN.name(), ConversationState.CLOSE.name(), ConversationState.LOCKED.name()};
        return new SubscribeExConversations(this.consumerId, this.maxLastUpdatedTime, this.minLastUpdatedTime, this.agentIds, this.brandId, this.maxETTR, conversationStages).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<SubscribeExConversations.Response, SubscribeExConversationsRequest> getResponseHandler() {
        return new BaseResponseHandler<SubscribeExConversations.Response, SubscribeExConversationsRequest>(){

            public String getAPIResponseType() {
                return "cqm.SubscribeExConversationsResponse";
            }

            protected SubscribeExConversations.Response parse(JSONObject jsonObject) throws JSONException {
                return new SubscribeExConversations.Response(jsonObject);
            }

            protected boolean handle(SubscribeExConversations.Response responseData) {
                String subscriptionId = ((SubscribeExConversations.Response.Body)responseData.getBody()).subscriptionId;
                if (TextUtils.isEmpty((CharSequence)subscriptionId)) {
                    LPMobileLog.w((String)TAG, (String)"No subscription Id! can't get updates!");
                    return true;
                }
                SubscribeExConversationsRequest.this.mConnectionController.setSubscription(SubscribeExConversationsRequest.this.brandId, subscriptionId);
                SubscribeExConversationsRequest.this.mConnectionController.setFirstNotificationAfterSubscribe(SubscribeExConversationsRequest.this.brandId, true);
                return true;
            }
        };
    }
}

