/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.structuredcontent.model.actions.BaseAction;
import com.liveperson.messaging.structuredcontent.model.actions.OnActionClickListener;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONException;
import org.json.JSONObject;

public class NavigateAction
extends BaseAction {
    public static final String TAG = "NavigateAction";
    private String mLongitude;
    private String mLatitude;

    public NavigateAction(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        this.mLongitude = jsonObject.getString("lo");
        this.mLatitude = jsonObject.getString("la");
    }

    public NavigateAction(String type, String name, String longitude, String latitude) {
        super(type, name);
        this.mLongitude = longitude;
        this.mLatitude = latitude;
    }

    @Override
    public OnActionClickListener getOnClickListener(Context context, String brandId) {
        return () -> {
            LPMobileLog.d((String)TAG, (String)("onClick: navigate to La,Lo: " + this.mLatitude + "," + this.mLongitude));
            Uri gmmIntentUri = Uri.parse((String)("geo:" + this.mLatitude + "," + this.mLongitude + "?q=" + this.mLatitude + "," + this.mLongitude));
            Intent mapIntent = new Intent("android.intent.action.VIEW", gmmIntentUri);
            if (mapIntent.resolveActivity(context.getPackageManager()) != null) {
                context.startActivity(mapIntent);
            }
        };
    }

    @Override
    @NonNull
    public String toString() {
        return this.getClass().getSimpleName() + "(\n";
    }

    @Override
    public void accept(ElementVisitor visitor) {
    }

    public String getLongitude() {
        return this.mLongitude;
    }

    public String getLatitude() {
        return this.mLatitude;
    }
}

