/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.structuredcontent.model.actions.BaseAction;
import com.liveperson.messaging.structuredcontent.model.actions.OnActionClickListener;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublishTextAction
extends BaseAction {
    public static final String TAG = "PublishTextAction";
    private String mText;
    private JSONArray mMetadata;

    public PublishTextAction(JSONObject jsonObject, @Nullable JSONArray metadataJsonArray) throws JSONException {
        super(jsonObject);
        this.mText = jsonObject.getString("text");
        this.mMetadata = metadataJsonArray;
    }

    @Override
    public OnActionClickListener getOnClickListener(Context context, String brandId) {
        return () -> {
            LPMobileLog.d((String)TAG, (String)("onClick: sending text: " + this.mText + " with metadata: " + this.mMetadata));
            MessagingFactory.getInstance().getController().sendMessage(brandId, brandId, this.mText, new DeliveryStatusUpdateInfo(this.mMetadata));
        };
    }

    @Override
    @NonNull
    public String toString() {
        return this.getClass().getSimpleName() + "(\n";
    }

    @Override
    public void accept(ElementVisitor visitor) {
    }
}

