/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.parsers;

import androidx.annotation.Nullable;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.structuredcontent.model.actions.BaseAction;
import com.liveperson.messaging.structuredcontent.model.actions.LinkAction;
import com.liveperson.messaging.structuredcontent.model.actions.NavigateAction;
import com.liveperson.messaging.structuredcontent.model.actions.PublishTextAction;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionParser {
    public static final String TAG = ActionParser.class.getSimpleName();

    public static List<BaseAction> parse(JSONArray actionArray, @Nullable JSONArray metadataJsonArray) {
        ArrayList<BaseAction> actionList;
        if (actionArray == null) {
            LPMobileLog.w((String)TAG, (String)"parse: empty json");
            return null;
        }
        try {
            actionList = new ArrayList<BaseAction>();
            for (int i = 0; i < actionArray.length(); ++i) {
                BaseAction actionToAdd;
                String type;
                JSONObject actionObject = actionArray.getJSONObject(i);
                switch (type = actionObject.getString("type")) {
                    case "link": {
                        actionToAdd = new LinkAction(actionObject);
                        break;
                    }
                    case "navigate": {
                        actionToAdd = new NavigateAction(actionObject);
                        break;
                    }
                    case "publishText": {
                        actionToAdd = new PublishTextAction(actionObject, metadataJsonArray);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                actionList.add(actionToAdd);
            }
        }
        catch (JSONException e) {
            LPMobileLog.w((String)TAG, (String)"parse: error parsing action. Return null", (Throwable)e);
            return null;
        }
        return actionList;
    }
}

