package com.liveperson.api.response.model;

import android.text.TextUtils;

import org.json.JSONObject;

/**
 * Created by cgiehl on 8/10/15.
 */
public abstract class MultiDialog {

	public enum ChannelType {
		MESSAGING, COBROWSE;

		public static ChannelType parse(String channelTypeString) {
			ChannelType result = MESSAGING;
			if (!TextUtils.isEmpty(channelTypeString)) {
				ChannelType[] values = ChannelType.values();
				for (ChannelType dialogState : values) {
					if (dialogState.name().equalsIgnoreCase(channelTypeString)) {
						result = dialogState;
					}
				}
			}

			return result;
		}
	}

	public ChannelType channelType = ChannelType.MESSAGING /* default type */;

	protected MultiDialog() {
	}

	protected MultiDialog(JSONObject jsonObject) {
		ChannelType jsonChannelType = ChannelType.parse(jsonObject.optString("channelType"));
		if (ChannelType.COBROWSE == jsonChannelType) {
			channelType = ChannelType.COBROWSE;
		}
	}

	public ChannelType getType() {
		return channelType;
	}

	/**
	 * This factory method can be used to instantiate {@link DialogData} based on their "channelType"
	 * property.
	 * @param jsonObject
	 * @return
	 */
	public static DialogData create(JSONObject jsonObject, String conversationId) {
		ChannelType jsonChannelType = ChannelType.parse(jsonObject.optString("channelType"));
		if (ChannelType.COBROWSE == jsonChannelType) {
			return new CobrowseDialogData(jsonObject, conversationId);
		}

		return new DialogData(jsonObject, conversationId);
	}

	public static DialogData create(JSONObject jsonObject) {
		return create(jsonObject, null);
	}
}
