package com.liveperson.messaging.commands.tasks;

import com.liveperson.messaging.TaskExecutionState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by shiranr on 20/03/2016.
 */
public abstract class BaseAmsAccountConnectionTask extends BaseConnectionTask {
    protected BaseAmsAccountConnectionCallback mCallback;
    protected static Map<BaseAmsAccountConnectionTask, TaskExecutionState> concurrentTasks = new ConcurrentHashMap<>();

    /**
     * Callback for task states: completed or error
     *
     * @param callback
     */
    public BaseConnectionTask setCallback(BaseAmsAccountConnectionCallback callback) {
        mCallback = callback;
        return this;
    }

	public void setIsSecondaryTask(boolean isSecondaryTask) {
		if (mCallback != null) {
			mCallback.setSecondaryTask(isSecondaryTask);
		}
	}

    public BaseAmsAccountConnectionCallback getCallback() {
        return mCallback;
    }

    public void resetConcurrentTasks() {
        concurrentTasks.clear();
    }

	public abstract String getName();

    public boolean requireSDKinForeground(){
        return false;
    }
}
