/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.UploadImageTask;
import com.liveperson.messaging.background.filesharing.image.ReUploadImageTaskBundle;
import com.liveperson.messaging.commands.ReSendImageCommand;
import com.liveperson.messaging.exception.FileSharingException;

public class ReUploadImageTask
extends UploadImageTask {
    private static final String TAG = "ReUploadImageTask";

    public ReUploadImageTask(ReUploadImageTaskBundle params, Integer uploadTimeout) throws FileSharingException {
        super(params, uploadTimeout);
        this.mFileRowId = params.getFileRowId();
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "imageTypeExtension = " + this.uploadImageTaskParams.getFileTypeExtension() + ", imageContentType = " + this.uploadImageTaskParams.getFileContentType());
    }

    @Override
    @NonNull
    protected Bitmap processOriginalImage(int orientation, boolean fromCamera) {
        Bitmap originalBitmap = ImageUtils.getBitmap((String)this.uploadImageTaskParams.getFilePath());
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "originalBitmap size (w, h): " + originalBitmap.getWidth() + ", " + originalBitmap.getHeight());
        return originalBitmap;
    }

    @Override
    @NonNull
    protected String saveOriginalImage(Bitmap originalBitmap) {
        this.createOriginalImageByteArray(originalBitmap, this.uploadImageTaskParams.getFileTypeExtension());
        return this.uploadImageTaskParams.getFilePath();
    }

    @Override
    @NonNull
    protected Bitmap processThumbnailImage(int orientation, boolean fromCamera) {
        return ImageUtils.getBitmap((String)((ReUploadImageTaskBundle)this.uploadImageTaskParams).getThumbnailLocalPath());
    }

    @Override
    @NonNull
    protected String saveThumbnailImage(Bitmap thumbnailBitmap) {
        byte[] thumbnailByteArray = ImageUtils.getOutputStreamFromBitmap((Bitmap)thumbnailBitmap, (int)100, (String)this.uploadImageTaskParams.getFileTypeExtension());
        if (thumbnailByteArray == null) {
            return null;
        }
        this.mBase64 = ImageUtils.bitmapToBase64((byte[])thumbnailByteArray);
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "processThumbnailImage: Thumbnail Base64: " + this.mBase64);
        return ((ReUploadImageTaskBundle)this.uploadImageTaskParams).getThumbnailLocalPath();
    }

    @Override
    protected void createSendMessageCommand(String thumbnailPath, String fullImagePath) {
        this.sendMessageCommand = new ReSendImageCommand(MessagingFactory.getInstance().getController(), this.uploadImageTaskParams.getTargetId(), this.uploadImageTaskParams.getBrandId(), this.uploadImageTaskParams.getFileContentType(), thumbnailPath, fullImagePath, this.uploadImageTaskParams.getFileTypeExtension(), ((ReUploadImageTaskBundle)this.uploadImageTaskParams).getEventId(), this.uploadImageTaskParams.getMessage(), ((ReUploadImageTaskBundle)this.uploadImageTaskParams).getFileRowId());
        this.setSendMessageCommandCallback();
    }
}

