/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;
import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsAccount;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.model.EngagementDetails;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.responses.LPEngagementResponse;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnAuthGetEngagementTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "UnAuthGetEngagementTask";
    private AccountsController mAccountsController;

    public UnAuthGetEngagementTask(AccountsController accountsController) {
        this.mAccountsController = accountsController;
    }

    public void execute() {
        LPAuthenticationParams auth = this.mAccountsController.getLPAuthenticationParams(this.mBrandId);
        if (auth != null) {
            LPLog.INSTANCE.d(TAG, "Running GetEngagement task, relevant only if auth type is UnAuth. current type: " + auth.getAuthType());
            if (auth.getAuthType() != LPAuthenticationType.UN_AUTH) {
                this.mCallback.onTaskSuccess();
                return;
            }
        } else {
            LPLog.INSTANCE.d(TAG, "getLPAuthenticationParams: getLPAuthenticationParams returns null for brand with id: " + this.mBrandId);
            this.mCallback.onTaskError(TaskType.IDP, LpError.IDP, new NullPointerException());
            return;
        }
        if (!MonitoringFactory.INSTANCE.isInitialized()) {
            Exception exception = new Exception(this.mBrandId + ": UnAuth flow, monitoring isn't initialized. Are you missing 'app install id' in LivePerson.init? ");
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000D8, "MonitoringFactory is not initialized.", (Throwable)exception);
            this.mCallback.onTaskError(TaskType.IDP, LpError.IDP, exception);
            return;
        }
        if (!this.isConnectorIdEmpty()) {
            LPLog.INSTANCE.d(TAG, "Type is UnAuth and we already have connector id");
            this.mCallback.onTaskSuccess();
            return;
        }
        MonitoringFactory.INSTANCE.getEngagement(Infra.instance.getApplicationContext(), Collections.singletonList(new LPMonitoringIdentity()), null, new EngagementCallback(){

            public void onSuccess(@NotNull LPEngagementResponse lpEngagementResponse) {
                try {
                    List detailsList = lpEngagementResponse.getEngagementDetailsList();
                    if (!detailsList.isEmpty()) {
                        String connectorId = ((EngagementDetails)detailsList.get(0)).getConnectorId();
                        AmsAccount account = UnAuthGetEngagementTask.this.mAccountsController.getAccount(UnAuthGetEngagementTask.this.mBrandId);
                        if (account != null) {
                            account.setConnectorId(connectorId);
                        }
                    }
                    UnAuthGetEngagementTask.this.mCallback.onTaskSuccess();
                }
                catch (NullPointerException e) {
                    UnAuthGetEngagementTask.this.mCallback.onTaskError(TaskType.IDP, LpError.IDP, e);
                }
            }

            public void onError(@NotNull MonitoringErrorType errorType, @Nullable Exception exception) {
                UnAuthGetEngagementTask.this.mCallback.onTaskError(TaskType.IDP, LpError.IDP, exception);
            }
        });
    }

    private boolean isConnectorIdEmpty() {
        AmsAccount account;
        String connectorId = null;
        MonitoringParamsCache mMonitoringParamsCache = MonitoringFactory.INSTANCE.getMonitoring().getParamsCache();
        if (mMonitoringParamsCache != null) {
            connectorId = mMonitoringParamsCache.getConnectorId();
        }
        if ((account = this.mAccountsController.getAccount(this.mBrandId)) == null) {
            return true;
        }
        if (connectorId == null) {
            connectorId = account.getConnectorId();
            return TextUtils.isEmpty((CharSequence)connectorId);
        }
        account.setConnectorId(connectorId);
        return false;
    }

    @Override
    public String getName() {
        return TAG;
    }
}

