/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller.connection;

import com.liveperson.infra.ForegroundServiceInterface;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.types.AuthFailureReason;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.network.ExponentialBackOff;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownAsync;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;
import com.liveperson.infra.statemachine.BaseStateMachine;
import com.liveperson.infra.statemachine.interfaces.IEvent;
import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.infra.statemachine.interfaces.IStateMachine;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.ResolveConversationCommand;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.connection.BaseConnectionState;
import com.liveperson.messaging.controller.connection.ConnectionTasksHolder;
import com.liveperson.messaging.controller.connection.IConnectionListener;
import com.liveperson.messaging.controller.connection.IConnectionParamsCache;
import com.liveperson.messaging.controller.connection.InternetInformationProvider;
import com.liveperson.messaging.controller.connection.MessagingStateMachineInterface;
import com.liveperson.messaging.controller.connection.connectionevents.BackgroundEvent;
import com.liveperson.messaging.controller.connection.connectionevents.BackgroundTimeOutEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ConnectEvent;
import com.liveperson.messaging.controller.connection.connectionevents.DisconnectEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ForegroundEvent;
import com.liveperson.messaging.controller.connection.connectionevents.NetworkAvailableEvent;
import com.liveperson.messaging.controller.connection.connectionevents.NetworkLostEvent;
import com.liveperson.messaging.controller.connection.connectionevents.RunTaskEvent;
import com.liveperson.messaging.controller.connection.connectionevents.SecondaryConnectEvent;
import com.liveperson.messaging.controller.connection.connectionevents.SecondaryTaskSuccessEvent;
import com.liveperson.messaging.controller.connection.connectionevents.SendStateEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ServiceOffEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ServiceOnEvent;
import com.liveperson.messaging.controller.connection.connectionevents.ShutDownEvent;
import com.liveperson.messaging.controller.connection.connectionevents.SocketProblemEvent;
import com.liveperson.messaging.controller.connection.connectionevents.TaskFailedEvent;
import com.liveperson.messaging.controller.connection.connectionevents.TaskSuccessEvent;
import com.liveperson.messaging.controller.connection.connectionevents.TaskTimeOutEvent;
import java.util.ArrayList;
import java.util.List;

public class ConnectionStateMachine
extends BaseStateMachine
implements ShutDownAsync {
    private static final String TAG = "ConnectionStateMachine";
    private static final long TIMEOUT_INTERVAL = 2000L;
    private int mCurrentTaskIndex;
    private String mBrandId;
    private List<BaseAmsAccountConnectionTask> mConnectingTasks;
    private List<BaseAmsAccountConnectionTask> mDisconnectingTasks;
    private ConnectingState mConnectingState;
    private DisconnectingState mDisconnectingState;
    private ConnectedForegroundState mConnectedForegroundState;
    private ConnectedForegroundServiceState mConnectedForegroundServiceState;
    private ConnectedBackgroundState mConnectedBackgroundState;
    private ConnectedBackgroundServiceState mConnectedBackgroundServiceState;
    private DisconnectedState mDisconnectedState;
    private final MessagingStateMachineInterface mController;
    private final InternetInformationProvider mInternetInformationProvider;
    private final IConnectionListener mStateListener;
    private final ForegroundServiceInterface mForegroundServiceInterface;
    private final ExponentialBackOff mExponentialBackOff;
    private long mBackgroundConnectionTimerMs;
    private long mAbsoluteTimeForTimeout;
    private ConnectionTasksHolder mConnectionTasksHolder;

    public ConnectionStateMachine(MessagingStateMachineInterface controller, InternetInformationProvider internetInformationProvider, ForegroundServiceInterface foregroundServiceInterface, String brandId, IConnectionListener connectionListener) {
        super(TAG);
        this.mController = controller;
        this.mBrandId = brandId;
        this.mConnectionTasksHolder = new ConnectionTasksHolder((IStateMachine<IState>)this, this.mController, this.mBrandId);
        this.mDisconnectingTasks = this.mConnectionTasksHolder.getDisconnectionTasks();
        this.initStates(this.getTag());
        this.initActiveState(this.mDisconnectedState);
        this.mInternetInformationProvider = internetInformationProvider;
        this.mForegroundServiceInterface = foregroundServiceInterface;
        this.mStateListener = connectionListener;
        this.mExponentialBackOff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1).setMaxElapsedTimeMillis(300000).setMaxIntervalMillis(40000).setMultiplier(2.0).build();
    }

    private void initStates(String tag) {
        ForegroundParentState mForegroundParentState = new ForegroundParentState("ForegroundParentState", tag + "_ForegroundParentState");
        BackgroundParentState mBackgroundParentState = new BackgroundParentState("BackgroundParentState", tag + "_BackgroundParentState");
        this.mConnectingState = new ConnectingState("ConnectingState", tag + "_ConnectingState");
        this.mDisconnectingState = new DisconnectingState("DisconnectingState", tag + "_DisconnectingState");
        this.mConnectedForegroundState = new ConnectedForegroundState(mForegroundParentState, "ConnectedForegroundState", tag + "_ConnectedForegroundState");
        this.mConnectedForegroundServiceState = new ConnectedForegroundServiceState(mForegroundParentState, "ConnectedForegroundServiceState", tag + "_ConnectedForegroundServiceState");
        this.mConnectedBackgroundState = new ConnectedBackgroundState(mBackgroundParentState, "ConnectedBackgroundState", tag + "_ConnectedBackgroundState");
        this.mConnectedBackgroundServiceState = new ConnectedBackgroundServiceState(mBackgroundParentState, "ConnectedBackgroundServiceState", tag + "_ConnectedBackgroundServiceState");
        this.mDisconnectedState = new DisconnectedState("DisconnectedState", tag + "_DisconnectedState");
    }

    public boolean isConnected() {
        return ((BaseConnectionState)this.activeState()).isConnected();
    }

    public boolean isConnecting() {
        return ((BaseConnectionState)this.activeState()).isConnecting();
    }

    public void startConnecting(boolean connectInBackground) {
        this.postEvent((IEvent)new ConnectEvent(connectInBackground));
    }

    public void startDisconnecting() {
        this.postEvent((IEvent)new DisconnectEvent());
    }

    public void networkLost() {
        this.postEvent((IEvent)new NetworkLostEvent());
    }

    public void networkAvailable() {
        this.postEvent((IEvent)new NetworkAvailableEvent());
    }

    public void moveToForeground() {
        this.postEvent((IEvent)new ForegroundEvent());
    }

    public void moveToBackground(long timeoutTimerMs) {
        this.mBackgroundConnectionTimerMs = timeoutTimerMs;
        this.postEvent((IEvent)new BackgroundEvent());
    }

    public void serviceStarted() {
        this.postEvent((IEvent)new ServiceOnEvent());
    }

    public void serviceStopped() {
        this.postEvent((IEvent)new ServiceOffEvent());
    }

    public void onSocketProblem() {
        this.postEvent((IEvent)new SocketProblemEvent());
    }

    public void notifyLPError(LpError error, Throwable exception) {
        this.notifyError(error, exception.getMessage());
    }

    public void shutDown(ShutDownCompletionListener listener) {
        this.postEvent((IEvent)new ShutDownEvent(listener));
    }

    private void setFullConnectionRequired(String brandId, boolean isFullConnectionFlowRequired) {
        IConnectionParamsCache cache = this.mController.getAccountsController().getConnectionParamsCache(brandId);
        if (cache != null) {
            cache.setFullConnectionFlowRequired(isFullConnectionFlowRequired);
        } else {
            LPLog.INSTANCE.d(TAG, "Failed to get connection params cache - brandId = " + brandId + " - isFullConnectionFlowRequired = " + isFullConnectionFlowRequired);
        }
    }

    private void onUserExpired() {
        ResolveConversationCommand resolveConversationCommand = new ResolveConversationCommand(this.mController.getAmsConversations(), this.mBrandId, null);
        resolveConversationCommand.setOfflineMode(true);
        resolveConversationCommand.execute();
        this.mController.getAmsUsers().clearConsumerFromDB(this.mBrandId);
        this.mStateListener.notifyUserExpired();
    }

    private void reconnect() {
        if (this.mInternetInformationProvider != null && this.mInternetInformationProvider.isNetworkAvailable()) {
            this.changeStateAndPassEvent(this.mDisconnectingState, (IEvent)new ConnectEvent());
        } else {
            this.changeState(this.mDisconnectedState);
        }
    }

    private void notifyShutDownCompleted(ShutDownEvent ev) {
        ev.getListener().shutDownCompleted();
        LPLog.INSTANCE.d(TAG, "ShutDown completed!");
        super.shutDown();
    }

    private void notifyError(TaskType type, LpError lpError, String message) {
        if (this.mStateListener != null) {
            this.mStateListener.notifyError(type, lpError, message);
        }
    }

    private void notifyError(LpError lpError, String message) {
        if (this.mStateListener != null) {
            this.mStateListener.notifyError(lpError, message);
        }
    }

    abstract class ConnectedBaseState
    extends BaseConnectionState {
        public ConnectedBaseState(BaseConnectionState parent, String name, String logTag) {
            super(parent, name, logTag);
        }

        @Override
        public void visit(DisconnectEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public void visit(NetworkLostEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
        }

        @Override
        public void visit(ShutDownEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeStateAndPassEvent(ConnectionStateMachine.this.mDisconnectingState, (IEvent)ev);
        }
    }

    class BackgroundParentState
    extends AbstractBackgroundParentState {
        public BackgroundParentState(String name, String logTag) {
            super(name, logTag);
        }

        @Override
        public void actionOnEntry() {
            super.actionOnEntry();
            this.scheduleBackgroundConnectionTimeout();
        }

        @Override
        public void actionOnExit() {
            super.actionOnExit();
            LPLog.INSTANCE.d(this.TAG, "actionOnExit: Canceling backgroundTimeoutEvent");
            ConnectionStateMachine.this.cancelDelayedEvent(this.mBackgroundConnectionTimeoutEvent);
            this.mBackgroundConnectionTimeoutEvent = null;
        }

        @Override
        public void visit(BackgroundEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "BackgroundTimeoutEvent: Got a new background event");
            long newTime = System.currentTimeMillis() + ConnectionStateMachine.this.mBackgroundConnectionTimerMs;
            if (newTime > ConnectionStateMachine.this.mAbsoluteTimeForTimeout) {
                LPLog.INSTANCE.d(this.TAG, "BackgroundTimeoutEvent: new time for background is greater than the current (" + newTime + " > " + ConnectionStateMachine.this.mAbsoluteTimeForTimeout + "). Cancel old and set new timeout");
                ConnectionStateMachine.this.cancelDelayedEvent(this.mBackgroundConnectionTimeoutEvent);
                this.scheduleBackgroundConnectionTimeout();
            } else {
                LPLog.INSTANCE.d(this.TAG, "BackgroundTimeoutEvent: new time for background is smaller than the current (" + newTime + " < " + ConnectionStateMachine.this.mAbsoluteTimeForTimeout + "). Do nothing");
            }
        }

        @Override
        public void visit(BackgroundTimeOutEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "BackgroundTimeoutEvent: Timeout expired. Setting mBackgroundConnectionTimeoutEvent to null");
            this.mBackgroundConnectionTimeoutEvent = null;
        }

        @Override
        public void visit(SendStateEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "BackgroundParentState: actionOnEntry: Sending BACKGROUND state (if conversation active)");
            ConnectionStateMachine.this.mController.getMessagingController().changeChatState(ConnectionStateMachine.this.mBrandId, ConnectionStateMachine.this.mBrandId, ChatState.BACKGROUND);
        }

        @Override
        public void visit(NetworkLostEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
        }

        @Override
        public void visit(NetworkAvailableEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
        }

        @Override
        public void visit(SocketProblemEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
        }

        private void scheduleBackgroundConnectionTimeout() {
            if (ConnectionStateMachine.this.mBackgroundConnectionTimerMs < 0L) {
                ConnectionStateMachine.this.mAbsoluteTimeForTimeout = 0L;
            }
            ConnectionStateMachine.this.mAbsoluteTimeForTimeout = System.currentTimeMillis() + ConnectionStateMachine.this.mBackgroundConnectionTimerMs;
            LPLog.INSTANCE.d(this.TAG, "scheduleBackgroundConnectionTimeout: Setting background connection timeout for: " + ConnectionStateMachine.this.mBackgroundConnectionTimerMs);
            BackgroundTimeOutEvent timeoutEvent = new BackgroundTimeOutEvent();
            this.mBackgroundConnectionTimeoutEvent = ConnectionStateMachine.this.postDelayEvent((IEvent)timeoutEvent, ConnectionStateMachine.this.mBackgroundConnectionTimerMs);
        }
    }

    abstract class AbstractBackgroundParentState
    extends BaseConnectionState {
        protected Runnable mBackgroundConnectionTimeoutEvent;

        public AbstractBackgroundParentState(String name, String logTag) {
            super(name, logTag);
            this.mBackgroundConnectionTimeoutEvent = null;
        }

        public Runnable getBackgroundConnectionTimeoutEvent() {
            return this.mBackgroundConnectionTimeoutEvent;
        }
    }

    class ForegroundParentState
    extends BaseConnectionState {
        private List<BaseAmsAccountConnectionTask> mSecondaryConnectingTasks;

        public ForegroundParentState(String name, String logTag) {
            super(name, logTag);
            this.mSecondaryConnectingTasks = new ArrayList<BaseAmsAccountConnectionTask>(4);
        }

        @Override
        public void visit(SecondaryConnectEvent ev) {
            super.visit(ev);
            this.mSecondaryConnectingTasks = ConnectionStateMachine.this.mConnectionTasksHolder.getSecondaryConnectionTasks();
            ConnectionStateMachine.this.mCurrentTaskIndex = 0;
            ConnectionStateMachine.this.mExponentialBackOff.reset();
            ConnectionStateMachine.this.apply((IEvent)new RunTaskEvent());
        }

        @Override
        public void visit(SendStateEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "ForegroundParentState: SendStateEvent: Sending ACTIVE state (if conversation active)");
            ConnectionStateMachine.this.mController.getMessagingController().changeChatState(ConnectionStateMachine.this.mBrandId, ConnectionStateMachine.this.mBrandId, ChatState.ACTIVE);
        }

        @Override
        public void visit(NetworkAvailableEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "visit: We're in the foreground and got NetworkAvailable. Connect...");
            ConnectionStateMachine.this.reconnect();
        }

        @Override
        public void visit(SocketProblemEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.reconnect();
        }

        @Override
        public void visit(ConnectEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.reconnect();
        }

        @Override
        public void visit(SecondaryTaskSuccessEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "Task " + ev.getTaskName() + " finished successfully");
            ConnectionStateMachine.this.mCurrentTaskIndex++;
            ConnectionStateMachine.this.mExponentialBackOff.reset();
            LPLog.INSTANCE.d(this.TAG, "Running next task...");
            ConnectionStateMachine.this.postDelayEvent((IEvent)new RunTaskEvent(ConnectionStateMachine.this.mCurrentTaskIndex, ConnectionStateMachine.this.mExponentialBackOff.getRetryNumber()), ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis());
        }

        @Override
        public void visit(TaskFailedEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_000000A6, "Secondary Connection task " + (Object)((Object)ev.getType()) + " failed.", (Throwable)ev.getException());
            if (ev.getType() == TaskType.VERSION) {
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
                return;
            }
            if (ev.getType() == TaskType.CSDS) {
                ConnectionStateMachine.this.setFullConnectionRequired(ConnectionStateMachine.this.mBrandId, true);
                ConnectionStateMachine.this.reconnect();
                return;
            }
            ConnectionStateMachine.this.mExponentialBackOff.calculateNextBackOffMillis();
            if (ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis() == -1L) {
                LPLog.INSTANCE.w(this.TAG, "Connection task " + (Object)((Object)ev.getType()) + " failed. max retries achieved. Finishing connecting flow.");
                ConnectionStateMachine.this.setFullConnectionRequired(ConnectionStateMachine.this.mBrandId, true);
            }
        }

        @Override
        public void visit(RunTaskEvent ev) {
            if (ConnectionStateMachine.this.mCurrentTaskIndex < this.mSecondaryConnectingTasks.size()) {
                BaseAmsAccountConnectionTask currentTask = this.mSecondaryConnectingTasks.get(ConnectionStateMachine.this.mCurrentTaskIndex);
                currentTask.setBrandId(ConnectionStateMachine.this.mBrandId);
                currentTask.setIsSecondaryTask(true);
                LPLog.INSTANCE.d(this.TAG, "Running task: " + currentTask.getClass().getSimpleName() + " Retry #" + ConnectionStateMachine.this.mExponentialBackOff.getRetryNumber() + ", After delay: " + ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis());
                currentTask.execute();
            } else {
                LPLog.INSTANCE.d(this.TAG, "Secondary connection flow finished successfully! :)");
            }
        }
    }

    class DisconnectedState
    extends BaseConnectionState {
        public DisconnectedState(String name, String logTag) {
            super(name, logTag);
        }

        @Override
        public void actionOnEntry() {
            super.actionOnEntry();
            ConnectionStateMachine.this.mStateListener.notifyDisconnected();
            this.handleConnectionRegistration();
        }

        @Override
        public void actionOnExit() {
            super.actionOnExit();
            ConnectionStateMachine.this.mInternetInformationProvider.registerToNetworkChanges();
        }

        @Override
        public void visit(ConnectEvent ev) {
            if (ConnectionStateMachine.this.mInternetInformationProvider != null && ConnectionStateMachine.this.mInternetInformationProvider.isNetworkAvailable() && !ConnectionStateMachine.this.mController.getMessagingController().isSocketOpen(ConnectionStateMachine.this.mBrandId) && (ConnectionStateMachine.this.mForegroundServiceInterface.isBrandForeground(ConnectionStateMachine.this.mBrandId) || ev.connectInBG())) {
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectingState);
            } else {
                LPLog.INSTANCE.d(this.TAG, "ignoring ConnectEvent (either no connection or already connected or in bg");
            }
        }

        @Override
        public void visit(ForegroundEvent ev) {
            boolean networkAvailable;
            this.handleConnectionRegistration();
            boolean socketOpen = ConnectionStateMachine.this.mController.getMessagingController().isSocketOpen(ConnectionStateMachine.this.mBrandId);
            boolean bl = networkAvailable = ConnectionStateMachine.this.mInternetInformationProvider != null && ConnectionStateMachine.this.mInternetInformationProvider.isNetworkAvailable();
            if (networkAvailable && !socketOpen) {
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectingState);
            } else {
                LPLog.INSTANCE.d(this.TAG, "ignoring ForegroundEvent (either no connection or already connected) network: " + networkAvailable + "is socket open = " + socketOpen);
            }
        }

        @Override
        public void visit(BackgroundEvent ev) {
            this.handleConnectionRegistration();
        }

        @Override
        public void visit(NetworkAvailableEvent ev) {
            if (ConnectionStateMachine.this.mForegroundServiceInterface.isBrandForeground(ConnectionStateMachine.this.mBrandId)) {
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectingState);
            } else {
                LPLog.INSTANCE.d(this.TAG, "ignoring NetworkAvailableEvent (conversation is not in the foreground)");
            }
        }

        @Override
        public void visit(DisconnectEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "ignoring DisconnectEvent (already connected");
        }

        @Override
        public void visit(ShutDownEvent ev) {
            ConnectionStateMachine.this.notifyShutDownCompleted(ev);
        }

        private void handleConnectionRegistration() {
            if (ConnectionStateMachine.this.mForegroundServiceInterface.isBrandForeground(ConnectionStateMachine.this.mBrandId)) {
                if (!ConnectionStateMachine.this.mInternetInformationProvider.isNetworkAvailable()) {
                    LPLog.INSTANCE.d(this.TAG, "Register to network changes");
                    ConnectionStateMachine.this.mInternetInformationProvider.registerToNetworkChanges();
                }
            } else {
                LPLog.INSTANCE.d(this.TAG, "Unregister to network changes");
                ConnectionStateMachine.this.mInternetInformationProvider.unregisterToNetworkChanges();
            }
        }
    }

    class ConnectedBackgroundServiceState
    extends ConnectedBaseState {
        public ConnectedBackgroundServiceState(AbstractBackgroundParentState parent, String name, String logTag) {
            super(parent, name, logTag);
        }

        @Override
        public void visit(ServiceOffEvent ev) {
            if (((AbstractBackgroundParentState)this.parent).getBackgroundConnectionTimeoutEvent() != null) {
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectedBackgroundState);
            } else {
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
            }
        }

        @Override
        public void visit(BackgroundEvent ev) {
            super.visit(ev);
        }

        @Override
        public void visit(ForegroundEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeStateAndPassEvent(ConnectionStateMachine.this.mConnectedForegroundServiceState, (IEvent)new SendStateEvent());
        }

        @Override
        public void visit(SendStateEvent ev) {
            super.visit(ev);
        }
    }

    class ConnectedForegroundServiceState
    extends ConnectedBaseState {
        public ConnectedForegroundServiceState(BaseConnectionState parent, String name, String logTag) {
            super(parent, name, logTag);
        }

        @Override
        public void visit(ServiceOffEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectedForegroundState);
        }

        @Override
        public void visit(BackgroundEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeStateAndPassEvent(ConnectionStateMachine.this.mConnectedBackgroundServiceState, (IEvent)new SendStateEvent());
        }

        @Override
        public void visit(SendStateEvent ev) {
            super.visit(ev);
        }
    }

    class ConnectedBackgroundState
    extends ConnectedBaseState {
        public ConnectedBackgroundState(BaseConnectionState parent, String name, String logTag) {
            super(parent, name, logTag);
        }

        @Override
        public void visit(ServiceOnEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectedBackgroundServiceState);
        }

        @Override
        public void visit(ForegroundEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeStateAndPassEvent(ConnectionStateMachine.this.mConnectedForegroundState, (IEvent)new SendStateEvent());
        }

        @Override
        public void visit(BackgroundEvent ev) {
            super.visit(ev);
        }

        @Override
        public void visit(BackgroundTimeOutEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "BackgroundTimeoutEvent. We're in background without service. Disconnecting...");
            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
        }

        @Override
        public void visit(SendStateEvent ev) {
            super.visit(ev);
        }
    }

    class ConnectedForegroundState
    extends ConnectedBaseState {
        @Override
        public void actionOnEntry() {
            super.actionOnEntry();
            ConnectionStateMachine.this.mStateListener.notifyConnected();
        }

        public ConnectedForegroundState(BaseConnectionState parent, String name, String logTag) {
            super(parent, name, logTag);
        }

        @Override
        public void visit(ServiceOnEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectedForegroundServiceState);
        }

        @Override
        public void visit(BackgroundEvent ev) {
            super.visit(ev);
            ConnectionStateMachine.this.changeStateAndPassEvent(ConnectionStateMachine.this.mConnectedBackgroundState, (IEvent)new SendStateEvent());
        }

        @Override
        public void visit(SendStateEvent ev) {
            super.visit(ev);
        }
    }

    class DisconnectingState
    extends BaseConnectionState {
        private boolean isConnectingWaiting;
        private ShutDownEvent mShutDownFlowEvent;
        private Runnable mTimeoutEvent;

        public DisconnectingState(String name, String logTag) {
            super(name, logTag);
            this.isConnectingWaiting = false;
            this.mShutDownFlowEvent = null;
            this.mTimeoutEvent = null;
        }

        @Override
        public void actionOnEntry() {
            super.actionOnEntry();
            ConnectionStateMachine.this.mStateListener.notifyStartDisconnecting();
            ConnectionStateMachine.this.mCurrentTaskIndex = 0;
            ConnectionStateMachine.this.mExponentialBackOff.reset();
            this.mShutDownFlowEvent = null;
            this.mTimeoutEvent = null;
            ConnectionStateMachine.this.apply((IEvent)new RunTaskEvent());
        }

        @Override
        public void visit(ShutDownEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "Got ShutDownEvent, Disconnecting...");
            this.mShutDownFlowEvent = ev;
        }

        @Override
        public void visit(ConnectEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "Got ConnectEvent...");
            this.isConnectingWaiting = true;
        }

        @Override
        public void visit(ForegroundEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "Got ForegroundEvent...");
            this.isConnectingWaiting = true;
        }

        @Override
        public void visit(DisconnectEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "Already Disconnecting");
            this.isConnectingWaiting = false;
        }

        @Override
        public void visit(NetworkAvailableEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "NetworkAvailableEvent. Currently disconnecting, set pending connection");
            this.isConnectingWaiting = true;
        }

        @Override
        public void visit(NetworkLostEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "Network lost. Remove the pending connection");
            this.isConnectingWaiting = false;
        }

        @Override
        public void visit(TaskSuccessEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "Task " + ev.getTaskName() + " finished successfully");
            ConnectionStateMachine.this.cancelDelayedEvent(this.mTimeoutEvent);
            ConnectionStateMachine.this.mExponentialBackOff.reset();
            this.runNextTask();
        }

        @Override
        public void visit(TaskFailedEvent ev) {
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000146, "Task " + ev.getTaskName() + " failed");
            this.runNextTask();
        }

        @Override
        public void visit(TaskTimeOutEvent ev) {
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000147, "Timeout expired for task " + ev.getTaskName() + ". failing this task.");
            ev.failTask();
        }

        private void runNextTask() {
            if (this.isConnectingWaiting && ConnectionStateMachine.this.mForegroundServiceInterface.isBrandForeground(ConnectionStateMachine.this.mBrandId)) {
                LPLog.INSTANCE.d(this.TAG, "runNextTask: Connected event is waiting and we're in foreground. Running connect flow...");
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectingState);
            } else {
                ConnectionStateMachine.this.mCurrentTaskIndex++;
                LPLog.INSTANCE.d(this.TAG, "Running Next Task......");
                ConnectionStateMachine.this.postDelayEvent((IEvent)new RunTaskEvent(ConnectionStateMachine.this.mCurrentTaskIndex, ConnectionStateMachine.this.mExponentialBackOff.getRetryNumber()), ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis());
            }
        }

        @Override
        public void visit(RunTaskEvent ev) {
            if (this.isConnectingWaiting && ConnectionStateMachine.this.mForegroundServiceInterface.isBrandForeground(ConnectionStateMachine.this.mBrandId)) {
                LPLog.INSTANCE.d(this.TAG, "RunTaskEvent: Connected event is waiting and we're in foreground. Running connect flow...");
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectingState);
            } else if (ConnectionStateMachine.this.mCurrentTaskIndex < ConnectionStateMachine.this.mDisconnectingTasks.size()) {
                BaseAmsAccountConnectionTask currentTask = (BaseAmsAccountConnectionTask)ConnectionStateMachine.this.mDisconnectingTasks.get(ConnectionStateMachine.this.mCurrentTaskIndex);
                currentTask.setBrandId(ConnectionStateMachine.this.mBrandId);
                LPLog.INSTANCE.d(this.TAG, "Running task: " + currentTask.getClass().getSimpleName() + " Retry #" + ConnectionStateMachine.this.mExponentialBackOff.getRetryNumber() + ", After delay: " + ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis());
                currentTask.execute();
                this.scheduleTimeoutTask(currentTask);
            } else {
                LPLog.INSTANCE.d(this.TAG, "Disconnected flow finished successfully! :)");
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectedState);
                if (this.mShutDownFlowEvent != null) {
                    ConnectionStateMachine.this.notifyShutDownCompleted(this.mShutDownFlowEvent);
                }
            }
        }

        private void scheduleTimeoutTask(BaseAmsAccountConnectionTask currentTask) {
            TaskTimeOutEvent timeoutEvent = new TaskTimeOutEvent(currentTask, TaskType.CLOSING_SOCKET);
            this.mTimeoutEvent = ConnectionStateMachine.this.postDelayEvent((IEvent)timeoutEvent, 2000L);
            LPLog.INSTANCE.d(this.TAG, "scheduling TimeOut for currentTask = [" + currentTask.getName() + "]");
        }

        @Override
        public void actionOnExit() {
            ConnectionStateMachine.this.cancelDelayedEvent(this.mTimeoutEvent);
            this.mTimeoutEvent = null;
            this.isConnectingWaiting = false;
            ConnectionStateMachine.this.mExponentialBackOff.reset();
        }
    }

    class ConnectingState
    extends BaseConnectionState {
        boolean isDisconnectWaiting;
        boolean isBackgroundWaiting;
        private Runnable mDelayedTask;
        private ShutDownEvent mShutDownEvent;
        private boolean mSecondaryConnectionNeeded;

        public ConnectingState(String name, String logTag) {
            super(name, logTag);
            this.isDisconnectWaiting = false;
            this.isBackgroundWaiting = false;
            this.mDelayedTask = null;
            this.mShutDownEvent = null;
            this.mSecondaryConnectionNeeded = false;
        }

        @Override
        public boolean isConnecting() {
            return true;
        }

        @Override
        public void actionOnEntry() {
            boolean isFlowEnabled;
            super.actionOnEntry();
            ConnectionStateMachine.this.mStateListener.notifyStartConnecting();
            IConnectionParamsCache cache = ConnectionStateMachine.this.mController.getAccountsController().getConnectionParamsCache(ConnectionStateMachine.this.mBrandId);
            boolean bl = isFlowEnabled = cache != null && (cache.isVersionsCompatible() || cache.isFullConnectionFlowRequired());
            if (ConnectionStateMachine.this.mController.getAccountsController().isCsdsDataMissing(ConnectionStateMachine.this.mBrandId) || isFlowEnabled) {
                LPLog.INSTANCE.d(this.TAG, FlowTags.LOGIN, "ConnectingState actionOnEntry: CSDS data is missing from persistence OR version wasn't compatible on last connection or full flow required.");
                ConnectionStateMachine.this.mConnectingTasks = ConnectionStateMachine.this.mConnectionTasksHolder.getPrimaryFullConnectionTasks();
                this.mSecondaryConnectionNeeded = false;
            } else {
                LPLog.INSTANCE.d(this.TAG, FlowTags.LOGIN, "ConnectingState actionOnEntry: Persistence has CSDS data. Start short connection process");
                ConnectionStateMachine.this.mConnectingTasks = ConnectionStateMachine.this.mConnectionTasksHolder.getPrimaryShortConnectionTasks();
                this.mSecondaryConnectionNeeded = true;
            }
            ConnectionStateMachine.this.mCurrentTaskIndex = 0;
            ConnectionStateMachine.this.mExponentialBackOff.reset();
            this.isDisconnectWaiting = false;
            this.isBackgroundWaiting = false;
            this.mShutDownEvent = null;
            ConnectionStateMachine.this.apply((IEvent)new RunTaskEvent());
        }

        @Override
        public void visit(SecondaryTaskSuccessEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "Ignoring SecondaryTaskSuccessEvent: " + (Object)((Object)ev));
        }

        @Override
        public void visit(ConnectEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "Already Connecting");
            this.isDisconnectWaiting = false;
        }

        @Override
        public void visit(DisconnectEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "Got DisconnectEvent...");
            ConnectionStateMachine.this.mController.getAccountsController().getAccount(ConnectionStateMachine.this.mBrandId).resetConsumerAuthState();
            this.isDisconnectWaiting = true;
            if (this.mDelayedTask != null) {
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
            }
        }

        @Override
        public void visit(ForegroundEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "Cancel any background waiting event");
            this.isBackgroundWaiting = false;
        }

        @Override
        public void visit(BackgroundEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "Got BackgroundEvent. Disconnecting...");
            this.isBackgroundWaiting = true;
            if (this.mDelayedTask != null) {
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
            }
        }

        @Override
        public void visit(TaskSuccessEvent ev) {
            super.visit(ev);
            LPLog.INSTANCE.d(this.TAG, "Task " + ev.getTaskName() + " finished successfully");
            if (!this.handleWaitingEvents()) {
                ConnectionStateMachine.this.mCurrentTaskIndex++;
                ConnectionStateMachine.this.mExponentialBackOff.reset();
                LPLog.INSTANCE.d(this.TAG, "Running next task...");
                ConnectionStateMachine.this.postDelayEvent((IEvent)new RunTaskEvent(ConnectionStateMachine.this.mCurrentTaskIndex, ConnectionStateMachine.this.mExponentialBackOff.getRetryNumber()), ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis());
            }
        }

        @Override
        public void visit(TaskFailedEvent ev) {
            super.visit(ev);
            String errorMessage = ev.getException() == null ? "--no exception--" : ev.getException().getMessage();
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_000000A4, "Connection task " + (Object)((Object)ev.getType()) + " failed.", (Throwable)ev.getException());
            if (ev.getType() == TaskType.IDP && ev.getFailureReason() == AuthFailureReason.USER_EXPIRED) {
                LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_000000A5, "User expired! reconnecting with new User");
                ConnectionStateMachine.this.onUserExpired();
                ConnectionStateMachine.this.mExponentialBackOff.reset();
            } else if (ev.getType() == TaskType.IDP && ev.getFailureReason() == AuthFailureReason.TOKEN_EXPIRED) {
                ConnectionStateMachine.this.mController.getAmsUsers().clearConsumerFromDB(ConnectionStateMachine.this.mBrandId);
                ConnectionStateMachine.this.mStateListener.notifyTokenExpired();
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectedState);
                ConnectionStateMachine.this.mExponentialBackOff.reset();
            } else if (ev.getType() == TaskType.IDP && ev.getFailureReason() == AuthFailureReason.INVALID_CERTIFICATE) {
                ConnectionStateMachine.this.notifyError(TaskType.INVALID_CERTIFICATE, LpError.INVALID_CERTIFICATE, errorMessage);
            } else {
                ConnectionStateMachine.this.mExponentialBackOff.calculateNextBackOffMillis();
            }
            if (ev.getType() == TaskType.IDP || ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis() == -1L) {
                LPLog.INSTANCE.w(this.TAG, "Connection task " + (Object)((Object)ev.getType()) + " failed. Finishing connecting flow.");
                ConnectionStateMachine.this.notifyError(ev.getType(), ev.getLpError(), errorMessage);
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectedState);
                ConnectionStateMachine.this.setFullConnectionRequired(ConnectionStateMachine.this.mBrandId, true);
                if (ConnectionStateMachine.this.mController.getAccountsController().getAccount(ConnectionStateMachine.this.mBrandId) != null) {
                    ConnectionStateMachine.this.mController.getAccountsController().getAccount(ConnectionStateMachine.this.mBrandId).resetConsumerAuthState();
                }
                return;
            }
            if (!this.handleWaitingEvents()) {
                LPLog.INSTANCE.d(this.TAG, "Scheduling Task " + ev.getTaskName() + " in " + ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis() + " millis. retry number = " + ConnectionStateMachine.this.mExponentialBackOff.getRetryNumber());
                this.mDelayedTask = ConnectionStateMachine.this.postDelayEvent((IEvent)new RunTaskEvent(ConnectionStateMachine.this.mCurrentTaskIndex, ConnectionStateMachine.this.mExponentialBackOff.getRetryNumber()), ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis());
            }
        }

        @Override
        public void visit(RunTaskEvent ev) {
            this.mDelayedTask = null;
            if (!this.handleWaitingEvents()) {
                boolean isBrandForeground = ConnectionStateMachine.this.mForegroundServiceInterface.isBrandForeground(ConnectionStateMachine.this.mBrandId);
                if (ConnectionStateMachine.this.mCurrentTaskIndex < ConnectionStateMachine.this.mConnectingTasks.size()) {
                    BaseAmsAccountConnectionTask currentTask = (BaseAmsAccountConnectionTask)ConnectionStateMachine.this.mConnectingTasks.get(ConnectionStateMachine.this.mCurrentTaskIndex);
                    if (currentTask.requireSDKinForeground() && !isBrandForeground) {
                        ConnectionStateMachine.this.mCurrentTaskIndex++;
                        ConnectionStateMachine.this.apply((IEvent)ev);
                    } else {
                        currentTask.setBrandId(ConnectionStateMachine.this.mBrandId);
                        currentTask.setIsSecondaryTask(false);
                        LPLog.INSTANCE.d(this.TAG, "Running task: " + currentTask.getClass().getSimpleName() + " Retry #" + ConnectionStateMachine.this.mExponentialBackOff.getRetryNumber() + ", After delay: " + ConnectionStateMachine.this.mExponentialBackOff.getNextBackOffMillis());
                        currentTask.execute();
                    }
                } else {
                    LPLog.INSTANCE.d(this.TAG, "Connected flow finished successfully! :)");
                    if (this.mSecondaryConnectionNeeded) {
                        LPLog.INSTANCE.d(this.TAG, "RunTaskEvent: initiate the secondary connection flow");
                        if (isBrandForeground) {
                            ConnectionStateMachine.this.changeStateAndPassEvent(ConnectionStateMachine.this.mConnectedForegroundState, (IEvent)new SecondaryConnectEvent());
                        } else {
                            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
                        }
                    } else {
                        ConnectionStateMachine.this.setFullConnectionRequired(ConnectionStateMachine.this.mBrandId, false);
                        if (isBrandForeground) {
                            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mConnectedForegroundState);
                        } else {
                            ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
                        }
                    }
                }
            }
        }

        private boolean handleWaitingEvents() {
            if (this.mShutDownEvent != null) {
                LPLog.INSTANCE.d(this.TAG, "Disconnected event is waiting. running disconnect flow");
                ConnectionStateMachine.this.changeStateAndPassEvent(ConnectionStateMachine.this.mDisconnectingState, (IEvent)this.mShutDownEvent);
                return true;
            }
            if (this.isDisconnectWaiting || this.isBackgroundWaiting) {
                LPLog.INSTANCE.d(this.TAG, "ShutDown-Disconnect event is waiting. running disconnect flow with ShutDown flow");
                ConnectionStateMachine.this.changeState(ConnectionStateMachine.this.mDisconnectingState);
                return true;
            }
            return false;
        }

        @Override
        public void visit(ShutDownEvent ev) {
            LPLog.INSTANCE.d(this.TAG, "Got ShutDownEvent");
            this.mShutDownEvent = ev;
        }

        @Override
        public void actionOnExit() {
            super.actionOnExit();
            if (this.mDelayedTask != null) {
                LPLog.INSTANCE.d(this.TAG, "Clearing waiting delayed tasks.");
                ConnectionStateMachine.this.cancelDelayedEvent(this.mDelayedTask);
                this.mDelayedTask = null;
            }
        }
    }
}

