/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import com.liveperson.infra.Command;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.messaging.controller.ConnectionsController;

public class SynchronizedAmsConnectionCallback
implements Command {
    private final ConnectionsController mConnectionController;
    private String mBrandId;
    private boolean handled = false;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;
    private Runnable mCallback;

    public SynchronizedAmsConnectionCallback(ConnectionsController connectionController, String brandId, Runnable callback) {
        this.mConnectionController = connectionController;
        this.mBrandId = brandId;
        this.mCallback = callback;
    }

    public void execute() {
        if (this.mConnectionController.isSocketReady(this.mBrandId)) {
            this.handleConnection();
        } else {
            this.registerToConnectionStateChanges();
            this.validateStatusDidNotChangedDuringRegistration();
        }
    }

    private void registerToConnectionStateChanges() {
        this.mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_KEY_SOCKET_READY_ACTION").build((context, intent) -> {
            boolean isSocketReady = intent.getBooleanExtra("BROADCAST_KEY_SOCKET_READY_EXTRA", false);
            if (isSocketReady) {
                this.handleConnection();
            }
        });
    }

    private synchronized void validateStatusDidNotChangedDuringRegistration() {
        if (!this.handled && this.mConnectionController.isSocketReady(this.mBrandId)) {
            this.handleConnection();
        }
    }

    private synchronized void handleConnection() {
        if (this.handled) {
            return;
        }
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.unregister();
        }
        this.handled = true;
        this.mCallback.run();
    }
}

