/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.net.Uri;
import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.AmsAccount;
import org.json.JSONException;
import org.json.JSONObject;

public class IncaGetFileUrlRequest
implements Command {
    private static final String TAG = "IncaGetFileUrlRequest";
    private static final String INCA_GET_FILE_URL = "https://%s/messaging_history/api/account/%s/conversations/consumer/file-sharing?conversationId=%s&fileId=%s";
    private static final int REQUEST_TIMEOUT = 30000;
    private final String brandID;
    private final String conversationServerId;
    private final String fileId;
    private final Messaging controller;
    private final ICallback<Uri, Exception> mCallback;

    public IncaGetFileUrlRequest(Messaging controller, String brandId, String conversationId, String fileId, ICallback<Uri, Exception> callback) {
        this.controller = controller;
        this.brandID = brandId;
        this.conversationServerId = conversationId;
        this.fileId = fileId;
        this.mCallback = callback;
    }

    public void execute() {
        String incaDomain = this.controller.mAccountsController.getServiceUrl(this.brandID, "msgHist");
        String historyUrl = String.format(INCA_GET_FILE_URL, incaDomain, this.brandID, this.conversationServerId, this.fileId);
        Uri uri = Uri.parse((String)historyUrl).buildUpon().appendQueryParameter("source", "SDK_Android_History").build();
        LPLog.INSTANCE.d(TAG, "Getting inca messages url " + uri.toString());
        AmsAccount account = this.controller.mAccountsController.getAccount(this.brandID);
        String token = account == null ? "" : account.getToken();
        HttpGetRequest httpGetRequest = new HttpGetRequest(uri.toString());
        httpGetRequest.addHeader("Authorization", "Bearer " + token);
        httpGetRequest.setCertificatePinningKeys(this.controller.mAccountsController.getCertificatePinningKeys(this.brandID));
        httpGetRequest.setTimeout(30000);
        httpGetRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String res) {
                LPLog.INSTANCE.d(IncaGetFileUrlRequest.TAG, "onSuccess with INCA file response details " + res);
                if (TextUtils.isEmpty((CharSequence)res)) {
                    return;
                }
                try {
                    JSONObject jsonObject = new JSONObject(res);
                    String urlString = jsonObject.optString("urlForDownload");
                    Uri fileUri = Uri.parse((String)urlString);
                    IncaGetFileUrlRequest.this.mCallback.onSuccess((Object)fileUri);
                }
                catch (JSONException exception) {
                    IncaGetFileUrlRequest.this.mCallback.onError((Throwable)exception);
                }
            }

            public void onError(Exception exception) {
                LPLog.INSTANCE.e(IncaGetFileUrlRequest.TAG, ErrorCode.ERR_000000CF, "Exception", (Throwable)exception);
                IncaGetFileUrlRequest.this.mCallback.onError((Throwable)exception);
            }
        });
        HttpHandler.execute((HttpRequest)httpGetRequest);
    }
}

