/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

import android.text.TextUtils;
import com.liveperson.api.exception.BadConversationException;
import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.model.MultiDialog;
import com.liveperson.api.response.model.Participants;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ConversationHistoryDetails {
    private static final String TAG = "ConversationHistoryDetails";
    public Participants participants;
    @Deprecated
    private ConversationState state;
    protected ConversationState stage;
    public long startTs;
    public long endTs;
    public CSAT csat;
    public CloseReason closeReason;
    public DialogData[] dialogs;
    public String conversationId;

    public ConversationHistoryDetails(JSONObject jsonObject, String conversationId) throws JSONException, BadConversationException {
        this.endTs = jsonObject.optLong("endTs", -1L);
        this.startTs = jsonObject.optLong("startTs", -1L);
        if (conversationId == null) {
            conversationId = jsonObject.optString("convId");
        }
        this.conversationId = conversationId;
        if (this.startTs == 0L || this.endTs == 0L) {
            throw new BadConversationException("Bad startTs/endTs " + this.startTs + " / " + this.endTs);
        }
        this.parseStage(jsonObject);
        this.csat = new CSAT(jsonObject);
        JSONArray listOfParticipants = jsonObject.optJSONArray("participants");
        if (listOfParticipants != null) {
            this.parseParticipantsId(listOfParticipants);
        }
        this.parseCloseReason(jsonObject);
        JSONArray dialogArray = jsonObject.optJSONArray("dialogs");
        if (dialogArray == null) {
            dialogArray = new JSONArray();
        }
        if (TextUtils.isEmpty((CharSequence)conversationId)) {
            throw new BadConversationException("Empty conversation id");
        }
        this.dialogs = new DialogData[dialogArray.length()];
        for (int i = 0; i < dialogArray.length(); ++i) {
            DialogData dialog = MultiDialog.create(dialogArray.getJSONObject(i), conversationId);
            if (dialog.closeReason == null) {
                dialog.closeReason = this.closeReason;
            }
            if (dialog.state == null) {
                dialog.setState(DialogState.parse(this.getState()));
            }
            this.dialogs[i] = dialog;
        }
    }

    private static void fixTimestamps(DialogData[] dialogs) {
        if (dialogs.length == 0 || dialogs.length == 1) {
            return;
        }
        Arrays.sort(dialogs, (d1, d2) -> Long.compare(d1.creationTs, d2.creationTs));
        for (int i = 1; i < dialogs.length; ++i) {
            long diff = dialogs[i].creationTs - dialogs[i - 1].endTs;
            if (diff >= 1L) continue;
            dialogs[i - 1].endTs += diff - 1L;
        }
    }

    private void parseCloseReason(JSONObject jsonObject) {
        this.closeReason = CloseReason.CONSUMER;
        String closeReasonStr = jsonObject.optString("closeReason");
        if (closeReasonStr != null && !TextUtils.isEmpty((CharSequence)closeReasonStr) && !closeReasonStr.equals("null")) {
            this.closeReason = CloseReason.valueOf(closeReasonStr);
        }
    }

    private void parseParticipantsId(JSONArray listOfParticipants) {
        this.participants = new Participants();
        for (int i = 0; i < listOfParticipants.length(); ++i) {
            try {
                JSONObject par = (JSONObject)listOfParticipants.get(i);
                String id = par.optString("id");
                String stringRole = par.optString("role");
                Participants.ParticipantRole role = Participants.ParticipantRole.getParticipantRole(stringRole);
                if (role == null || id == null) continue;
                this.participants.add(new String[]{id}, role);
                continue;
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000069, "Failed to parse participants list.", (Throwable)e);
            }
        }
    }

    private void parseStage(JSONObject jsonObject) {
        if (jsonObject.has("stage")) {
            this.stage = ConversationState.parse(jsonObject.optString("stage"));
            LPLog.INSTANCE.d(TAG, "This JSON has stage field! JSON: " + jsonObject);
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000006A, "This JSON has NO stage field!");
        }
        String stateStr = jsonObject.optString("state");
        if (!TextUtils.isEmpty((CharSequence)stateStr)) {
            this.state = ConversationState.valueOf(stateStr);
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000006B, "parseStage: JSON does not have 'state' value.");
            if (this.stage != null) {
                this.state = this.stage;
                LPLog.INSTANCE.d(TAG, "parseStage: setting state to stage value (" + (Object)((Object)this.stage) + ")");
            } else {
                LPLog.INSTANCE.w(TAG, "parseStage: setting state CLOSE");
                this.state = ConversationState.CLOSE;
            }
        }
    }

    public ConversationState getState() {
        return this.stage == null ? this.state : this.stage;
    }
}

