package com.liveperson.messaging.commands;

import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.Command;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.socket.requests.ChatStateChangeRequest;


/**
 * Created by shiranr on 17/11/2015.
 */
public class ChangeChatStateCommand implements Command {
    private final AmsDialogs mDialogs;
    private ChatState mState;
    private String mSocketUrl;

    public ChangeChatStateCommand(AmsDialogs amsDialogs, String socketUrl, ChatState state) {
        mDialogs = amsDialogs;
        mSocketUrl = socketUrl;
        mState = state;
    }

    @Override
    public void execute() {
        final Dialog dialog = mDialogs.getActiveDialog();
        if (dialog != null && dialog.getState() == DialogState.OPEN) {
            SocketManager.getInstance().send(new ChatStateChangeRequest(mSocketUrl, dialog.getDialogId(), dialog.getConversationId(), mState));
        }
    }
}