package com.liveperson.messaging.model;

import com.liveperson.infra.database.DataBaseCommand;

import java.util.ArrayList;

/**
 * Created by shiranr on 11/21/16.
 */
public interface AmsMessagesLoaderProvider {
    void addOnUpdateListener(AmsMessages.MessagesListener messagesListener, AmsMessages.MessagesSortedBy messagesSortedByType, String typeValue);

    void removeOnUpdateListener();

    boolean hasListener();

    DataBaseCommand<ArrayList<FullMessageRow>> loadMessages(AmsMessages.MessagesSortedBy messagesSortedByType, String typeValue, int limit, long olderThanTimestamp, long newerThanTimestamp);

    MessagingUserProfile loadMessagingUserProfile(String originatorId);

    String getMyUserId(String targetId);

	/**
	 * Get QuickRepliesMessageHolder
	 * @param brandId
	 * @return
	 */
	QuickRepliesMessageHolder getQuickRepliesMessageHolder(String brandId);

	/**
	 * Reset QuickReplies message (set to null)
	 */
	void resetQuickRepliesMessageHolder();

	void removeCoBrowseMessage();

}
