/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.SiteSettingsRequest;
import com.liveperson.infra.utils.VersionUtils;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.controller.connection.IConnectionParamsCache;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SiteSettingsFetcherTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "SiteSettingsFetcherTask";
    public static final String SITE_SETTINGS_PROPERTY_NAME_ID = "id";
    public static final String SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE = "propertyValue";
    public static final String SITE_SETTINGS_PROPERTY_NAME_VALUE = "value";
    public static final String SITE_SETTINGS_PHOTO_SHARING_ID_VALUE = "messaging.file.sharing.enabled";
    public static final String SITE_SETTINGS_AUDIO_SHARING_ID_VALUE = "messaging.audio.sharing.enabled";
    public static final String SITE_SETTINGS_MIN_VERSION_ID_VALUE = "messaging.android.sdk.min.version";
    public static final String SITE_SETTINGS_SDK_ANALYTICS_ID_VALUE = "messaging.android.sdk.analytics.enabled";
    public static final String SITE_SETTINGS_EVENT_MANAGER_DOMAIN_ID_VALUE = "messaging.sdk.event.manager.domain";
    public static final String SITE_SETTINGS_CONTROLLER_BOT_ID_VALUE = "le.site.cobrowse.controllerBotPreferredForSystemMessages";
    public static final String SITE_SETTINGS_FILE_SHARING_BLUR_THUMBNAILS_ID_VALUE = "messaging.file.sharing.blurThumbnails";
    private final AccountsController mAccountsController;
    private boolean mPhotoSharingEnabled = true;
    private boolean mVoiceSharingEnabled = true;
    private boolean mSDKAnalyticsEnabled = true;
    private boolean enableTranscendentMessages = true;
    private boolean enableThumbnailBlur = false;
    private String mMinSdkVersionFromServer;
    private String mEventManagerDomain;

    public SiteSettingsFetcherTask(AccountsController accountsController) {
        this.mAccountsController = accountsController;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running site settings check task...");
        AmsConnectionAnalytics.siteSettingsFetcherTaskStart();
        String siteSettingsServiceDomain = this.mAccountsController.getServiceUrl(this.mBrandId, "acCdnDomain");
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        new SiteSettingsRequest(siteSettingsServiceDomain, this.mBrandId, certificates, (ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String siteSettingsJsonString) {
                if (!TextUtils.isEmpty((CharSequence)siteSettingsJsonString)) {
                    SiteSettingsFetcherTask.this.mMinSdkVersionFromServer = null;
                    boolean success = SiteSettingsFetcherTask.this.parseConfigurationData(siteSettingsJsonString);
                    if (success) {
                        LPLog.INSTANCE.d(SiteSettingsFetcherTask.TAG, "onSuccess: Got photo sharing enable value from site settings: " + SiteSettingsFetcherTask.this.mPhotoSharingEnabled);
                    } else {
                        LPLog.INSTANCE.w(SiteSettingsFetcherTask.TAG, "onSuccess: Cannot get photo sharing enable value from site settings. Use default (true)");
                    }
                    if (SiteSettingsFetcherTask.this.mMinSdkVersionFromServer != null) {
                        LPLog.INSTANCE.d(SiteSettingsFetcherTask.TAG, "onSuccess: Checking SDK version against version from site-settings");
                        IConnectionParamsCache cache = SiteSettingsFetcherTask.this.mAccountsController.getConnectionParamsCache(SiteSettingsFetcherTask.this.mBrandId);
                        if (cache != null) {
                            cache.updateAcCdnVersion(SiteSettingsFetcherTask.this.mMinSdkVersionFromServer);
                        } else {
                            String message = "onSuccess: did not get connection cache params for brand with id: " + SiteSettingsFetcherTask.this.mBrandId;
                            LPLog.INSTANCE.d(SiteSettingsFetcherTask.TAG, message);
                        }
                        if (!VersionUtils.isValidSdkVersion((String)SiteSettingsFetcherTask.this.mMinSdkVersionFromServer)) {
                            String detailMessage = "Current SDK version is smaller than the one from the server (" + SiteSettingsFetcherTask.this.mMinSdkVersionFromServer + "). SDK will not connect. Please upgrade SDK. ";
                            SiteSettingsFetcherTask.this.mCallback.onTaskError(TaskType.VERSION, LpError.INVALID_SDK_VERSION, new Exception(detailMessage));
                            return;
                        }
                    } else {
                        LPLog.INSTANCE.w(SiteSettingsFetcherTask.TAG, "onSuccess: did not get min SDK version from site-settings. Ignore and continue as usual");
                    }
                    AmsConnectionAnalytics.siteSettingsFetcherTaskEnd();
                    SiteSettingsFetcherTask.this.mCallback.onTaskSuccess();
                }
            }

            public void onError(Exception exception) {
                if (exception instanceof SSLPeerUnverifiedException) {
                    SiteSettingsFetcherTask.this.mCallback.onTaskError(TaskType.INVALID_CERTIFICATE, LpError.INVALID_CERTIFICATE, exception);
                } else {
                    SiteSettingsFetcherTask.this.mCallback.onTaskSuccess();
                }
            }
        }).execute();
    }

    private boolean parseConfigurationData(String siteSettingsJsonString) {
        try {
            this.mPhotoSharingEnabled = true;
            JSONArray jsonarray = new JSONArray(siteSettingsJsonString);
            for (int i = 0; i < jsonarray.length(); ++i) {
                String blurThumbnail;
                JSONObject propertyValue;
                JSONObject jsonobject = jsonarray.getJSONObject(i);
                String id = jsonobject.getString(SITE_SETTINGS_PROPERTY_NAME_ID);
                if (id.equalsIgnoreCase(SITE_SETTINGS_PHOTO_SHARING_ID_VALUE)) {
                    propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE);
                    String enabled = propertyValue.getString(SITE_SETTINGS_PROPERTY_NAME_VALUE);
                    if (!enabled.equalsIgnoreCase("false")) continue;
                    this.mPhotoSharingEnabled = false;
                    LPLog.INSTANCE.d(TAG, "parseConfigurationData: photo sharing is disabled in SiteSettings");
                    continue;
                }
                if (id.equalsIgnoreCase(SITE_SETTINGS_AUDIO_SHARING_ID_VALUE)) {
                    propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE);
                    String audioEnabled = propertyValue.getString(SITE_SETTINGS_PROPERTY_NAME_VALUE);
                    if (!audioEnabled.equalsIgnoreCase("false")) continue;
                    this.mVoiceSharingEnabled = false;
                    LPLog.INSTANCE.d(TAG, "parseConfigurationData: audio sharing is disabled in SiteSettings");
                    continue;
                }
                if (id.equalsIgnoreCase(SITE_SETTINGS_MIN_VERSION_ID_VALUE)) {
                    propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE);
                    this.mMinSdkVersionFromServer = propertyValue.getString(SITE_SETTINGS_PROPERTY_NAME_VALUE);
                    LPLog.INSTANCE.d(TAG, "onSuccess: minSdkVersion from site-settings: " + this.mMinSdkVersionFromServer);
                    continue;
                }
                if (id.equalsIgnoreCase(SITE_SETTINGS_SDK_ANALYTICS_ID_VALUE)) {
                    propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE);
                    String analyticsEnabled = propertyValue.getString(SITE_SETTINGS_PROPERTY_NAME_VALUE);
                    if (!analyticsEnabled.equalsIgnoreCase("false")) continue;
                    this.mSDKAnalyticsEnabled = false;
                    LPLog.INSTANCE.d(TAG, "parseConfigurationData: sdk analytics is disabled in SiteSettings");
                    continue;
                }
                if (id.equalsIgnoreCase(SITE_SETTINGS_EVENT_MANAGER_DOMAIN_ID_VALUE)) {
                    propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE);
                    this.mEventManagerDomain = propertyValue.getString(SITE_SETTINGS_PROPERTY_NAME_VALUE);
                    continue;
                }
                if (id.equalsIgnoreCase(SITE_SETTINGS_CONTROLLER_BOT_ID_VALUE)) {
                    propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE);
                    String controllerBotEnabled = propertyValue.getString(SITE_SETTINGS_PROPERTY_NAME_VALUE);
                    this.enableTranscendentMessages = controllerBotEnabled.equalsIgnoreCase("false");
                    LPLog.INSTANCE.d(TAG, "enableTranscendentMessages: " + this.enableTranscendentMessages);
                    continue;
                }
                if (!id.equalsIgnoreCase(SITE_SETTINGS_FILE_SHARING_BLUR_THUMBNAILS_ID_VALUE) || !(blurThumbnail = (propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE)).getString(SITE_SETTINGS_PROPERTY_NAME_VALUE)).equalsIgnoreCase("true")) continue;
                this.enableThumbnailBlur = true;
                LPLog.INSTANCE.d(TAG, "parseConfigurationData: File sharing thumbnail blur is enabled in SiteSettings");
            }
            LPLog.INSTANCE.d(TAG, "onSuccess: site settings enablePhotoSharing is: " + this.mPhotoSharingEnabled);
        }
        catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "parseConfigurationData: error fetching photo sharing enabled from site settings. Use default (true)", (Throwable)e);
            return false;
        }
        PreferenceManager.getInstance().setBooleanValue("site_settings_photo_sharing_enabled_preference_key", "appLevelPreferences", this.mPhotoSharingEnabled);
        PreferenceManager.getInstance().setBooleanValue("site_settings_voice_sharing_enabled_preference_key", "appLevelPreferences", this.mVoiceSharingEnabled);
        PreferenceManager.getInstance().setBooleanValue("site_settings_sdk_analytics_enabled_preference_key", "appLevelPreferences", this.mSDKAnalyticsEnabled);
        PreferenceManager.getInstance().setBooleanValue("enable_transcendent_messages_preference_key", "appLevelPreferences", this.enableTranscendentMessages);
        PreferenceManager.getInstance().setStringValue("site_settings_event_manager_domain_preference_key", "appLevelPreferences", this.mEventManagerDomain);
        PreferenceManager.getInstance().setBooleanValue("site_settings_thumbnail_blur_enabled_preference_key", "appLevelPreferences", this.enableThumbnailBlur);
        Infra.instance.getAnalyticsService().setIsAnalyticsEnabled(this.mSDKAnalyticsEnabled);
        return true;
    }

    @Override
    public String getName() {
        return TAG;
    }
}

