package com.liveperson.api.request;

import com.liveperson.api.response.AbstractResponse;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Shayl on 8/9/2015.
 */
public class GetClock extends AbstractRequest {

    public static final String CURRENT_TIME = "currentTime";
    public static final String GET_CLOCK_TYPE = "GetClock";


    public GetClock() {
        super();
    }

    @Override
    public String getMessageType() {
        return GET_CLOCK_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        json.put(JSON_KEY_BODY, new JSONObject());
    }


    public static class Response extends AbstractResponse<Response.Body> {
        public static String GET_CLOCK_RESPONSE_TYPE = "GetClockResponse";

        public Body body = new Body();

        public Response(JSONObject obj) throws JSONException {
            super(obj);

            JSONObject innerBody = obj.getJSONObject(JSON_KEY_BODY);
            body.currentTime = innerBody.getLong(CURRENT_TIME);
        }

        @Override
        public Response.Body getBody() {
            return body;
        }

        public static class Body {
            public long currentTime;
        }

    }
}
