package com.liveperson.api.response.events

import com.liveperson.api.exception.BadMessageException
import com.liveperson.api.response.AbstractResponse
import com.liveperson.infra.log.LPLog
import com.liveperson.messaging.Messaging
import com.liveperson.messaging.network.socket.MessagingEventNotificationHandler
import org.json.JSONObject

/**
 * Created by shiranr on 1/30/18.
 */
class MessagingEventNotification(json : JSONObject) : AbstractResponse<ArrayList<ContentEventNotification>>(json){

    companion object {
        private const val TAG = "MessagingEventNotification"

        private const val MESSAGING_EVENT_NOTIFICATION_TYPE = "ms.MessagingEventNotification"

        @JvmStatic
        fun getType() = MESSAGING_EVENT_NOTIFICATION_TYPE

        @JvmStatic
        fun getResponseHandler(messaging: Messaging) = MessagingEventNotificationHandler(messaging)

    }

    private var changes: ArrayList<ContentEventNotification>

    init {
        val body = json.getJSONObject("body")
        val listOfChanges = body.getJSONArray("changes")
        changes = ArrayList(listOfChanges.length())
        for (i in 0 until listOfChanges.length()){
            try {
                changes.add(ContentEventNotification(listOfChanges.getJSONObject(i)))
            }catch (e : BadMessageException){
                LPLog.w(TAG, "Bad message : ", e)
                continue
            }
        }
    }

    override fun getBody(): ArrayList<ContentEventNotification> = changes
}
