package com.liveperson.messaging.controller.connection.connectionevents;

import com.liveperson.infra.statemachine.BaseEvent;
import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.connection.BaseConnectionState;

import java.util.concurrent.TimeoutException;

/**
 * Created by shiranr on 13/03/2016.
 */
public class TaskTimeOutEvent extends BaseEvent {

    private final BaseAmsAccountConnectionTask mCurrentTask;
    private TaskType taskType;

    public TaskTimeOutEvent(BaseAmsAccountConnectionTask currentTask, TaskType taskType) {
        super("TaskTimeOutEvent");
        mCurrentTask = currentTask;
        this.taskType = taskType;
    }

    @Override
    public void accept(IState state) {
        ((BaseConnectionState) state).visit(this);
    }

    public String getTaskName() {
        return mCurrentTask.getName();
    }

    public void failTask() {
        mCurrentTask.getCallback().onTaskError(taskType, LpError.TIMEOUT, new TimeoutException());
    }
}
