/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.os.Bundle;
import android.text.TextUtils;
import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.ConsumerManager;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.controller.connection.ConnectionParamsCache;
import com.liveperson.messaging.controller.connection.IConnectionParamsCache;
import com.liveperson.messaging.utils.TokenUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AmsAccount {
    private static final String TAG = "AmsAccount";
    private static final String KEY_CONNECTOR_ID_ENC = "account_connector_id_enc";
    public static final String BROADCAST_KEY_AUTH_COMPLETED_ACTION = "BROADCAST_KEY_AUTH_COMPLETED_ACTION";
    private PreferenceManager mPreferenceManager = PreferenceManager.getInstance();
    private IConnectionParamsCache mConnectionParamsCache;
    private String mBrandId;
    private LPAuthenticationParams mLPAuthenticationParams;
    private String mAppId;
    private String mConnectorId;
    private ConsumerManager consumerManager;
    private boolean performStepUp;

    public AmsAccount(String brandId) {
        this.mBrandId = brandId;
        this.consumerManager = Infra.instance.getConsumerManager();
        String decryptedConnectorId = this.mPreferenceManager.getStringValue(KEY_CONNECTOR_ID_ENC, this.mBrandId, null);
        if (!TextUtils.isEmpty((CharSequence)decryptedConnectorId)) {
            this.mConnectorId = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)decryptedConnectorId);
        }
        this.mConnectionParamsCache = new ConnectionParamsCache(this.mBrandId);
        if (this.consumerManager.getActiveConsumer() != null) {
            LPLog.INSTANCE.d(TAG, "restoring mOriginalConsumerId = " + LPLog.INSTANCE.mask((Object)this.consumerManager.getActiveConsumer().getOriginalConsumerId()) + ", mConnectorId = " + LPLog.INSTANCE.mask((Object)this.mConnectorId));
            LPLog.INSTANCE.d(TAG, "restoring data: mToken = " + LPLog.INSTANCE.mask((Object)this.consumerManager.getActiveConsumer().getLpToken()));
        }
    }

    public String getToken() {
        return this.consumerManager.getActiveConsumer() != null ? this.consumerManager.getActiveConsumer().getLpToken() : "";
    }

    public void sendAuthenticationCompletedStatus() {
        Bundle connectionBundle = new Bundle();
        connectionBundle.putString("BROADCAST_KEY_BRAND_ID", this.mBrandId);
        LocalBroadcast.sendBroadcast((String)BROADCAST_KEY_AUTH_COMPLETED_ACTION, (Bundle)connectionBundle);
    }

    public LPAuthenticationParams getLPAuthenticationParams() {
        return this.mLPAuthenticationParams;
    }

    public void setLPAuthenticationParams(LPAuthenticationParams lpAuthenticationParams) {
        this.mLPAuthenticationParams = lpAuthenticationParams;
        this.setPerformStepUp(lpAuthenticationParams.getPerformStepUp());
    }

    public List<String> getCertificatePinningKeys() {
        LPAuthenticationParams authParams;
        if (this.mLPAuthenticationParams != null) {
            return this.mLPAuthenticationParams.getCertificatePinningKeys();
        }
        if (this.consumerManager.getActiveConsumer() != null && (authParams = this.consumerManager.getActiveConsumer().getLpAuthenticationParams()) != null) {
            return authParams.getCertificatePinningKeys();
        }
        return new ArrayList<String>();
    }

    public boolean isAuthenticated() {
        return this.mLPAuthenticationParams != null && this.mLPAuthenticationParams.isAuthenticated();
    }

    public boolean hasFinishedAuthenticating() {
        return this.consumerManager.isAuthenticated();
    }

    public void resetConsumerAuthState() {
        this.consumerManager.resetAuthState();
    }

    public boolean setCSDSMap(HashMap<String, String> csdsUrls) {
        return this.mConnectionParamsCache.updateCsdsDomains(csdsUrls);
    }

    public boolean isCsdsDataMissing() {
        return !this.mConnectionParamsCache.isCsdsFilled();
    }

    public String getServiceUrl(String serviceName) {
        if (!this.mConnectionParamsCache.isCsdsFilled()) {
            return null;
        }
        return this.mConnectionParamsCache.getServiceDomain(serviceName);
    }

    public void setAppId(String appId) {
        this.mAppId = appId;
    }

    public String getAppId() {
        return this.mAppId;
    }

    public IConnectionParamsCache getConnectionParamsCache() {
        return this.mConnectionParamsCache;
    }

    public boolean isHostAppJWTExpired() {
        String jwt = this.mLPAuthenticationParams.getHostAppJWT();
        return TokenUtils.isJwtExpired(jwt);
    }

    public boolean isTokenExpired() {
        String jwt = this.getToken();
        return TokenUtils.isJwtExpired(jwt);
    }

    public boolean isAutoMessagesEnabled() {
        return this.mConnectionParamsCache.isAutoMessagesFeatureEnabled();
    }

    public void setConnectorId(String connectorId) {
        this.mConnectorId = connectorId;
        String encryptedConnectorId = DBEncryptionHelper.encrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)connectorId);
        this.mPreferenceManager.setStringValue(KEY_CONNECTOR_ID_ENC, this.mBrandId, encryptedConnectorId);
    }

    public String getConnectorId() {
        return this.mConnectorId;
    }

    public String getStepUpConnectorId() {
        return this.mPreferenceManager.getStringValue("step_up_connector_id", this.mBrandId, null);
    }

    public boolean isPerformStepUp() {
        return this.performStepUp;
    }

    public void setPerformStepUp(boolean performStepUp) {
        LPAuthenticationType type;
        if (performStepUp && (type = this.consumerManager.getCurrentConsumerAuthType(this.mBrandId)) != null && type.equals((Object)LPAuthenticationType.UN_AUTH)) {
            this.performStepUp = true;
            return;
        }
        this.performStepUp = false;
    }

    public boolean isInUnAuthMode() {
        LPAuthenticationType authType = this.getLPAuthenticationParams().getAuthType();
        return authType == LPAuthenticationType.UN_AUTH;
    }
}

