package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.PublishEvent;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.request.message.FormSubmissionPublishMessage;
import com.liveperson.api.request.message.PublishMessage;
import com.liveperson.messaging.Messaging;

/**
 * Created by Ilya Gazman on 11/10/2015.
 * <p/>
 * A request to send message
 */
public class SendFormSubmissionMessageRequest extends SendMessageRequest {

	private static final String TAG = "SendFormSubmissionMessageRequest";

	private final String mEventId;
	private String mInvitationId;
	private String mSubmissionId;
	private String mDialogId;
	private String mConversationId;
	protected PublishMessage mMessage;
	private PublishEvent.Type mType = PublishEvent.Type.ContentEvent;
	private ContentType mContentType = ContentType.forms_secure_submission;

	/**
	 * This constructor gets the requestId as one of its parameters and override with it the request's one
	 */
	public SendFormSubmissionMessageRequest(Messaging controller, String eventId, String targetId,
											String brandId, String dialogId, String conversationId,
											String invitationId, String submissionId) {
		super(controller, eventId, targetId, brandId, dialogId, conversationId);
		mDialogId = dialogId;
		mConversationId = conversationId;
		mEventId = eventId;
		mInvitationId = invitationId;
		mSubmissionId = submissionId;
		mMessage = new FormSubmissionPublishMessage(mInvitationId, mSubmissionId);
	}

	public void setMessageContent(String msg) {
		mMessage = new FormSubmissionPublishMessage(mInvitationId, mSubmissionId);
	}

	@Override
	protected String getData() {
		return new PublishEvent(mDialogId, mConversationId, mMessage, mType, mContentType, mEventId, null).toJsonString(getRequestId());
	}

	@Override
	protected String getRequestName() {
		return TAG;
	}

}