package com.liveperson.api.response;

import com.liveperson.api.response.model.QueryParams;
import com.liveperson.infra.log.LPLog;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by shiranr on 06/07/2016.
 */
public class BaseGenerateURLResponse {

	private static final String TAG = BaseGenerateURLResponse.class.getName();
	private static final String RELATIVE_PATH = "relativePath";
	private static final String QUERY_PARAMS = "queryParams";

	public String relativePath;
	public QueryParams queryParams;

	public BaseGenerateURLResponse(JSONObject innerBody) throws JSONException {
		if (innerBody != null) {
			relativePath = innerBody.optString(RELATIVE_PATH);
			queryParams = new QueryParams(innerBody.getJSONObject(QUERY_PARAMS));
			LPLog.INSTANCE.d(TAG, "RELATIVE_PATH:" + relativePath + " " + "TEMP_URL:" + queryParams.tempURL + " " + "EXPIRE_TIME:" + queryParams.expireTime);
		}
	}

}
