package com.liveperson.messaging.network.http;

import android.net.Uri;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpStringRequestBody;
import com.liveperson.infra.network.socket.SocketToRestCommand;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;

public class SendFileRequestRest extends SocketToRestCommand implements Command {

    private static final String TAG = "SendFileRequestRest";
    private static final int UPLOAD_IMAGE_TIMEOUT = 30000;
    private final RestRequestParams params;
    private final BaseAMSSocketRequest sendMessageRequest;
    private ICallback mCallback;

    /*first param - CSDS service domain for asyncMessagingEnt
    second param = account/brand ID
    third param = token*/

    public SendFileRequestRest(RestRequestParams params, SendMessageRequest sendMessageRequest) {
        this.params = params;
        this.sendMessageRequest = sendMessageRequest;
    }

    /**
     * Execute request
     */
    @Override
    public void execute() {

        Uri.Builder builder = new Uri.Builder();
		//builder.scheme("https");
        String mDomainTemplate = "https://%1$s/rest_api/account/%2$s/messaging/consumer/%3$s";
        builder.path(String.format(mDomainTemplate, params.mDomain, params.mBrandId, params.mToken));


        HttpPostRequest httpPostRequest = new HttpPostRequest(builder.build().toString());
		HttpRequestBody body = new HttpStringRequestBody() {
			@Override
			public String get() {
				return getData(sendMessageRequest);
			}

			@Override
			public String getContentType() {
				return "application/json";// TODO: 7/19/16 change this to multipart or dynamic...
			}
		};
        httpPostRequest.setBody(body);
        httpPostRequest.setCertificatePinningKeys(params.mCertificates);
        httpPostRequest.setTimeout(30000);// TODO: 7/19/16 is this enough?
		LPLog.INSTANCE.d(TAG, "Sending upload file to swift: ");
        httpPostRequest.setCallback(new ICallback<String, Exception>() {

            @Override
            public void onSuccess(String body) {
                LPLog.INSTANCE.d(TAG, "Rest response: " + body);
				/*mCallback.onSuccess(body);*/
            }

            @Override
            public void onError(Exception exception) {
				/*mCallback.onError(exception);*/
            }
        });
        HttpHandler.execute(httpPostRequest);
    }


}
