package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.SetUserProfile;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Ilya Gazman on 11/22/2015.
 * <p/>
 * A request to set user profile
 */
public class SetUsersProfileRequest extends BaseAMSSocketRequest<ReqBody.StringResp, SetUsersProfileRequest> {

	private static final String TAG = "SetUsersProfileRequest";

    private final MessagingUserProfile mProfile;
    private final AmsUsers mAmsUsers;
    private final String mBrandId;


    /**
     * A request to set user profile data in the back end.
     *  @param amsUsers
     * @param mSocketUrl
     * @param userProfile the user profile
     */
    public SetUsersProfileRequest(AmsUsers amsUsers, String mSocketUrl, String brandId, MessagingUserProfile userProfile) {
        super(mSocketUrl);
        mBrandId = brandId;
        mProfile = userProfile;
        mAmsUsers = amsUsers;
    }

    @Override
    protected BaseResponseHandler<ReqBody.StringResp, SetUsersProfileRequest> getResponseHandler() {

		return new BaseResponseHandler<ReqBody.StringResp, SetUsersProfileRequest>() {

            @Override
            public String getAPIResponseType() {
                return ReqBody.StringResp.REQ_BODY_RESPONSE_TYPE;
            }

            @Override
			protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
				return new ReqBody.StringResp(jsonObject);
			}

			@Override
			protected boolean handle(ReqBody.StringResp response) {
				LPLog.INSTANCE.d(TAG, "Received response: " + LPLog.INSTANCE.mask(response.getBody()));

				if (response.code == 200) {
					// Update the user profile to the DB
                    //TODO: Check if we need the brand id here
                    mProfile.setBrandID(mBrandId);
					mAmsUsers.updateUserProfile(mProfile);
				}
				else {
					LPLog.INSTANCE.w(TAG, "Received response code other than 200 (" + response.code + "). Did not update DB");
				}
                return true;
			}
		};
    }

    @Override
    protected String getData() {
        return new SetUserProfile(mProfile).toJsonString(getRequestId());
    }


    @Override
    protected String getRequestName() {
        return TAG;
    }
}
