/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

import com.liveperson.api.response.model.Participants;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import org.json.JSONException;
import org.json.JSONObject;

public class OriginatorMetadata {
    private static final String TAG = "OriginatorMetadata";
    private static final String ID = "id";
    private static final String ROLE = "role";
    public String mId;
    public Participants.ParticipantRole mRole;

    public static OriginatorMetadata fromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            LPLog.INSTANCE.d(TAG, "fromJson: no OriginatorMetadata content");
            return null;
        }
        OriginatorMetadata originatorMetadata = new OriginatorMetadata();
        try {
            originatorMetadata.mId = jsonObject.getString(ID);
            originatorMetadata.mRole = Participants.ParticipantRole.valueOf(jsonObject.getString(ROLE));
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000059, "fromJson: missing mandatory information", (Throwable)e);
            return null;
        }
        return originatorMetadata;
    }
}

