/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.ACCDNConnectorsRequest;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsAccount;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00172\u000e\u0010 \u001a\n\u0018\u00010!j\u0004\u0018\u0001`\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/liveperson/messaging/commands/tasks/ACCDNConnectorsTask;", "Lcom/liveperson/messaging/commands/tasks/BaseAmsAccountConnectionTask;", "accountsController", "Lcom/liveperson/messaging/controller/AccountsController;", "(Lcom/liveperson/messaging/controller/AccountsController;)V", "AUTH_TYPE_KEY", "", "CONFIGURATION_KEY", "ID_KEY", "ISSUER_DISPLAY_NAME_KEY", "JS_METHOD_CONTEXT_KEY", "JS_METHOD_NAME_KEY", "TAG", "getAccountsController", "()Lcom/liveperson/messaging/controller/AccountsController;", "performStepUp", "", "getPerformStepUp", "()Ljava/lang/Boolean;", "setPerformStepUp", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "execute", "", "extractConnectorId", "data", "Lorg/json/JSONArray;", "getIssuerName", "getName", "getRequiredConnectorType", "", "onTaskError", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "messaging_release"})
public final class ACCDNConnectorsTask
extends BaseAmsAccountConnectionTask {
    private final String TAG = "ACCDNConnectorsTask";
    private final String CONFIGURATION_KEY = "configuration";
    private final String ID_KEY = "id";
    private final String JS_METHOD_NAME_KEY = "jsMethodName";
    private final String JS_METHOD_CONTEXT_KEY = "jsContext";
    private final String AUTH_TYPE_KEY = "type";
    private final String ISSUER_DISPLAY_NAME_KEY = "issuerDisplayName";
    @Nullable
    private Boolean performStepUp;
    @NotNull
    private final AccountsController accountsController;

    @Nullable
    public final Boolean getPerformStepUp() {
        return this.performStepUp;
    }

    public final void setPerformStepUp(@Nullable Boolean bl) {
        this.performStepUp = bl;
    }

    public void execute() {
        AmsAccount amsAccount = this.accountsController.getAccount(this.mBrandId);
        Boolean bl = this.performStepUp = amsAccount != null ? Boolean.valueOf(amsAccount.isPerformStepUp()) : null;
        if (Intrinsics.areEqual((Object)this.performStepUp, (Object)false) && this.getIssuerName() == null) {
            this.mCallback.onTaskSuccess();
            return;
        }
        List<String> certificates = this.accountsController.getCertificatePinningKeys(this.mBrandId);
        String acCdnDomain = this.accountsController.getServiceUrl(this.mBrandId, "acCdnDomain");
        LPLog.INSTANCE.i(this.TAG, "Starting ACCDNConnectors Task....");
        new ACCDNConnectorsRequest(acCdnDomain, this.mBrandId, certificates, (ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ ACCDNConnectorsTask this$0;

            public void onSuccess(@Nullable String value) {
                LPLog.INSTANCE.i(ACCDNConnectorsTask.access$getTAG$p(this.this$0), "Successfully got connector information: " + value);
                CharSequence charSequence = value;
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    try {
                        ACCDNConnectorsTask.access$extractConnectorId(this.this$0, new JSONArray(value));
                    }
                    catch (Exception exception) {
                        ACCDNConnectorsTask.access$onTaskError(this.this$0, exception);
                    }
                }
                this.this$0.mCallback.onTaskSuccess();
            }

            public void onError(@Nullable Exception exception) {
                ACCDNConnectorsTask.access$onTaskError(this.this$0, exception);
            }
            {
                this.this$0 = $outer;
            }
        }).execute();
    }

    private final void onTaskError(Exception exception) {
        LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000164, "Failed to get connector information: " + exception);
        this.mCallback.onTaskError(TaskType.ACCDN_CONNECTORS, LpError.UNKNOWN, exception);
    }

    @Override
    @NotNull
    public String getName() {
        return this.TAG;
    }

    /*
     * WARNING - void declaration
     */
    private final void extractConnectorId(JSONArray data) {
        String issuerDisplayName = this.getIssuerName();
        int n = 0;
        int n2 = data.length();
        while (n < n2) {
            void i;
            JSONObject connector = data.getJSONObject((int)i);
            int connectorType = this.getRequiredConnectorType();
            if (connector.has(this.ID_KEY) && connector.has(this.CONFIGURATION_KEY)) {
                JSONObject configuration = connector.getJSONObject(this.CONFIGURATION_KEY);
                if (!(!Intrinsics.areEqual((Object)this.performStepUp, (Object)true) || configuration.has(this.JS_METHOD_NAME_KEY) && configuration.getString(this.JS_METHOD_NAME_KEY).equals("lpTag.taglets.unAuthMessaging.lpUnauthFunction") || configuration.has(this.JS_METHOD_CONTEXT_KEY) && configuration.getString(this.JS_METHOD_CONTEXT_KEY).equals("lpTag.taglets.unAuthMessaging") || connector.getInt(this.AUTH_TYPE_KEY) != connectorType)) {
                    String connectorId = connector.get(this.ID_KEY).toString();
                    LPLog.INSTANCE.i(this.TAG, "Found valid connector id: " + connectorId);
                    PreferenceManager.getInstance().setStringValue("KEY_AUTH_CONNECTOR_ID", this.mBrandId, connectorId);
                    return;
                }
                if (issuerDisplayName != null && configuration.has(this.ISSUER_DISPLAY_NAME_KEY) && StringsKt.equals((String)issuerDisplayName, (String)configuration.getString(this.ISSUER_DISPLAY_NAME_KEY), (boolean)true)) {
                    String connectorId = connector.get(this.ID_KEY).toString();
                    LPLog.INSTANCE.i(this.TAG, "Found valid connector id of " + issuerDisplayName + ": " + connectorId);
                    PreferenceManager.getInstance().setStringValue("KEY_AUTH_CONNECTOR_ID", this.mBrandId, connectorId);
                    return;
                }
            }
            ++i;
        }
        LPLog.INSTANCE.w(this.TAG, "Valid auth connector id not found.");
    }

    private final int getRequiredConnectorType() {
        LPAuthenticationParams lpAuthenticationParams;
        LPAuthenticationParams lPAuthenticationParams = lpAuthenticationParams = this.accountsController.getLPAuthenticationParams(this.mBrandId);
        CharSequence charSequence = lPAuthenticationParams != null ? lPAuthenticationParams.getAuthKey() : null;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return 2;
        }
        LPAuthenticationParams lPAuthenticationParams2 = lpAuthenticationParams;
        charSequence = lPAuthenticationParams2 != null ? lPAuthenticationParams2.getHostAppJWT() : null;
        bl = false;
        bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return 1;
        }
        return -1;
    }

    private final String getIssuerName() {
        Object object;
        block4: {
            boolean bl;
            boolean bl2;
            ACCDNConnectorsTask aCCDNConnectorsTask;
            block3: {
                object = this.accountsController.getLPAuthenticationParams(this.mBrandId);
                if (object == null || (object = object.getIssuerDisplayName()) == null) break block3;
                aCCDNConnectorsTask = object;
                bl2 = false;
                bl = false;
                ACCDNConnectorsTask it = aCCDNConnectorsTask;
                boolean bl3 = false;
                CharSequence charSequence = (CharSequence)((Object)it);
                boolean bl4 = false;
                object = !StringsKt.isBlank((CharSequence)charSequence) ? aCCDNConnectorsTask : null;
                if (object == null) break block3;
                aCCDNConnectorsTask = object;
                bl2 = false;
                bl = false;
                ACCDNConnectorsTask $this$apply = aCCDNConnectorsTask;
                boolean bl5 = false;
                object = aCCDNConnectorsTask;
                if (object != null) break block4;
            }
            aCCDNConnectorsTask = this;
            bl2 = false;
            bl = false;
            ACCDNConnectorsTask $this$run = aCCDNConnectorsTask;
            boolean bl6 = false;
            object = null;
        }
        return object;
    }

    @NotNull
    public final AccountsController getAccountsController() {
        return this.accountsController;
    }

    public ACCDNConnectorsTask(@NotNull AccountsController accountsController) {
        Intrinsics.checkParameterIsNotNull((Object)accountsController, (String)"accountsController");
        this.accountsController = accountsController;
        this.TAG = "ACCDNConnectorsTask";
        this.CONFIGURATION_KEY = "configuration";
        this.ID_KEY = "id";
        this.JS_METHOD_NAME_KEY = "jsMethodName";
        this.JS_METHOD_CONTEXT_KEY = "jsContext";
        this.AUTH_TYPE_KEY = "type";
        this.ISSUER_DISPLAY_NAME_KEY = "issuerDisplayName";
        this.performStepUp = false;
    }

    public static final /* synthetic */ String access$getTAG$p(ACCDNConnectorsTask $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$extractConnectorId(ACCDNConnectorsTask $this, JSONArray data) {
        $this.extractConnectorId(data);
    }

    public static final /* synthetic */ void access$onTaskError(ACCDNConnectorsTask $this, Exception exception) {
        $this.onTaskError(exception);
    }
}

