package com.liveperson.api.request

import com.liveperson.api.response.AbstractResponse
import org.json.JSONObject

/**
 * Created by shiranr on 1/30/18.
 */
class SubscribeMessagingEvents(val conversationId : String, val dialogId: String, private val fromSeq : Int? = 0) : AbstractRequest() {

    private val requestType = "ms.SubscribeMessagingEvents"

    override fun getMessageType(): String = requestType

    override fun toJson(json: JSONObject?) {

        body?.put("dialogId", dialogId)
        body?.put("conversationId", conversationId)
        fromSeq?.let{ body?.put("fromSeq", fromSeq)}
        json?.put(JSON_KEY_BODY, body)
    }


    class Response (var obj : JSONObject) : AbstractResponse<Unit>(obj){
        override fun getBody() {}
    }
}
