package com.liveperson.messaging.model;

import android.database.Cursor;

import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.database.tables.ConversationsTable;
import com.liveperson.infra.log.LPLog;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by oferd on 8/10/15.
 */
public class Conversation {
    private static final String TAG = "Conversation";

    public static final String TEMP_CONVERSATION_ID = "TEMP_CONVERSATION";

    private String mConversationId;
    private List<String> mDialogIds;
    private String mTargetId;
    private String mBrandId;
    private ConversationState mConversationState;
    private TTRType mConversationTTRType = TTRType.NORMAL;
    private long mRequestId;
    private int mLastServerSequence = -1;
    private long mStartTimestamp;
    private long mEndTimestamp = -1;
    private int mUnreadMessages;
    private CSAT.CSAT_SHOW_STATUS mShowedCSAT = CSAT.CSAT_SHOW_STATUS.NO_VALUE;
    private int mUpdateInProgress = 0;
    private CloseReason mCloseReason = null;
    private TTRManager mTTRManager;

    public Conversation(String targetId, String brandId) {
        mDialogIds = new ArrayList<>();
        mTargetId = targetId;
        mBrandId = brandId;
        mTTRManager = new TTRManager(mTargetId);
    }

    public Conversation(ConversationData data) {
        this(data.targetId, data.brandId);
        mConversationId = data.conversationId;
        for (DialogData dialogId: data.dialogs) {
            mDialogIds.add(dialogId.dialogId);
        }
        mRequestId = data.requestId;
        mConversationState = data.state;
        mConversationTTRType = data.conversationTTRType;
        mStartTimestamp = data.startTs;
        mUnreadMessages = data.unreadMessages;
        mCloseReason = data.closeReason;
        mEndTimestamp = data.endTs;
    }

    public Conversation(Cursor cursor) {
        this(cursor.getString(cursor.getColumnIndex(ConversationsTable.Key.TARGET_ID)), cursor.getString(cursor.getColumnIndex(ConversationsTable.Key.BRAND_ID)));
        mConversationId = cursor.getString(cursor.getColumnIndex(ConversationsTable.Key.CONVERSATION_ID));
        int stateInt = cursor.getInt(cursor.getColumnIndex(ConversationsTable.Key.STATE));
        mConversationState = ConversationState.parse(stateInt);
        mRequestId = cursor.getLong(cursor.getColumnIndex(ConversationsTable.Key.REQUEST_ID));
        int ttrType = cursor.getInt(cursor.getColumnIndex(ConversationsTable.Key.TTR_TYPE));
        if (ttrType != -1){
            mConversationTTRType = TTRType.values()[ttrType];
        }
        int csatShownStatus = cursor.getInt(cursor.getColumnIndex(ConversationsTable.Key.CSAT_STATUS));
        mShowedCSAT = CSAT.CSAT_SHOW_STATUS.parse(csatShownStatus);
        mEndTimestamp = cursor.getLong(cursor.getColumnIndex(ConversationsTable.Key.END_TIMESTAMP));
        int closeReasonInt = cursor.getInt(cursor.getColumnIndex(ConversationsTable.Key.CLOSE_REASON));
        if (closeReasonInt != -1){
            mCloseReason = CloseReason.values()[closeReasonInt];
        }
        mUnreadMessages = cursor.getInt(cursor.getColumnIndex(ConversationsTable.Key.UNREAD_MESSAGES_COUNT));
        mStartTimestamp = cursor.getLong(cursor.getColumnIndex(ConversationsTable.Key.START_TIMESTAMP));
        mUpdateInProgress = cursor.getInt(cursor.getColumnIndex(ConversationsTable.Key.CONCURRENT_REQUESTS_COUNTER));
    }

    public boolean isConversationOpen() {
        return mConversationState == ConversationState.OPEN;
    }

    public String getConversationId() {
        return mConversationId;
    }

    public String getTargetId() {
        return mTargetId;
    }

    public String getBrandId() {
        return mBrandId ;
    }

    public ConversationState getState() {
        return mConversationState;
    }

    public void setState(ConversationState state) {
        mConversationState = state;
    }

    public long getRequestId() {
        return mRequestId;
    }

    public void setRequestId(long requestId) {
        this.mRequestId = requestId;
    }

    public void setConversationId(String conversationId) {
        this.mConversationId = conversationId;
    }

    public int getLastServerSequence() {
        return mLastServerSequence;
    }

    public TTRType getConversationTTRType() {
        return mConversationTTRType;
    }

    public void setConversationTTRType(TTRType conversationTTRType) {
        LPLog.INSTANCE.d(TAG, "Setting conversation ttr type: " + conversationTTRType);
        mConversationTTRType = conversationTTRType;
    }

    public TTRManager getTTRManager() {
        return mTTRManager;
    }

    public CSAT.CSAT_SHOW_STATUS isShowedCSAT() {
        LPLog.INSTANCE.d(TAG, "isShowedCSAT:" + mShowedCSAT);
        return mShowedCSAT;
    }

    public void setShowedCSAT(CSAT.CSAT_SHOW_STATUS showedCSAT) {
        LPLog.INSTANCE.d(TAG, "setShowedCSAT:" + showedCSAT);
        mShowedCSAT = showedCSAT;
    }

    public CloseReason getCloseReason() {
        return mCloseReason;
    }

    public void setCloseReason(CloseReason mCloseReason) {
        this.mCloseReason = mCloseReason;
    }

    public long getEndTimestamp() {
        return mEndTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.mEndTimestamp = endTimestamp;
    }

    public long getStartTimestamp() {
        return mStartTimestamp;
    }

    public int getUnreadMessages() {
        return mUnreadMessages;
    }

    public void setUnreadMessages(int unreadMessages) {
        mUnreadMessages = unreadMessages;
    }

    public void setStartTimestamp(long startTs) {
        mStartTimestamp = startTs;
    }

    public int getUpdateInProgress() {
        return mUpdateInProgress;
    }

    public void setUpdateInProgress(int mUpdateInProgress) {
        this.mUpdateInProgress = mUpdateInProgress;
    }
}
