/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.infra.Command;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.network.socket.requests.DeliveryStatusUpdateRequest;
import java.util.Arrays;
import java.util.List;

public class DeliveryStatusUpdateCommand
implements Command {
    private static final String TAG = "DeliveryStatusUpdateCommand";
    private String mTargetId;
    private String mSocketUrl;
    private List<Integer> mSequenceList;
    private String mDialogId;
    private String mConversationId;
    private DeliveryStatus mStatusToSend;
    private DeliveryStatusUpdateInfo mInfo;

    public DeliveryStatusUpdateCommand(String socketUrl, String targetId, String dialogId, String conversationId, List<Integer> sequenceList) {
        this.mSocketUrl = socketUrl;
        this.mTargetId = targetId;
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.mSequenceList = sequenceList;
    }

    public DeliveryStatusUpdateCommand(String socketUrl, String targetId, String dialogId, String conversationId, int sequence, DeliveryStatus deliveryStatus) {
        this(socketUrl, targetId, dialogId, conversationId, Arrays.asList(sequence));
        this.mStatusToSend = deliveryStatus;
    }

    public DeliveryStatusUpdateCommand(String socketUrl, String targetId, String dialogId, String conversationId, int sequence, DeliveryStatus deliveryStatus, DeliveryStatusUpdateInfo info) {
        this(socketUrl, targetId, dialogId, conversationId, sequence, deliveryStatus);
        this.mInfo = info;
    }

    public void execute() {
        if (MessagingFactory.getInstance().getController().getConversationViewParams().getHistoryConversationsStateToDisplay() == LPConversationsHistoryStateToDisplay.CLOSE) {
            return;
        }
        if (this.mStatusToSend == null) {
            if (this.mTargetId != null && ForegroundService.getInstance().isTargetForeground(this.mTargetId)) {
                this.mStatusToSend = DeliveryStatus.READ;
            } else {
                this.mStatusToSend = DeliveryStatus.ACCEPT;
                return;
            }
        }
        DeliveryStatusUpdateRequest statusUpdateRequest = new DeliveryStatusUpdateRequest(this.mSocketUrl, this.mDialogId, this.mConversationId, this.mStatusToSend, this.mSequenceList);
        statusUpdateRequest.setInfo(this.mInfo);
        LPLog.INSTANCE.d(TAG, String.format("Sending status update request to the agent. Sequence: %s, Status: %s", new Object[]{this.mSequenceList, this.mStatusToSend}));
        SocketManager.getInstance().send((BaseSocketRequest)statusUpdateRequest);
    }
}

