/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.text.TextUtils;
import android.util.Patterns;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.liveperson.api.request.message.BasePublishMessage;
import com.liveperson.api.request.message.FilePublishMessage;
import com.liveperson.api.request.message.FormPublishMessage;
import com.liveperson.api.request.message.FormSubmissionPublishMessage;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.model.Event;
import com.liveperson.api.response.model.Participants;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.LPConversationHistoryMaxDaysDateType;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.controller.DBEncryptionService;
import com.liveperson.infra.controller.DBEncryptionServiceUtilsKt;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.database.transaction_helper.InsertOrUpdateSQLCommand;
import com.liveperson.infra.database.transaction_helper.InsertSQLCommand;
import com.liveperson.infra.database.transaction_helper.SQLiteCommand;
import com.liveperson.infra.database.transaction_helper.UpdateSQLCommand;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.LinkUtils;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.infra.utils.UniqueID;
import com.liveperson.infra.utils.patterns.PatternsCompat;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.commands.DeliveryStatusUpdateCommand;
import com.liveperson.messaging.commands.pusher.ClearUnreadMessagesCountCommand;
import com.liveperson.messaging.commands.pusher.GetUnreadMessagesCountCommand;
import com.liveperson.messaging.commands.pusher.SendReadAcknowledgementCommand;
import com.liveperson.messaging.model.AmsMessagesLoaderProvider;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.DialogUtils;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.Form;
import com.liveperson.messaging.model.FormsManager;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.model.NullMessagesListener;
import com.liveperson.messaging.model.QuickRepliesMessageHolder;
import com.liveperson.messaging.network.MessageTimeoutQueue;
import com.liveperson.messaging.network.http.MessageTimeoutListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class AmsMessages
extends BaseDBRepository
implements ShutDown,
Clearable,
AmsMessagesLoaderProvider {
    public static final int MESSAGES_LIMIT = 25;
    public static final int QUICK_REPLY_MESSAGE_SEQUENCE = -6;
    private static final String TAG = "AmsMessages";
    private static final int MAX_SQL_VARIABLES = 997;
    public static final int PENDING_MSG_SEQUENCE_NUMBER = -1;
    public static final int RESOLVE_MSG_SEQUENCE_NUMBER = -2;
    public static final int MASKED_CC_MSG_SEQUENCE_NUMBER = -3;
    public static final int WELCOME_MSG_SEQUENCE_NUMBER = -4;
    public static final int OUTBOUND_CAMPAIGN_MSG_SEQUENCE_NUMBER = -5;
    public static final int TRANSCENDENT_MESSAGE_SEQUENCE_NUMBER = -7;
    private boolean shouldAddWelcomeMessage = false;
    private Map<String, MessagingUserProfile> mMessagingProfiles = new HashMap<String, MessagingUserProfile>();
    private final Messaging mController;
    public final FormsManager mFormsManager;
    private MessagesListener mMessagesListener = null;
    private MessagesListener mNullMessagesListener = new NullMessagesListener();
    private QuickRepliesMessageHolder mQuickRepliesMessageHolder = null;
    private volatile boolean containsMessagesInDatabse = false;
    private volatile boolean containsPCSMessagesInDatabse = false;
    private AtomicLong lastMessageTimeStamp = new AtomicLong(Long.MAX_VALUE);
    public final MessageTimeoutQueue mMessageTimeoutQueue;

    public AmsMessages(Messaging controller) {
        super("messages");
        this.mController = controller;
        MessageTimeoutListener mMessageTimeoutListener = new MessageTimeoutListener(){

            @Override
            public void onMessageTimeout(String brandId) {
                AmsMessages.this.mController.onMessageTimeout(brandId);
                LPLog.INSTANCE.e(AmsMessages.TAG, ErrorCode.ERR_00000076, "on message timeout received");
            }

            @Override
            public void onPublishMessageTimeout(String brandId, String eventId, String dialogId) {
                AmsMessages.this.getMessageByEventId(eventId).setPostQueryOnBackground(data -> {
                    if (data != null) {
                        LPLog.INSTANCE.i(AmsMessages.TAG, "onPublishMessageTimeout: \ngetMessageByEventId = " + eventId + "\nmessage: = " + data.getMessage() + "\nstate = " + (Object)((Object)data.getMessageState()));
                        if (data.getMessageState() != MessagingChatMessage.MessageState.RECEIVED && data.getMessageState() != MessagingChatMessage.MessageState.READ) {
                            AmsMessages.this.showErrorToast(data);
                            AmsMessages.this.updateMessageState(eventId, MessagingChatMessage.MessageState.ERROR);
                            LPLog.INSTANCE.e(AmsMessages.TAG, ErrorCode.ERR_00000077, "on update message timeout");
                        }
                    } else {
                        AmsMessages.this.updateMessageState(eventId, MessagingChatMessage.MessageState.ERROR);
                        LPLog.INSTANCE.e(AmsMessages.TAG, ErrorCode.ERR_00000077, "on update message timeout");
                    }
                }).execute();
            }
        };
        this.mMessageTimeoutQueue = new MessageTimeoutQueue(mMessageTimeoutListener);
        this.mFormsManager = new FormsManager();
    }

    public DataBaseCommand<Void> updateOnCommand() {
        return new DataBaseCommand(() -> null);
    }

    private Cursor messagesByTarget(String brandID, int limitSize, long olderThanTimestamp, long newerThanTimestamp) {
        StringBuilder sql = this.getMessagesForTargetQuery().append(" WHERE ").append("dialogs").append(".").append("brand_id").append(" = \"").append(brandID).append("\"");
        if (olderThanTimestamp > -1L) {
            sql.append(" AND ").append("timeStamp").append(" <= ").append(olderThanTimestamp);
        }
        if (newerThanTimestamp > -1L) {
            sql.append(" AND ").append("timeStamp").append(" >= ").append(newerThanTimestamp);
        }
        ConversationViewParams conversationViewParams = this.mController.getConversationViewParams();
        long historyConversationsMaxDays = (long)conversationViewParams.getHistoryConversationsMaxDays() * 86400000L;
        LPConversationsHistoryStateToDisplay historyConversationState = conversationViewParams.getHistoryConversationsStateToDisplay();
        LPConversationHistoryMaxDaysDateType maxDaysDateType = conversationViewParams.getHistoryConversationMaxDaysType();
        LPLog.INSTANCE.i(TAG, "History control API params: \n ConversationsHistoryStateToDisplay: " + historyConversationState.toString() + "\n ConversationHistoryMaxDaysDateType: " + maxDaysDateType.toString() + "\n HistoryConversationsMaxDays: " + conversationViewParams.getHistoryConversationsMaxDays());
        long daysAgo = System.currentTimeMillis() - historyConversationsMaxDays;
        switch (historyConversationState) {
            case ALL: {
                if (historyConversationsMaxDays <= -1L) break;
                sql.append(" AND ").append("(").append("(").append("dialogs").append(".").append("state").append(" = ").append(ConversationState.OPEN.ordinal()).append(" OR ").append("dialogs").append(".").append("state").append(" = ").append(ConversationState.LOCKED.ordinal()).append(")");
                if (historyConversationsMaxDays > 0L) {
                    sql.append(" OR ").append("(").append("dialogs").append(".").append("state").append(" = ").append(ConversationState.CLOSE.ordinal());
                    this.setMaxDaysDateTypeToQuery(maxDaysDateType, sql, daysAgo);
                    sql.append(")");
                }
                sql.append(")");
                break;
            }
            case OPEN: {
                sql.append(" AND ").append("(").append("dialogs").append(".").append("state").append(" = ").append(ConversationState.OPEN.ordinal()).append(" OR ").append("dialogs").append(".").append("state").append(" = ").append(ConversationState.LOCKED.ordinal()).append(")");
                break;
            }
            case CLOSE: {
                if (historyConversationsMaxDays == 0L) {
                    return null;
                }
                if (historyConversationsMaxDays > 0L) {
                    this.setMaxDaysDateTypeToQuery(maxDaysDateType, sql, daysAgo);
                }
                sql.append(" AND ").append("dialogs").append(".").append("state").append(" = ").append(ConversationState.CLOSE.ordinal());
            }
        }
        if (limitSize > 0) {
            sql.append(" ORDER BY ").append("timeStamp").append(" DESC ");
            sql.append(" LIMIT ").append(limitSize);
            sql = new StringBuilder("Select * FROM ( ").append((CharSequence)sql).append(" ) ORDER BY ").append("timeStamp").append(" ASC ");
        } else {
            sql.append(" ORDER BY ").append("timeStamp").append(" ASC ");
        }
        return this.getDB().rawQuery(sql.toString(), new Object[0]);
    }

    private void setMaxDaysDateTypeToQuery(LPConversationHistoryMaxDaysDateType maxDaysDateType, StringBuilder query, long daysAgo) {
        switch (maxDaysDateType) {
            case endConversationDate: {
                query.append(" AND ").append("dialogs").append(".").append("end_timestamp").append(" >= ").append(daysAgo);
                break;
            }
            case startConversationDate: {
                query.append(" AND ").append("dialogs").append(".").append("start_timestamp").append(" >= ").append(daysAgo);
            }
        }
    }

    private Cursor messagesByConversationID(String conversationID, int limitSize) {
        StringBuilder sql = this.getBasicMessagesQuery().append(" WHERE ").append("dialogs").append(".").append("dialog_id").append(" = \"").append(conversationID).append("\"").append(" ORDER BY ").append("timeStamp");
        if (limitSize != -1) {
            sql.append(" LIMIT ").append(limitSize);
        }
        return this.getDB().rawQuery(sql.toString(), new Object[0]);
    }

    private Cursor messagesByDialogID(String dialogID, int limitSize) {
        StringBuilder sql = this.getBasicMessagesQuery().append(" WHERE ").append("messages").append(".").append("dialogId").append(" = \"").append(dialogID).append("\"").append(" ORDER BY ").append("timeStamp");
        if (limitSize != -1) {
            sql.append(" LIMIT ").append(limitSize);
        }
        return this.getDB().rawQuery(sql.toString(), new Object[0]);
    }

    private StringBuilder getMessagesForTargetQuery() {
        return new StringBuilder().append("select ").append("messages").append(".").append("_id").append(",").append("messages").append(".").append("eventId").append(",").append("messages").append(".").append("originatorId").append(",").append("messages").append(".").append("encryptVer").append(" AS ").append("message_encryptVer").append(",").append("users").append(".").append("encryptVer").append(" AS ").append("user_encryptVer").append(",").append("serverSequence").append(",").append("dialogId").append(",").append("text").append(",").append("contentType").append(",").append("type").append(",").append("status").append(",").append("timeStamp").append(",").append("profileImage").append(",").append("nickname").append(",").append("files").append(".").append("_id").append(" AS ").append("file_row_id").append(",").append("fileType").append(",").append("localUrl").append(",").append("preview").append(",").append("loadStatus").append(",").append("relatedMessageRowID").append(",").append("swiftPath").append(" from ").append("messages").append(" left join ").append("dialogs").append(" on ").append("messages").append(".").append("dialogId").append("=").append("dialogs").append(".").append("dialog_id").append(" left join ").append("users").append(" on ").append("messages").append(".").append("originatorId").append("=").append("users").append(".").append("originatorId").append(" left join ").append("files").append(" on ").append("messages").append(".").append("_id").append("=").append("files").append(".").append("relatedMessageRowID");
    }

    @NonNull
    private StringBuilder getBasicMessagesQuery() {
        return new StringBuilder().append("select ").append("messages").append("._id, serverSequence,text,contentType,dialogId,type,status,").append("messages").append(".eventId,").append("messages").append(".").append("encryptVer").append(" AS ").append("message_encryptVer").append(",").append("users").append(".").append("encryptVer").append(" AS ").append("user_encryptVer").append(",").append("nickname").append(",").append("messages").append(".originatorId,timeStamp,messages.encryptVer,").append("description,firstName,lastName,phoneNumber,userType,email,profileImage,coverImage from ").append("messages").append(" left join ").append("dialogs").append(" on ").append("messages").append(".").append("dialogId").append("=").append("dialogs").append(".").append("dialog_id").append(" left join ").append("users").append(" on ").append("messages").append(".").append("originatorId").append("=").append("users").append(".").append("originatorId");
    }

    public DataBaseCommand<Long> addMessage(MessagingChatMessage message, boolean updateUI) {
        return new DataBaseCommand(() -> {
            long rowId;
            boolean isEmptyEventId = TextUtils.isEmpty((CharSequence)message.getEventId());
            if (isEmptyEventId) {
                LPLog.INSTANCE.i(TAG, "Received new message without event id, generating new one.. ");
                message.setEventId(UniqueID.createUniqueMessageEventId());
                String whereClause = "dialogId = ? AND serverSequence = ?";
                ContentValues updateValues = DBEncryptionServiceUtilsKt.encrypt((ContentValues)this.getContentValuesForMessageUpdate(message));
                ContentValues insertValues = this.wrapValuesForInsertion(updateValues, message);
                rowId = this.getDB().insertOrUpdate(insertValues, updateValues, whereClause, new String[]{message.getDialogId(), String.valueOf(message.getServerSequence())});
                LPLog.INSTANCE.d(TAG, "Insert or Update message: " + LPLog.INSTANCE.mask((Object)message) + " rowId = " + rowId);
            } else {
                try (Cursor cursor = this.getDB().query(null, "eventId = ?", new String[]{message.getEventId()}, null, null, null);){
                    if (cursor != null && cursor.getCount() > 0) {
                        ContentValues messageValues = this.getContentValuesForMessageUpdate(message, cursor);
                        if (messageValues.size() > 0) {
                            rowId = this.getDB().update(messageValues, "eventId=?", new String[]{String.valueOf(message.getEventId())});
                            LPLog.INSTANCE.d(TAG, "Adding message: This message was update with message: " + LPLog.INSTANCE.mask((Object)message) + " rowId = " + rowId);
                        } else {
                            rowId = -1L;
                            LPLog.INSTANCE.d(TAG, "Adding message: Skip add\\update this message since its already exist" + LPLog.INSTANCE.mask((Object)message) + " rowId = " + rowId);
                        }
                    } else {
                        ContentValues insertValues = this.getContentValuesForMessage(message);
                        ContentValues encrypted = DBEncryptionServiceUtilsKt.encrypt((ContentValues)insertValues);
                        rowId = this.getDB().insertWithOnConflict(encrypted);
                        LPLog.INSTANCE.d(TAG, "Adding message: " + LPLog.INSTANCE.mask((Object)message) + " rowId = " + rowId);
                    }
                }
                catch (Exception exception) {
                    rowId = -1L;
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000088, "addMessage", (Throwable)exception);
                }
            }
            if (updateUI) {
                if (rowId != -1L) {
                    this.getMessagesListener().onNewMessage(this.createFullMessageRow(rowId, message, -1L));
                } else {
                    String eventIdToUpdate = message.getEventId();
                    if (isEmptyEventId) {
                        LPLog.INSTANCE.d(TAG, "Updating message that originally didn't have event id. ");
                        eventIdToUpdate = this.getEventIdForMessage(message.getDialogId(), message.getServerSequence());
                    }
                    if (!TextUtils.isEmpty((CharSequence)eventIdToUpdate)) {
                        this.updateMessageByEventId(eventIdToUpdate);
                    }
                }
            }
            return rowId;
        });
    }

    public DataBaseCommand<Void> addMultipleMessages(final ArrayList<ContentEventNotification> responseMessages, final Dialog dialog, final String originatorId, final String brandId, final String targetId, final String dialogId, final String conversationId, final long clockDiff, final boolean firstNotification, final boolean mShouldUpdateUI) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public String[] extractLinks(String text) {
                ArrayList<String> links = new ArrayList<String>();
                String[] l = text.split("\\s+");
                for (int i = 0; i < l.length; ++i) {
                    String possibleLink = l[i];
                    boolean isLink = PatternsCompat.AUTOLINK_WEB_URL.matcher(possibleLink).matches();
                    if (!(isLink |= Patterns.EMAIL_ADDRESS.matcher(possibleLink).matches())) continue;
                    links.add(possibleLink);
                }
                return links.toArray(new String[links.size()]);
            }

            private MessagingChatMessage.MessageType checkIfMessageContainsURLandChangeType(MessagingChatMessage.MessageType type, String msg) {
                if (LinkUtils.containsMarkdownHyperlink((String)msg) && type == MessagingChatMessage.MessageType.AGENT) {
                    return MessagingChatMessage.MessageType.AGENT_MARKDOWN_HYPERLINK;
                }
                String[] urls = this.extractLinks(msg);
                if (urls.length > 0) {
                    if (type == MessagingChatMessage.MessageType.CONSUMER) {
                        return MessagingChatMessage.MessageType.CONSUMER_URL;
                    }
                    if (type == MessagingChatMessage.MessageType.CONSUMER_MASKED) {
                        return MessagingChatMessage.MessageType.CONSUMER_URL_MASKED;
                    }
                    if (type == MessagingChatMessage.MessageType.AGENT) {
                        return MessagingChatMessage.MessageType.AGENT_URL;
                    }
                }
                return type;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void query() {
                if (responseMessages != null) {
                    LPLog.INSTANCE.d(AmsMessages.TAG, "Start addMultipleMessages. num of commands = " + responseMessages.size());
                    ArrayList<FullMessageRow> messageRows = new ArrayList<FullMessageRow>();
                    ArrayList messagesStatus = new ArrayList();
                    ArrayList<SQLiteCommand> commands = new ArrayList<SQLiteCommand>(responseMessages.size());
                    int firstSequence = -1;
                    int lastSequence = -1;
                    int maxAcceptStatusSequence = -1;
                    int maxReadStatusSequence = -1;
                    int lastAgentMessageSequence = -1;
                    for (ContentEventNotification notification : responseMessages) {
                        if (notification.event == null) {
                            LPLog.INSTANCE.e(AmsMessages.TAG, ErrorCode.ERR_00000078, "received message with empty event! continuing to next message.. ");
                            continue;
                        }
                        switch (notification.event.type) {
                            case ContentEvent: {
                                MessagingChatMessage.MessageState messageState;
                                MessagingChatMessage.MessageType messageType;
                                BasePublishMessage publishMessage = null;
                                if (notification.event.message != null) {
                                    publishMessage = notification.event.message;
                                }
                                if (publishMessage == null || publishMessage.getType() == BasePublishMessage.PublishMessageType.TEXT && TextUtils.isEmpty((CharSequence)publishMessage.getMessageText())) {
                                    LPLog.INSTANCE.e(AmsMessages.TAG, ErrorCode.ERR_00000079, "Text message received in query messages is empty :| shouldn't happen! dialogId = " + dialogId + " , sequence = " + notification.sequence);
                                    break;
                                }
                                ContentType contentType = ContentType.fromString(notification.event.contentType);
                                if (TextUtils.equals((CharSequence)originatorId, (CharSequence)notification.originatorId) || notification.originatorMetadata != null && notification.originatorMetadata.mRole == Participants.ParticipantRole.CONSUMER) {
                                    messageType = MessagingChatMessage.MessageType.getMessageContentTypeForConsumer(notification, contentType);
                                    messageState = MessagingChatMessage.MessageState.SENT;
                                } else {
                                    if (notification.originatorMetadata != null && notification.originatorMetadata.mRole == Participants.ParticipantRole.CONTROLLER) {
                                        messageType = MessagingChatMessage.MessageType.CONTROLLER_SYSTEM;
                                    } else {
                                        messageType = MessagingChatMessage.MessageType.getMessageContentTypeForAgent(notification, contentType);
                                        ((AmsMessages)AmsMessages.this).mController.amsConversations.resetEffectiveTTR(targetId);
                                        ((AmsMessages)AmsMessages.this).mController.amsDialogs.resetEffectiveTTR(targetId);
                                        lastAgentMessageSequence = notification.sequence;
                                    }
                                    messageState = MessagingChatMessage.MessageState.RECEIVED;
                                }
                                MessagingChatMessage messagingChatMessage = this.createMessageInDB(commands, messageRows, messageState, messageType, notification, publishMessage, contentType);
                                AmsMessages.this.getQuickRepliesFromEvent(brandId, notification, messagingChatMessage.getMessageType(), dialogId);
                                if (firstSequence == -1) {
                                    firstSequence = notification.sequence;
                                }
                                lastSequence = notification.sequence;
                                break;
                            }
                            case RichContentEvent: {
                                MessagingChatMessage.MessageState messageState;
                                BasePublishMessage publishMessage = null;
                                if (notification.event.message != null) {
                                    publishMessage = notification.event.message;
                                }
                                if (publishMessage == null || publishMessage.getType() == BasePublishMessage.PublishMessageType.TEXT && TextUtils.isEmpty((CharSequence)publishMessage.getMessageText())) {
                                    LPLog.INSTANCE.e(AmsMessages.TAG, ErrorCode.ERR_0000007A, "Text message received in query messages is empty :| shouldn't happen! dialogId = " + dialogId + " , sequence = " + notification.sequence);
                                    break;
                                }
                                ContentType contentType = ContentType.text_structured_content;
                                MessagingChatMessage.MessageType messageType = MessagingChatMessage.MessageType.AGENT_STRUCTURED_CONTENT;
                                if (TextUtils.equals((CharSequence)originatorId, (CharSequence)notification.originatorId)) {
                                    messageState = MessagingChatMessage.MessageState.SENT;
                                } else {
                                    messageState = MessagingChatMessage.MessageState.RECEIVED;
                                    ((AmsMessages)AmsMessages.this).mController.amsConversations.resetEffectiveTTR(targetId);
                                    ((AmsMessages)AmsMessages.this).mController.amsDialogs.resetEffectiveTTR(targetId);
                                    lastAgentMessageSequence = notification.sequence;
                                }
                                MessagingChatMessage messagingChatMessage = this.createMessageInDB(commands, messageRows, messageState, messageType, notification, publishMessage, contentType);
                                AmsMessages.this.getQuickRepliesFromEvent(brandId, notification, messagingChatMessage.getMessageType(), dialogId);
                                if (firstSequence == -1) {
                                    firstSequence = notification.sequence;
                                }
                                lastSequence = notification.sequence;
                                break;
                            }
                            case AcceptStatusEvent: {
                                MessagingChatMessage.MessageState messageState = AmsMessages.this.getReceivedMessageState(notification.event.status);
                                int[] sequenceList = notification.event.sequenceList;
                                if (messageState == null) {
                                    LPLog.INSTANCE.e(AmsMessages.TAG, ErrorCode.ERR_0000007B, "messageState is null :| shouldn't happen! original status: " + (Object)((Object)notification.event.status) + ", dialogId = " + dialogId + " , sequence = " + Arrays.toString(sequenceList));
                                    break;
                                }
                                if (!TextUtils.equals((CharSequence)originatorId, (CharSequence)notification.originatorId) && sequenceList[0] == lastAgentMessageSequence) {
                                    LPLog.INSTANCE.d(AmsMessages.TAG, "AcceptStatusEvent received from agent for agent message. we ignore this event. lastAgentMsgSequence = " + lastAgentMessageSequence);
                                    break;
                                }
                                if (sequenceList == null || sequenceList.length <= 0) break;
                                int length = sequenceList.length;
                                int minSequence = sequenceList[0];
                                int maxSequence = sequenceList[sequenceList.length - 1];
                                if (minSequence > maxSequence) {
                                    int temporary = minSequence;
                                    minSequence = maxSequence;
                                    maxSequence = temporary;
                                }
                                if (messageState == MessagingChatMessage.MessageState.READ && maxReadStatusSequence < maxSequence) {
                                    maxReadStatusSequence = maxSequence;
                                } else if (messageState == MessagingChatMessage.MessageState.RECEIVED && maxAcceptStatusSequence < maxSequence) {
                                    maxAcceptStatusSequence = maxSequence;
                                } else {
                                    for (int i = 0; i < length; i += 996) {
                                        int[] tempArray;
                                        int size;
                                        int n = size = length - i > 996 ? 996 : length - i;
                                        if (size == length) {
                                            tempArray = sequenceList;
                                        } else {
                                            tempArray = new int[997];
                                            System.arraycopy(sequenceList, i, tempArray, 0, size);
                                        }
                                        ContentValues contentValues = new ContentValues();
                                        StringBuilder whereBuilder = new StringBuilder();
                                        String[] whereArgs = new String[size + 2];
                                        MessagesStatusHolder holder = AmsMessages.this.createStatementForUpdateMessagesState(dialogId, tempArray, messageState, size, contentValues, whereBuilder, whereArgs);
                                        AmsMessages.addMessageStatus(messagesStatus, holder);
                                        commands.add((SQLiteCommand)new UpdateSQLCommand(contentValues, whereBuilder.toString(), whereArgs));
                                    }
                                }
                                if (firstSequence == -1) {
                                    firstSequence = minSequence;
                                }
                                if (lastSequence >= maxSequence) break;
                                lastSequence = maxSequence;
                            }
                        }
                    }
                    LPLog.INSTANCE.d(AmsMessages.TAG, "dialogId = " + dialogId + ", responseMessages.size()  = " + responseMessages.size());
                    if (AmsMessages.this.mQuickRepliesMessageHolder != null && !MessagingFactory.getInstance().getController().isDialogClosed(dialogId)) {
                        LPLog.INSTANCE.d(AmsMessages.TAG, "QuickReplies exist in the received message, write to SharedPrefs");
                        AmsMessages.this.mQuickRepliesMessageHolder.writeToSharedPreferences();
                    }
                    if (maxReadStatusSequence > -1) {
                        LPLog.INSTANCE.d(AmsMessages.TAG, "dialogId = " + dialogId + ", maxReadStatusSequence = " + maxReadStatusSequence);
                        AmsMessages.addMessageStatus(messagesStatus, new MessagesStatusHolder(dialogId, new TreeSet(), MessagingChatMessage.MessageState.READ, true));
                        commands.add((SQLiteCommand)AmsMessages.this.createStatementForUpdateMaxMessagesState(dialogId, MessagingChatMessage.MessageState.READ, maxReadStatusSequence));
                    }
                    if (maxAcceptStatusSequence > -1 && maxAcceptStatusSequence > maxReadStatusSequence) {
                        LPLog.INSTANCE.d(AmsMessages.TAG, "dialogId = " + dialogId + ", maxAcceptStatusSequence = " + maxAcceptStatusSequence);
                        AmsMessages.addMessageStatus(messagesStatus, new MessagesStatusHolder(dialogId, new TreeSet(), MessagingChatMessage.MessageState.RECEIVED, true));
                        commands.add((SQLiteCommand)AmsMessages.this.createStatementForUpdateMaxMessagesState(dialogId, MessagingChatMessage.MessageState.RECEIVED, maxAcceptStatusSequence));
                    }
                    AmsMessages amsMessages = AmsMessages.this;
                    synchronized (amsMessages) {
                        if (!mShouldUpdateUI) {
                            ConversationViewParams conversationViewParams = AmsMessages.this.mController.getConversationViewParams();
                            LPConversationsHistoryStateToDisplay historyConversationState = conversationViewParams.getHistoryConversationsStateToDisplay();
                            if (dialog.isOpen()) {
                                if (historyConversationState != LPConversationsHistoryStateToDisplay.CLOSE) {
                                    Collections.sort(messageRows, FullMessageRow::newerThan);
                                    AmsMessages.applyMessageStatus(messageRows, messagesStatus);
                                    AmsMessages.this.getMessagesListener().onInitialMessagesReceived(messageRows);
                                }
                            } else if (dialog.getDialogType() == DialogType.POST_SURVEY && !AmsMessages.this.containsPCSMessagesInDB() && AmsMessages.this.getOldestMessageFromReceived(messageRows) > AmsMessages.this.getLastMessageTimestampDB()) {
                                if (historyConversationState != LPConversationsHistoryStateToDisplay.OPEN) {
                                    Collections.sort(messageRows, FullMessageRow::newerThan);
                                    AmsMessages.applyMessageStatus(messageRows, messagesStatus);
                                    AmsMessages.this.getMessagesListener().onInitialMessagesReceived(messageRows);
                                    AmsMessages.this.addResolveMessageToClosedConversation(dialog);
                                }
                            } else if (!(AmsMessages.this.containsMessagesInDB() && AmsMessages.this.getOldestMessageFromReceived(messageRows) <= AmsMessages.this.getLastMessageTimestampDB() || historyConversationState == LPConversationsHistoryStateToDisplay.OPEN)) {
                                Collections.sort(messageRows, FullMessageRow::newerThan);
                                AmsMessages.applyMessageStatus(messageRows, messagesStatus);
                                AmsMessages.this.getMessagesListener().onInitialMessagesReceived(messageRows);
                                AmsMessages.this.addResolveMessageToClosedConversation(dialog);
                            }
                        }
                    }
                    this.encryptSqlCommandData(commands);
                    AmsMessages.this.getDB().runTransaction(commands);
                    if (mShouldUpdateUI) {
                        AmsMessages.this.updateMessages(firstNotification, dialogId, firstSequence, lastSequence);
                    }
                    AmsMessages.this.sendReadAckToPusherIfRequired(conversationId, dialogId, brandId);
                    AmsMessages.this.sendReadAckOnMessages(brandId, targetId, originatorId);
                }
                return null;
            }

            @NonNull
            private MessagingChatMessage createMessageInDB(ArrayList<SQLiteCommand> commands, ArrayList<FullMessageRow> messages, MessagingChatMessage.MessageState messageState, MessagingChatMessage.MessageType messageType, ContentEventNotification notification, BasePublishMessage publishMessage, ContentType contentType) {
                MessagingChatMessage message;
                String eventId = notification.eventId;
                if (TextUtils.isEmpty((CharSequence)eventId)) {
                    eventId = UniqueID.createUniqueMessageEventId();
                    LPLog.INSTANCE.d(AmsMessages.TAG, "no event id for message: " + LPLog.INSTANCE.mask((Object)publishMessage.getMessageText()) + " creating event id: " + eventId);
                    StringBuilder whereBuilder = new StringBuilder();
                    whereBuilder.append("dialogId").append(" = ? AND ").append("serverSequence").append(" = ?");
                    message = this.createMessage(publishMessage.getMessageText(), messageState, messageType, notification, eventId, contentType.getText());
                    ContentValues updateValues = AmsMessages.this.getContentValuesForMessageUpdate(message);
                    ContentValues insertValues = AmsMessages.this.wrapValuesForInsertion(updateValues, message);
                    InsertOrUpdateSQLCommand insertOrUpdateSQLCommand = new InsertOrUpdateSQLCommand(insertValues, updateValues, whereBuilder.toString(), new String[]{dialogId, String.valueOf(notification.sequence)});
                    this.AddSqliteCommandListenerForFile(publishMessage, (SQLiteCommand)insertOrUpdateSQLCommand, message.getEventId());
                    this.AddCommandForForm(publishMessage, message, brandId, commands);
                    commands.add((SQLiteCommand)insertOrUpdateSQLCommand);
                } else {
                    message = this.createMessage(publishMessage.getMessageText(), messageState, messageType, notification, eventId, contentType.getText());
                    Cursor cursor = AmsMessages.this.getDB().query(null, "eventId = ?", new String[]{message.getEventId()}, null, null, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        ContentValues messageValues = AmsMessages.this.getContentValuesForMessageUpdate(message, cursor);
                        if (messageValues.size() > 0) {
                            LPLog.INSTANCE.d(AmsMessages.TAG, "Updating message: This message need to be update with message: " + LPLog.INSTANCE.mask((Object)message));
                            UpdateSQLCommand updateSQLCommand = new UpdateSQLCommand(messageValues, "eventId=?", new String[]{String.valueOf(message.getEventId())});
                            this.AddSqliteCommandListenerForFile(publishMessage, (SQLiteCommand)updateSQLCommand, message.getEventId());
                            this.AddCommandForForm(publishMessage, message, brandId, commands);
                            commands.add((SQLiteCommand)updateSQLCommand);
                        } else {
                            LPLog.INSTANCE.d(AmsMessages.TAG, "Updating message: Skip updating this message since its already exist" + LPLog.INSTANCE.mask((Object)message));
                            if (message.getServerSequence() == 0) {
                                AmsMessages.this.updateTempDialogId(dialogId, -5);
                                AmsMessages.this.updateTempDialogId(dialogId, -4);
                            }
                        }
                    } else {
                        InsertSQLCommand insertSQLCommand = new InsertSQLCommand(AmsMessages.this.getContentValuesForMessage(message));
                        this.AddSqliteCommandListenerForFile(publishMessage, (SQLiteCommand)insertSQLCommand, message.getEventId());
                        this.AddCommandForForm(publishMessage, message, targetId, commands);
                        commands.add((SQLiteCommand)insertSQLCommand);
                    }
                }
                MessagingUserProfile profile = AmsMessages.this.getUserProfile(message.getOriginatorId());
                String profileAvatar = profile != null ? profile.getAvatarUrl() : null;
                messages.add(new FullMessageRow(message, profileAvatar, null));
                return message;
            }

            @NonNull
            private MessagingChatMessage createMessage(String textMessage, MessagingChatMessage.MessageState messageState, MessagingChatMessage.MessageType messageType, ContentEventNotification notification, String eventId, String contentType) {
                MaskedMessage maskedMessage = AmsMessages.this.mController.getMaskedMessage(brandId, textMessage);
                MessagingChatMessage message = new MessagingChatMessage(notification.originatorId, maskedMessage.getDbMessage(), notification.serverTimestamp + clockDiff, dialogId, eventId, this.updateMessageTypeIfNeeded(messageType, maskedMessage), messageState, notification.sequence, contentType, EncryptionVersion.NONE);
                LPLog.INSTANCE.d(AmsMessages.TAG, "creating message '" + LPLog.INSTANCE.mask((Object)textMessage) + "', seq: " + notification.sequence + ", at time: " + notification.serverTimestamp + ", dialogId: " + dialogId + ", clock diff: " + clockDiff + " = " + (notification.serverTimestamp + clockDiff));
                return message;
            }

            private void AddCommandForForm(BasePublishMessage publishMessage, MessagingChatMessage msg, String brandId2, ArrayList<SQLiteCommand> commands) {
                Form form;
                BasePublishMessage formPublishMessage;
                if (publishMessage.getType() == BasePublishMessage.PublishMessageType.FORM_INVITATION) {
                    formPublishMessage = (FormPublishMessage)publishMessage;
                    LPLog.INSTANCE.d(AmsMessages.TAG, "onResult: new form obj to DB getMessage " + LPLog.INSTANCE.mask((Object)((FormPublishMessage)formPublishMessage).getMessage()));
                    ((AmsMessages)AmsMessages.this).mController.amsMessages.mFormsManager.addForm(((FormPublishMessage)formPublishMessage).getInvitationId(), new Form(msg.getDialogId(), conversationId, ((FormPublishMessage)formPublishMessage).getInvitationId(), ((FormPublishMessage)formPublishMessage).getFormId(), ((FormPublishMessage)formPublishMessage).getFormTitle(), ((AmsMessages)AmsMessages.this).mController.mAccountsController.getTokenizerUrl(brandId2), brandId2, msg.getServerSequence(), msg.getEventId()));
                }
                if (publishMessage.getType() == BasePublishMessage.PublishMessageType.FORM_SUBMISSION && (form = ((AmsMessages)AmsMessages.this).mController.amsMessages.mFormsManager.getForm(((FormSubmissionPublishMessage)(formPublishMessage = (FormSubmissionPublishMessage)publishMessage)).getInvitationId())) != null) {
                    ((AmsMessages)AmsMessages.this).mController.amsMessages.mFormsManager.updateForm(((FormSubmissionPublishMessage)formPublishMessage).getInvitationId(), ((FormSubmissionPublishMessage)formPublishMessage).getSubmissionId());
                    LPLog.INSTANCE.d(AmsMessages.TAG, "Updating message: This message need to be update with message: ");
                    ContentValues cv = new ContentValues();
                    cv.put("status", Integer.valueOf(AmsMessages.this.getReceivedMessageState(DeliveryStatus.SUBMITTED).ordinal()));
                    UpdateSQLCommand updateSQLCommand = new UpdateSQLCommand(cv, "eventId=?", new String[]{String.valueOf(form.getEventId())});
                    commands.add((SQLiteCommand)updateSQLCommand);
                }
            }

            private MessagingChatMessage.MessageType updateMessageTypeIfNeeded(MessagingChatMessage.MessageType messageType, MaskedMessage maskedMessage) {
                if (messageType == MessagingChatMessage.MessageType.CONSUMER && maskedMessage.isMasked()) {
                    messageType = MessagingChatMessage.MessageType.CONSUMER_MASKED;
                }
                if (messageType == MessagingChatMessage.MessageType.CONSUMER || messageType == MessagingChatMessage.MessageType.CONSUMER_MASKED || messageType == MessagingChatMessage.MessageType.AGENT) {
                    messageType = this.checkIfMessageContainsURLandChangeType(messageType, maskedMessage.getDbMessage());
                }
                return messageType;
            }

            private void AddSqliteCommandListenerForFile(BasePublishMessage publishMessage, SQLiteCommand sqLiteCommand, String eventId) {
                if (publishMessage.getType() == BasePublishMessage.PublishMessageType.FILE) {
                    BasePublishMessage finalPublishMessage = publishMessage;
                    sqLiteCommand.setListener(rowId -> {
                        String event = sqLiteCommand.getContentValues().getAsString("eventId");
                        String message = sqLiteCommand.getContentValues().getAsString("text");
                        int version = sqLiteCommand.getContentValues().getAsInteger("encryptVer");
                        String decrypted = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.fromInt((int)version), (String)message);
                        String tag = "onInsertComplete";
                        if (rowId == -1L) {
                            LPLog.INSTANCE.d(AmsMessages.TAG, tag + ": message was updated on DB (and not inserted). No need to add the file to DB");
                        } else {
                            AmsMessages.this.addFileFromPublishMessageToDB(rowId, eventId, tag, (FilePublishMessage)finalPublishMessage, targetId);
                        }
                    });
                }
            }

            private void encryptSqlCommandData(List<SQLiteCommand> commands) {
                for (SQLiteCommand command : commands) {
                    DBEncryptionServiceUtilsKt.encryptTransactionData((SQLiteCommand)command);
                }
            }
        });
    }

    public DataBaseCommand<Void> updateMultipleMessages(ArrayList<ContentEventNotification> responseMessages, String dialogId) {
        return new DataBaseCommand(() -> {
            if (responseMessages != null) {
                LPLog.INSTANCE.d(TAG, "updateMultipleMessages: Start updating messages for dialogId = " + dialogId);
                DataBaseExecutor.execute(() -> {
                    for (ContentEventNotification notification : responseMessages) {
                        if (notification.event == null || notification.event.type == Event.Types.AcceptStatusEvent) {
                            LPLog.INSTANCE.i(TAG, "updateMultipleMessages: Ignore messages with empty or are of type AcceptStatusEvent");
                            continue;
                        }
                        BasePublishMessage publishMessage = null;
                        if (notification.event.message != null) {
                            publishMessage = notification.event.message;
                        }
                        if (publishMessage == null || publishMessage.getType() == BasePublishMessage.PublishMessageType.TEXT && TextUtils.isEmpty((CharSequence)publishMessage.getMessageText())) {
                            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000007C, "updateMultipleMessages: Text message received in query messages is empty :| shouldn't happen! dialogId = " + dialogId + " , sequence = " + notification.sequence);
                            continue;
                        }
                        String sequence = String.valueOf(notification.sequence);
                        ContentValues contentValues = new ContentValues();
                        EncryptionVersion messageEncryptionVersion = DBEncryptionService.Companion.getAppEncryptionVersion();
                        contentValues.put("encryptVer", Integer.valueOf(messageEncryptionVersion.ordinal()));
                        String encryptedMessage = DBEncryptionHelper.encrypt((EncryptionVersion)messageEncryptionVersion, (String)publishMessage.getMessageText());
                        contentValues.put("text", encryptedMessage);
                        String whereBuilder = "dialogId = ? AND serverSequence = ?";
                        LPLog.INSTANCE.d(TAG, "updateMultipleMessages: Updating message with sequence: " + sequence);
                        this.getDB().update(contentValues, whereBuilder, new String[]{dialogId, sequence});
                    }
                });
            }
            return null;
        });
    }

    @NonNull
    private synchronized Long getLastMessageTimestampDB() {
        Long l;
        block9: {
            long lastSavedMessage = this.lastMessageTimeStamp.get();
            if (lastSavedMessage != Long.MAX_VALUE) {
                return lastSavedMessage;
            }
            Cursor cursor = this.requestTimeStampFromDB();
            try {
                long timestamp = cursor.moveToFirst() ? cursor.getLong(cursor.getColumnIndex("timeStamp")) : Long.MAX_VALUE;
                this.lastMessageTimeStamp.compareAndSet(Long.MAX_VALUE, timestamp);
                l = timestamp;
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LPLog.INSTANCE.i(TAG, FlowTags.QUICK_REPLIES, "Receive last message produces error", (Throwable)e);
                    return Long.MAX_VALUE;
                }
            }
            cursor.close();
        }
        return l;
    }

    private boolean containsMessagesInDB() {
        if (!this.containsMessagesInDatabse) {
            this.containsMessagesInDatabse = this.closedConversationMessagesExists(DialogType.MAIN);
        }
        return this.containsMessagesInDatabse;
    }

    private boolean containsPCSMessagesInDB() {
        if (!this.containsPCSMessagesInDatabse) {
            this.containsPCSMessagesInDatabse = this.closedConversationMessagesExists(DialogType.POST_SURVEY);
        }
        return this.containsPCSMessagesInDatabse;
    }

    private Long getOldestMessageFromReceived(List<FullMessageRow> messages) {
        long min = Long.MAX_VALUE;
        for (FullMessageRow row : messages) {
            long timestamp = row.getMessagingChatMessage().getTimeStamp();
            min = Math.min(min, timestamp);
        }
        return min;
    }

    private Boolean closedConversationMessagesExists(DialogType dialogType) {
        Boolean bl;
        block8: {
            String query = "SELECT EXISTS(SELECT messages.timeStamp FROM messages INNER JOIN dialogs ON dialogs.dialog_id = messages.dialogId WHERE dialogs.state != " + DialogState.OPEN.ordinal() + " AND " + "dialogs" + "." + "dialog_type" + " = \"" + dialogType.name() + "\" ORDER BY " + "timeStamp" + " DESC LIMIT 1)";
            Cursor cursor = this.getDB().rawQuery(query, new Object[0]);
            try {
                bl = cursor.moveToFirst() && cursor.getInt(0) == 1;
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            cursor.close();
        }
        return bl;
    }

    private void addResolveMessageToClosedConversation(Dialog dialog) {
        Messaging controller = MessagingFactory.getInstance().getController();
        DialogUtils dialogUtils = new DialogUtils(controller);
        if (dialog != null && dialog.getState() == DialogState.CLOSE && this.isConversationClosed(dialog.getConversationId())) {
            dialogUtils.addClosedDialogDivider(dialog.getBrandId(), dialog, dialog.getAssignedAgentId(), dialog.getCloseReason(), true, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConversationClosed(String id) {
        try (Cursor cursor = this.getConversationStateById(id);){
            if (cursor.moveToFirst()) {
                Conversation conversation = new Conversation(cursor);
                boolean bl2 = !conversation.isConversationOpen() && conversation.getCloseReason() != CloseReason.SYSTEM && conversation.getCloseReason() != CloseReason.TIMEOUT;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Cursor requestTimeStampFromDB() {
        return this.getDB().rawQuery("SELECT timeStamp FROM messages ORDER BY timeStamp DESC LIMIT 1", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long requestLastResolvedMessageTimeStampFromDB() {
        String query = "SELECT timeStamp FROM messages WHERE messages.type = " + MessagingChatMessage.MessageType.SYSTEM_RESOLVED.ordinal() + " OR " + "messages" + "." + "type" + " = " + MessagingChatMessage.MessageType.SYSTEM_DIALOG_RESOLVED.ordinal() + " ORDER BY " + "timeStamp" + " DESC LIMIT 1";
        try (Cursor cursor = this.getDB().rawQuery(query, new Object[0]);){
            if (cursor != null && cursor.moveToFirst()) {
                long l2 = cursor.getLong(cursor.getColumnIndex("timeStamp"));
                return l2;
            }
            long l = System.currentTimeMillis();
            return l;
        }
        catch (Exception e) {
            LPLog.INSTANCE.i(TAG, FlowTags.QUICK_REPLIES, "Receive last message produces error", (Throwable)e);
            return System.currentTimeMillis();
        }
    }

    private Cursor getConversationStateById(String id) {
        return this.getDB().rawQuery("SELECT * FROM conversations WHERE conversation_id =? LIMIT 1", new Object[]{id});
    }

    public void onAgentReceived(MessagingUserProfile userProfile) {
        this.getMessagesListener().onAgentReceived(userProfile);
    }

    private synchronized void getQuickRepliesFromEvent(String brandId, ContentEventNotification notification, MessagingChatMessage.MessageType messageType, String dialogId) {
        boolean isDialogClosed = MessagingFactory.getInstance().getController().isDialogClosed(dialogId);
        if (MessagingFactory.getInstance().getController().isDialogClosed(dialogId)) {
            LPLog.INSTANCE.d(TAG, "getQuickRepliesFromEvent: conversation is closed, not adding QuickReplies message");
            return;
        }
        if (messageType == MessagingChatMessage.MessageType.AGENT || messageType == MessagingChatMessage.MessageType.AGENT_STRUCTURED_CONTENT || messageType == MessagingChatMessage.MessageType.AGENT_URL) {
            QuickRepliesMessageHolder currentQuickRepliesMessageHolder = QuickRepliesMessageHolder.fromContentEventNotification(brandId, notification);
            LPLog.INSTANCE.d(TAG, "getQuickRepliesFromEvent: Message is from agent, try to get QuickReplies string from event");
            if (this.mQuickRepliesMessageHolder == null || currentQuickRepliesMessageHolder != null && currentQuickRepliesMessageHolder.newerThan(this.mQuickRepliesMessageHolder)) {
                LPLog.INSTANCE.d(TAG, FlowTags.QUICK_REPLIES, "QuickReplies message is newer than the current one. New one: " + (currentQuickRepliesMessageHolder != null ? currentQuickRepliesMessageHolder.toString() : "null"));
                this.mQuickRepliesMessageHolder = currentQuickRepliesMessageHolder;
            }
        }
    }

    @Override
    public synchronized QuickRepliesMessageHolder getQuickRepliesMessageHolder(String brandId) {
        if (this.mQuickRepliesMessageHolder == null) {
            this.mQuickRepliesMessageHolder = QuickRepliesMessageHolder.loadFromSharedPreferences(brandId);
        }
        return this.mQuickRepliesMessageHolder;
    }

    @Override
    public void resetQuickRepliesMessageHolder() {
        LPLog.INSTANCE.d(TAG, "resetQuickRepliesMessageHolder: resetting QuickRepliesMessageHolder");
        this.mQuickRepliesMessageHolder = null;
    }

    @Override
    public void removeCoBrowseMessage() {
        DataBaseExecutor.execute(() -> {
            LPLog.INSTANCE.d(TAG, "removeCoBrowseMessage: Remove cobrowse messages from database");
            this.getDB().removeAll("type=?", new String[]{String.valueOf(MessagingChatMessage.MessageType.COBROWSE.ordinal())});
        });
    }

    @NonNull
    private ContentValues getContentValuesForMessageUpdate(MessagingChatMessage message, Cursor cursor) {
        MessagingChatMessage existingMessage = AmsMessages.getSingleMessageFromCursor(cursor);
        ContentValues messageValues = new ContentValues();
        if (message.getMessageState().ordinal() != existingMessage.getMessageState().ordinal() && MessagingChatMessage.MessageState.validChange(existingMessage.getMessageState(), message.getMessageState())) {
            messageValues.put("status", Integer.valueOf(message.getMessageState().ordinal()));
        } else {
            LPLog.INSTANCE.d(TAG, "Skip update message state, old val: " + (Object)((Object)message.getMessageState()) + " , new val: " + (Object)((Object)existingMessage.getMessageState()));
        }
        if (message.getServerSequence() != existingMessage.getServerSequence()) {
            messageValues.put("serverSequence", Integer.valueOf(message.getServerSequence()));
        } else {
            LPLog.INSTANCE.d(TAG, "Skip update message server sequence, old val: " + message.getServerSequence() + " , new val: " + existingMessage.getServerSequence());
        }
        return messageValues;
    }

    private void addFileFromPublishMessageToDB(long messageRowId, String eventId, String tag, FilePublishMessage finalPublishMessage, String targetId) {
        LPLog.INSTANCE.d(TAG, tag + ": MessagingChatMessage was added. row id: " + messageRowId + ". Adding fileMessage to db.");
        String previewImagePath = ImageUtils.saveBase64ToDisk((Context)Infra.instance.getApplicationContext(), (String)finalPublishMessage.getPreview(), (String)targetId);
        LPLog.INSTANCE.d(TAG, tag + ": preview image saved to location: " + previewImagePath);
        if (previewImagePath != null) {
            FileMessage fileMessage = new FileMessage(previewImagePath, finalPublishMessage.getFileType(), null, finalPublishMessage.getRelativePath(), messageRowId);
            long fileRowId = (Long)MessagingFactory.getInstance().getController().amsFiles.addFile(messageRowId, fileMessage).executeSynchronously();
            LPLog.INSTANCE.d(TAG, tag + ": fileMessage was added to db. fileRowId = " + fileRowId);
            if (this.mMessagesListener != null) {
                this.mMessagesListener.onUpdateFileMessage(eventId, messageRowId, new FileMessage(fileMessage, fileRowId));
            }
        }
    }

    @NonNull
    private MessagingChatMessage.MessageState getReceivedMessageState(DeliveryStatus status) {
        MessagingChatMessage.MessageState messageState = null;
        switch (status) {
            case ACCEPT: {
                messageState = MessagingChatMessage.MessageState.RECEIVED;
                break;
            }
            case READ: 
            case ACTION: {
                messageState = MessagingChatMessage.MessageState.READ;
                break;
            }
            case VIEWED: {
                messageState = MessagingChatMessage.MessageState.VIEWED;
                break;
            }
            case SUBMITTED: {
                messageState = MessagingChatMessage.MessageState.SUBMITTED;
                break;
            }
            case ERROR: 
            case ABORTED: {
                messageState = MessagingChatMessage.MessageState.ERROR;
            }
        }
        return messageState;
    }

    private MessagesStatusHolder createStatementForUpdateMessagesState(String dialogId, int[] sequenceList, MessagingChatMessage.MessageState messageState, int length, ContentValues contentValues, StringBuilder whereBuilder, String[] whereArgs) {
        contentValues.put("status", Integer.valueOf(messageState.ordinal()));
        whereArgs[0] = String.valueOf(dialogId);
        whereArgs[1] = String.valueOf(messageState.ordinal());
        whereBuilder.append("dialogId").append(" =? AND ").append("status").append(" <?  AND ").append("serverSequence").append(" in (");
        TreeSet<Integer> sequenceSet = new TreeSet<Integer>();
        for (int i = 0; i < length; ++i) {
            whereArgs[i + 2] = String.valueOf(sequenceList[i]);
            whereBuilder.append("?");
            sequenceSet.add(sequenceList[i]);
            if (i == length - 1) continue;
            whereBuilder.append(",");
        }
        whereBuilder.append(")");
        return new MessagesStatusHolder(dialogId, sequenceSet, messageState, false);
    }

    private UpdateSQLCommand createStatementForUpdateMaxMessagesState(String dialogId, MessagingChatMessage.MessageState messageState, int maxSequence) {
        ContentValues contentValues = new ContentValues();
        StringBuilder whereBuilder = new StringBuilder();
        contentValues.put("status", Integer.valueOf(messageState.ordinal()));
        int maximumSequence = maxSequence > 0 ? maxSequence : this.getMaxSequenceOfDialog(dialogId);
        String[] whereArgs = new String[]{String.valueOf(dialogId), String.valueOf(messageState.ordinal()), String.valueOf(maximumSequence), String.valueOf(-1)};
        whereBuilder.append("dialogId").append(" =? AND ").append("status").append(" <? AND ").append("serverSequence").append(" <=? AND ").append("serverSequence").append(" >? ");
        return new UpdateSQLCommand(contentValues, whereBuilder.toString(), whereArgs);
    }

    public void updateAllMessagesStateByDialogId(String dialogId, MessagingChatMessage.MessageState messageState) {
        DataBaseExecutor.execute(() -> {
            ContentValues contentValues = new ContentValues();
            contentValues.put("status", Integer.valueOf(messageState.ordinal()));
            int result = this.getDB().update(contentValues, "dialogId = ? ", new String[]{dialogId});
            LPLog.INSTANCE.d(TAG, String.format(Locale.ENGLISH, "Updated %d messages on DB with state %s", new Object[]{result, messageState}));
            this.updateAllMessagesForDialog(dialogId);
        });
    }

    private void markPendingMessagesAsFailedOnCloseConv(String brandId) {
        DataBaseExecutor.execute(() -> {
            String rowIds = MessagingFactory.getInstance().getController().getInProgressUploadMessageRowIdsString();
            String[] whereArgs = this.getPendingMessagesQueryParams(brandId, rowIds, String.valueOf(ConversationState.CLOSE.ordinal()));
            String where = this.getPendingMessagesQuery(rowIds);
            Cursor cursor = this.getDB().query(null, where, whereArgs, null, null, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() == 0) {
                        return;
                    }
                    if (cursor.moveToFirst()) {
                        do {
                            MessagingChatMessage message = AmsMessages.getSingleMessageFromCursor(cursor);
                            message.setMessageState(MessagingChatMessage.MessageState.ERROR);
                            long rowId = cursor.getLong(cursor.getColumnIndex("_id"));
                            this.updateMessageByRowId(rowId, message);
                        } while (cursor.moveToNext());
                    }
                }
                finally {
                    cursor.close();
                }
                ContentValues contentValues = new ContentValues();
                contentValues.put("status", Integer.valueOf(MessagingChatMessage.MessageState.ERROR.ordinal()));
                int result = this.getDB().update(contentValues, where, whereArgs);
                LPLog.INSTANCE.d(TAG, String.format(Locale.ENGLISH, "Updated %d messages on DB with state %s", new Object[]{result, MessagingChatMessage.MessageState.ERROR}));
            }
        });
    }

    public void resendAllPendingMessages(String brandId) {
        long resendMessageTimeout = Configuration.getInteger((int)R.integer.sendingMessageTimeoutInMinutes);
        this.markPendingMessagesAsFailedOnCloseConv(brandId);
        DataBaseExecutor.execute(() -> {
            String rowIds = MessagingFactory.getInstance().getController().getInProgressUploadMessageRowIdsString();
            String[] whereArgs = this.getPendingMessagesQueryParams(brandId, rowIds, String.valueOf(ConversationState.OPEN.ordinal()));
            String where = this.getPendingMessagesQuery(rowIds);
            Cursor cursor = this.getDB().query(null, where, whereArgs, null, null, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() == 0) {
                        return;
                    }
                    if (cursor.moveToFirst()) {
                        ArrayList<String> eventIdsToErrorUpdate = new ArrayList<String>();
                        do {
                            MessagingChatMessage message = AmsMessages.getSingleMessageFromCursor(cursor);
                            String dialogId = message.getDialogId();
                            if (resendMessageTimeout > 0L && System.currentTimeMillis() < message.getTimeStamp() + TimeUnit.MINUTES.toMillis(resendMessageTimeout)) {
                                FileMessage fileMessage;
                                LPLog.INSTANCE.d(TAG, "Resend message: " + LPLog.INSTANCE.mask((Object)message));
                                long rowId = -1L;
                                if (MessagingChatMessage.MessageType.isImage(message.getMessageType()) && (fileMessage = this.mController.amsFiles.getFileByMessageRowId(message.getLocalId())) != null) {
                                    rowId = fileMessage.getFileRowId();
                                }
                                this.mController.resendMessage(message.getEventId(), dialogId, rowId, message.getMessageType());
                                continue;
                            }
                            LPLog.INSTANCE.d(TAG, "Resend timeout - Set message to FAILED state,  resendMessageTimeout:" + resendMessageTimeout + ", message: " + LPLog.INSTANCE.mask((Object)message));
                            eventIdsToErrorUpdate.add(message.getEventId());
                        } while (cursor.moveToNext());
                        if (!eventIdsToErrorUpdate.isEmpty()) {
                            this.updateMessagesState(eventIdsToErrorUpdate, MessagingChatMessage.MessageState.ERROR);
                        }
                    }
                }
                finally {
                    cursor.close();
                }
            }
        });
    }

    private String getPendingMessagesQuery(String rowIds) {
        StringBuilder whereBuilder = new StringBuilder().append("_id").append(" in (select m.").append("_id").append(" from ").append("messages").append(" m , ").append("dialogs").append(" c ").append("where (m.").append("status").append("=").append(MessagingChatMessage.MessageState.PENDING.ordinal()).append(" or m.").append("status").append("=").append(MessagingChatMessage.MessageState.QUEUED.ordinal()).append(") and c.").append("brand_id").append("=?").append(" and c.").append("state").append("=?").append(" and m.").append("dialogId").append("= c.").append("dialog_id");
        if (!TextUtils.isEmpty((CharSequence)rowIds)) {
            LPLog.INSTANCE.d(TAG, "resendAllPendingMessages: There is upload images in progress, ignore these messages rowId: " + rowIds);
            whereBuilder.append(" and m.").append("_id").append(" not in (?)");
        }
        whereBuilder.append(")");
        String where = whereBuilder.toString();
        LPLog.INSTANCE.d(TAG, "getPendingMessagesQuery: where clause: " + where);
        return where;
    }

    private String[] getPendingMessagesQueryParams(String brandId, String rowIds, String state) {
        if (!TextUtils.isEmpty((CharSequence)rowIds)) {
            return new String[]{brandId, state, rowIds};
        }
        return new String[]{brandId, state};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMaxSequenceOfDialog(String dialogId) {
        String query = "SELECT MAX(serverSequence) FROM messages WHERE dialogId like \"" + dialogId + "\"";
        try (Cursor cursor = this.getDB().rawQuery(query, new Object[0]);){
            if (cursor != null && cursor.moveToFirst()) {
                int n2 = cursor.getInt(0);
                return n2;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void updateMessageState(String eventId, MessagingChatMessage.MessageState messageState) {
        DataBaseExecutor.execute(() -> {
            ContentValues contentValues = new ContentValues();
            contentValues.put("status", Integer.valueOf(messageState.ordinal()));
            int result = this.getDB().update(contentValues, "eventId=?", new String[]{eventId});
            LPLog.INSTANCE.d(TAG, String.format(Locale.ENGLISH, "Updated %d messages on DB with state %s, eventId: %s", new Object[]{result, messageState, eventId}));
            this.updateMessageByEventId(eventId);
        });
    }

    public void updateMessagesState(ArrayList<String> eventIds, MessagingChatMessage.MessageState messageState) {
        DataBaseExecutor.execute(() -> {
            if (eventIds != null && !eventIds.isEmpty()) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("status", Integer.valueOf(messageState.ordinal()));
                StringBuilder inOperator = new StringBuilder(" IN (?");
                for (int i = 1; i < eventIds.size(); ++i) {
                    inOperator.append(",?");
                }
                inOperator.append(")");
                String[] eventIdsArray = new String[eventIds.size()];
                eventIdsArray = eventIds.toArray(eventIdsArray);
                int result = this.getDB().update(contentValues, "eventId" + inOperator.toString(), eventIdsArray);
                LPLog.INSTANCE.d(TAG, String.format(Locale.ENGLISH, "Updated %d messages on DB with state %s, eventId: %s", new Object[]{result, messageState, eventIds}));
                for (String eventId : eventIdsArray) {
                    this.updateMessageByEventId(eventId);
                }
            } else {
                LPLog.INSTANCE.d(TAG, "updateMessagesState - Skip updated messages , eventID is empty. messageState = " + (Object)((Object)messageState));
            }
        });
    }

    public void sendReadAckOnMessages(String brandId, String targetId, String originatorId) {
        DataBaseExecutor.execute(() -> {
            String conversationId;
            String queryString;
            Cursor cursor = null;
            if (!TextUtils.isEmpty((CharSequence)targetId)) {
                LPLog.INSTANCE.d(TAG, "Get all unread messages for target " + targetId);
                queryString = String.format("select m.%s, c.%s, c.%s from %s m, %s c where c.%s>? and c.%s=? and m.%s =? and m.%s=c.%s and m.%s >= '0' and m.%s != ?", "serverSequence", "dialog_id", "conversation_id", "messages", "dialogs", "state", "target_id", "status", "dialogId", "dialog_id", "serverSequence", "originatorId");
                cursor = this.getDB().rawQuery(queryString, new Object[]{ConversationState.LOCKED.ordinal(), targetId, MessagingChatMessage.MessageState.RECEIVED.ordinal(), originatorId});
            } else if (!TextUtils.isEmpty((CharSequence)brandId)) {
                LPLog.INSTANCE.d(TAG, "Get all unread messages for brand " + brandId);
                queryString = String.format("select m.%s, c.%s, c.%s  from %s m, %s c where c.%s=? and c.%s>? and m.%s =? and m.%s=c.%s and m.%s >= '0' and m.%s != ?", "serverSequence", "dialog_id", "conversation_id", "messages", "dialogs", "brand_id", "state", "status", "dialogId", "dialog_id", "serverSequence", "originatorId");
                cursor = this.getDB().rawQuery(queryString, new Object[]{brandId, ConversationState.LOCKED.ordinal(), MessagingChatMessage.MessageState.RECEIVED.ordinal(), originatorId});
            }
            if (cursor != null && !cursor.moveToFirst()) {
                String id = null;
                String queryString2 = null;
                String rawQuery = "select m.%s, c.%s, c.%s  from %s m, %s c where c.%s=? and c.%s=? and m.%s =? and m.%s=c.%s and m.%s >= '0' and m.%s != ?";
                if (!TextUtils.isEmpty((CharSequence)targetId)) {
                    id = targetId;
                    queryString2 = String.format(rawQuery, "serverSequence", "dialog_id", "conversation_id", "messages", "dialogs", "target_id", "state", "status", "dialogId", "dialog_id", "serverSequence", "originatorId");
                } else if (!TextUtils.isEmpty((CharSequence)brandId)) {
                    id = brandId;
                    queryString2 = String.format(rawQuery, "serverSequence", "dialog_id", "conversation_id", "messages", "dialogs", "brand_id", "state", "status", "dialogId", "dialog_id", "serverSequence", "originatorId");
                }
                cursor = this.getDB().rawQuery(queryString2, new Object[]{id, ConversationState.CLOSE.ordinal(), MessagingChatMessage.MessageState.RECEIVED.ordinal(), originatorId});
            }
            HashMap sequenceMap = new HashMap();
            HashMap<String, String> dialogIdsAndConversationIds = new HashMap<String, String>();
            if (cursor == null) return;
            try {
                if (cursor.moveToFirst()) {
                    do {
                        String dialogId = cursor.getString(cursor.getColumnIndex("dialog_id"));
                        conversationId = cursor.getString(cursor.getColumnIndex("conversation_id"));
                        dialogIdsAndConversationIds.put(dialogId, conversationId);
                        ArrayList<Integer> list = (ArrayList<Integer>)sequenceMap.get(dialogId);
                        if (list == null) {
                            list = new ArrayList<Integer>();
                            sequenceMap.put(dialogId, list);
                        }
                        int sequence = cursor.getInt(cursor.getColumnIndex("serverSequence"));
                        list.add(sequence);
                    } while (cursor.moveToNext());
                }
            }
            finally {
                cursor.close();
            }
            for (String dialogId : sequenceMap.keySet()) {
                LPLog.INSTANCE.d(TAG, "Send a read ack to the server for dialog id " + dialogId + " on the following sequences: " + sequenceMap.get(dialogId));
                conversationId = (String)dialogIdsAndConversationIds.get(dialogId);
                new DeliveryStatusUpdateCommand(this.mController.mAccountsController.getConnectionUrl(brandId), !TextUtils.isEmpty((CharSequence)targetId) ? targetId : brandId, dialogId, conversationId, (List)sequenceMap.get(dialogId)).execute();
            }
        });
    }

    private void sendReadAckToPusherIfRequired(final String conversationId, final String dialogId, final String brandId) {
        if (Configuration.getBoolean((int)R.bool.lp_pusher_clear_badge_count)) {
            this.clearPusherUnreadBadgeCount(brandId);
            return;
        }
        try {
            new GetUnreadMessagesCountCommand(this.mController, brandId, null, null, new ICallback<Integer, Exception>(){

                public void onSuccess(Integer count) {
                    if (count > 0) {
                        Map<String, Integer> countMap = GetUnreadMessagesCountCommand.getUnreadCountMapped();
                        if (countMap == null || TextUtils.isEmpty((CharSequence)dialogId)) {
                            return;
                        }
                        Integer idCount = countMap.get(dialogId);
                        if (idCount != null && idCount > 0) {
                            new SendReadAcknowledgementCommand(AmsMessages.this.mController, brandId, dialogId, conversationId, new ICallback<String, Exception>(){

                                public void onSuccess(String value) {
                                    LPLog.INSTANCE.d(AmsMessages.TAG, "sendReadAckToPusherIfRequired: Cleared Pusher unread count for dialogId: " + dialogId);
                                }

                                public void onError(Exception exception) {
                                    LPLog.INSTANCE.e(AmsMessages.TAG, ErrorCode.ERR_00000080, "sendReadAckToPusherIfRequired: Failed to Clear Pusher unread count for dialogId: " + dialogId);
                                }
                            }).execute();
                        }
                    }
                }

                public void onError(Exception exception) {
                    LPLog.INSTANCE.e(AmsMessages.TAG, ErrorCode.ERR_00000081, "sendReadAckToPusherIfRequired: Failed to fetch Unread Count Mapping. ", (Throwable)exception);
                }
            }).fetchUnreadCountMapping();
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000082, "sendReadAckToPusherIfRequired: Failed to send read acknowledgement to pusher. ", (Throwable)error);
        }
    }

    @Override
    public void clearPusherUnreadBadgeCount(String brandId) {
        if (Configuration.getBoolean((int)R.bool.lp_pusher_clear_badge_count)) {
            new ClearUnreadMessagesCountCommand(this.mController, brandId, null).execute();
        }
    }

    public void setDeliveryStatusUpdateCommand(Form form, DeliveryStatus deliveryStatus) {
        if (form == null) {
            LPLog.INSTANCE.w(TAG, "form not found!");
            return;
        }
        new DeliveryStatusUpdateCommand(this.mController.mAccountsController.getConnectionUrl(form.getSiteId()), form.getSiteId(), form.getDialogId(), form.getConversationId(), form.getSeqId(), deliveryStatus).execute();
    }

    private ContentValues getContentValuesForMessage(MessagingChatMessage message) {
        ContentValues messageValues = this.getContentValuesForMessageUpdate(message);
        messageValues.put("eventId", message.getEventId());
        return messageValues;
    }

    private ContentValues wrapValuesForInsertion(ContentValues valuesForUpdated, MessagingChatMessage message) {
        ContentValues values = new ContentValues(valuesForUpdated);
        values.put("eventId", message.getEventId());
        return values;
    }

    private ContentValues getContentValuesForMessageUpdate(MessagingChatMessage message) {
        ContentValues messageValues = new ContentValues();
        messageValues.put("serverSequence", Integer.valueOf(message.getServerSequence()));
        messageValues.put("dialogId", message.getDialogId());
        EncryptionVersion messageEncryptionVersion = DBEncryptionService.getAppEncryptionVersion();
        messageValues.put("encryptVer", Integer.valueOf(messageEncryptionVersion.ordinal()));
        messageValues.put("text", message.getMessage());
        messageValues.put("contentType", message.getContentType());
        messageValues.put("type", Integer.valueOf(message.getMessageType().ordinal()));
        messageValues.put("status", Integer.valueOf(message.getMessageState().ordinal()));
        messageValues.put("timeStamp", Long.valueOf(message.getTimeStamp()));
        messageValues.put("originatorId", message.getOriginatorId());
        messageValues.put("metadata", message.getMetadata());
        return messageValues;
    }

    private static MessagingChatMessage getSingleMessageFromCursor(Cursor cursor) {
        long msgId = cursor.getLong(cursor.getColumnIndex("_id"));
        EncryptionVersion encryptionVersion = EncryptionVersion.fromInt((int)cursor.getInt(cursor.getColumnIndex("encryptVer")));
        MessagingChatMessage message = new MessagingChatMessage(cursor.getString(cursor.getColumnIndex("originatorId")), cursor.getString(cursor.getColumnIndex("text")), cursor.getLong(cursor.getColumnIndex("timeStamp")), cursor.getString(cursor.getColumnIndex("dialogId")), cursor.getString(cursor.getColumnIndex("eventId")), MessagingChatMessage.MessageType.values()[cursor.getInt(cursor.getColumnIndex("type"))], MessagingChatMessage.MessageState.values()[cursor.getInt(cursor.getColumnIndex("status"))], cursor.getInt(cursor.getColumnIndex("serverSequence")), cursor.getString(cursor.getColumnIndex("contentType")), encryptionVersion);
        message.setMessageId(msgId);
        String metadata = DBEncryptionHelper.decrypt((EncryptionVersion)encryptionVersion, (String)cursor.getString(cursor.getColumnIndex("metadata")));
        message.setMetadata(metadata);
        return message;
    }

    private static void applyMessageStatus(List<FullMessageRow> rows, List<MessagesStatusHolder> statuses) {
        for (FullMessageRow row : rows) {
            MessagingChatMessage message = row.getMessagingChatMessage();
            if (!MessagingChatMessage.MessageType.isConsumer(message.getMessageType())) continue;
            for (MessagesStatusHolder status : statuses) {
                if (!Objects.equals(message.getDialogId(), status.getDialogId()) || !status.isApplyForAllDialog() && !status.getSequence().contains(message.getServerSequence())) continue;
                message.setMessageState(status.getState());
            }
        }
    }

    public void updateOnMessageAck(String eventId, long serverSequence) {
        DataBaseExecutor.execute(() -> {
            ContentValues contentValuesSequence = new ContentValues();
            contentValuesSequence.put("serverSequence", Long.valueOf(serverSequence));
            String whereClauseSequence = "eventId=?";
            String[] whereArgsSequence = new String[]{String.valueOf(eventId)};
            int rowsAffected = this.getDB().update(contentValuesSequence, "eventId=?", whereArgsSequence);
            LPLog.INSTANCE.d(TAG, "Update msg server seq query. Rows affected=" + rowsAffected + " Seq=" + serverSequence);
            ContentValues contentValuesStatus = new ContentValues();
            contentValuesStatus.put("status", Integer.valueOf(MessagingChatMessage.MessageState.SENT.ordinal()));
            String whereClauseStatus = "eventId=? AND (status=? OR status=?)";
            String[] whereArgsStatus = new String[]{String.valueOf(eventId), String.valueOf(MessagingChatMessage.MessageState.PENDING.ordinal()), String.valueOf(MessagingChatMessage.MessageState.ERROR.ordinal())};
            rowsAffected = this.getDB().update(contentValuesStatus, "eventId=? AND (status=? OR status=?)", whereArgsStatus);
            LPLog.INSTANCE.d(TAG, "Update msg status to SENT. Rows affected=" + rowsAffected);
            this.updateMessageByEventId(eventId);
        });
    }

    public DataBaseCommand<Void> loadExistingWelcomeMessage(MessagingChatMessage message) {
        return new DataBaseCommand(() -> {
            try (Cursor cursor = this.getDB().query(null, null, null, null, null, null);){
                cursor.moveToLast();
                long rowId = cursor.getInt(cursor.getColumnIndex("_id")) + 1;
                this.mMessagesListener.onNewMessage(this.createFullMessageRow(rowId, message, -1L));
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000083, "Exception loading Welcome Message", (Throwable)e);
            }
            return null;
        });
    }

    public DataBaseCommand<Boolean> hasStoredWelcomeMessage() {
        return new DataBaseCommand(() -> {
            String query = "SELECT" + " " + "EXISTS (" + "SELECT " + "text" + " " + "FROM" + " " + "messages" + " " + "WHERE" + " " + "serverSequence" + " =? " + "AND" + " " + "dialogId" + " =? " + "LIMIT 1" + ")";
            LPLog.INSTANCE.d(TAG, "hasStoredWelcomeMessage: query " + query);
            try (Cursor cursor = this.getDB().rawQuery(query, new Object[]{-4, "KEY_WELCOME_DIALOG_ID"});){
                if (cursor.moveToFirst()) {
                    boolean contains = cursor.getInt(0) == 1;
                    LPLog.INSTANCE.d(TAG, "hasStoredWelcomeMessage: " + contains);
                    Boolean bl2 = contains;
                    return bl2;
                }
                LPLog.INSTANCE.d(TAG, "hasStoredWelcomeMessage: false");
                Boolean bl = false;
                return bl;
            }
            catch (SQLException exception) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000DE, "hasStoredWelcomeMessage: false", (Throwable)exception);
                return false;
            }
        });
    }

    public DataBaseCommand<Boolean> transcendentMessagesExists(String dialogId, long timestamp) {
        return new DataBaseCommand(() -> {
            Cursor cursor = this.getDB().rawQuery("SELECT * FROM messages WHERE serverSequence=? AND timeStamp=? AND dialogId=?", new Object[]{-7, timestamp, dialogId});
            if (cursor != null) {
                try {
                    if (cursor.moveToFirst()) {
                        Boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return false;
        });
    }

    public DataBaseCommand<String> getLatestOutboundMessage() {
        return new DataBaseCommand(() -> {
            Cursor cursor = this.getDB().rawQuery("SELECT text FROM messages WHERE serverSequence =? AND dialogId =?", new Object[]{-5, "KEY_WELCOME_DIALOG_ID"});
            if (cursor != null) {
                try {
                    if (cursor.moveToFirst()) {
                        String string2 = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)cursor.getString(cursor.getColumnIndex("text")));
                        return string2;
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return null;
        });
    }

    public DataBaseCommand<MessagingChatMessage> getLatestWelcomeMessageByServerSequence(int serverSequence) {
        return new DataBaseCommand(() -> {
            Cursor cursor = this.getDB().query(null, "serverSequence =? AND dialogId =?", new String[]{String.valueOf(serverSequence), "KEY_WELCOME_DIALOG_ID"}, null, null, null);
            if (cursor != null) {
                try {
                    if (cursor.moveToFirst()) {
                        MessagingChatMessage messagingChatMessage = AmsMessages.getSingleMessageFromCursor(cursor);
                        return messagingChatMessage;
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return null;
        });
    }

    public DataBaseCommand<Void> updateLastOutboundMessage(MessagingChatMessage message) {
        return new DataBaseCommand(() -> {
            try {
                String whereString = "serverSequence =? AND dialogId =?";
                String[] whereArgs = new String[]{String.valueOf(-5), "KEY_WELCOME_DIALOG_ID"};
                ContentValues values = this.getContentValuesForMessageUpdate(message);
                ContentValues encrypted = DBEncryptionServiceUtilsKt.encrypt((ContentValues)values);
                this.getDB().update(encrypted, whereString, whereArgs);
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000153, "Exception updating last outbound message", (Throwable)e);
            }
            return null;
        });
    }

    public DataBaseCommand<Void> updateLastWelcomeMessage(String brandId, MessagingChatMessage message) {
        return new DataBaseCommand(() -> {
            try {
                String whereString = "serverSequence =? AND dialogId =?";
                String[] whereArgs = new String[]{String.valueOf(-4), "KEY_WELCOME_DIALOG_ID"};
                ContentValues values = this.getContentValuesForMessageUpdate(message);
                ContentValues encrypted = DBEncryptionServiceUtilsKt.encrypt((ContentValues)values);
                Dialog dialog = (Dialog)this.mController.amsDialogs.queryActiveDialog(brandId).executeSynchronously();
                if (dialog != null) {
                    encrypted.remove("timeStamp");
                }
                this.getDB().update(encrypted, whereString, whereArgs);
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000085, "Exception updating last welcome message", (Throwable)e);
            }
            return null;
        });
    }

    public DataBaseCommand<Void> removeLastWelcomeMessage() {
        return new DataBaseCommand(() -> {
            try (Cursor cursor = this.getDB().query(null, null, null, null, null, null);){
                cursor.moveToFirst();
                int firstItemId = cursor.getInt(cursor.getColumnIndex("_id"));
                cursor.moveToLast();
                int lastItemId = cursor.getInt(cursor.getColumnIndex("_id"));
                int lastItemSeqNumber = cursor.getInt(cursor.getColumnIndex("serverSequence"));
                if (firstItemId != lastItemId && lastItemSeqNumber == -4) {
                    String whereString = "_id=?";
                    String[] whereArgs = new String[]{String.valueOf(lastItemId)};
                    this.getDB().removeAll(whereString, whereArgs);
                } else if (firstItemId != lastItemId) {
                    this.removeAllWelcomeMessages().execute();
                }
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000086, "Exception removing last welcome message", (Throwable)e);
            }
            return null;
        });
    }

    public DataBaseCommand<Void> removeAllWelcomeMessages() {
        return new DataBaseCommand(() -> {
            LPLog.INSTANCE.d(TAG, "removeAllWelcomeMessages: removing all welcome messages that has temporary dialogId");
            try {
                this.getDB().removeAll("serverSequence=? AND dialogId=?", new String[]{String.valueOf(-4), "KEY_WELCOME_DIALOG_ID"});
            }
            catch (Exception e) {
                LPLog.INSTANCE.i(TAG, "removeAllWelcomeMessages: Failed to remove welcome messages: " + e);
            }
            return null;
        });
    }

    public DataBaseCommand<Void> removeLastOutboundMessage() {
        return new DataBaseCommand(() -> {
            try (Cursor cursor = this.getDB().query(null, null, null, null, null, null);){
                if (cursor.moveToFirst()) {
                    int firstItemId = cursor.getInt(cursor.getColumnIndex("_id"));
                    cursor.moveToLast();
                    int lastItemId = cursor.getInt(cursor.getColumnIndex("_id"));
                    LPLog.INSTANCE.d(TAG, "removeLastOutboundMessage: removing outbound message");
                    if (firstItemId == lastItemId) {
                        int indexRemoved = this.getDB().removeAll("serverSequence=? AND dialogId=?", new String[]{String.valueOf(-5), "KEY_WELCOME_DIALOG_ID"});
                        if (indexRemoved > 0) {
                            LPLog.INSTANCE.d(TAG, "removeLastOutboundMessage: Set welcome message to be added");
                            this.shouldAddWelcomeMessage = true;
                        }
                    } else {
                        this.getDB().removeAll("serverSequence=? AND dialogId=?", new String[]{String.valueOf(-5), "KEY_WELCOME_DIALOG_ID"});
                    }
                } else {
                    this.mController.amsDialogs.hasWelcomeMessageDialog().setPostQueryOnBackground(hasWelcomeMessageDialog -> {
                        if (hasWelcomeMessageDialog.booleanValue()) {
                            LPLog.INSTANCE.i(TAG, "removeLastOutboundMessage: Found welcome message dialog without welcome message. Add welcome message listener.");
                            this.shouldAddWelcomeMessage = true;
                        }
                    }).execute();
                }
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000154, "Exception while removing last outbound message", (Throwable)e);
            }
            return null;
        });
    }

    private void updateTempDialogId(String dialogId, int tempServerSequence) {
        this.getLatestWelcomeMessageByServerSequence(tempServerSequence).setPostQueryOnBackground(welcomeMessage -> {
            if (welcomeMessage != null) {
                try {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("dialogId", dialogId);
                    String whereClause = "_id=? AND serverSequence=? AND dialogId=?";
                    String[] whereArgsSequence = new String[]{String.valueOf(welcomeMessage.getLocalId()), String.valueOf(tempServerSequence), "KEY_WELCOME_DIALOG_ID"};
                    int updatedRows = this.getDB().update(contentValues, whereClause, whereArgsSequence);
                    LPLog.INSTANCE.d(TAG, "updateTempDialogIds , updatedRows = " + updatedRows);
                    if (updatedRows > 0) {
                        welcomeMessage.setDialogId(dialogId);
                        this.getMessagesListener().onUpdateMessage(this.createFullMessageRow(welcomeMessage.getLocalId(), (MessagingChatMessage)((Object)welcomeMessage), -1L));
                    }
                }
                catch (Exception error) {
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000152, "updateTempDialogId: Failed to update TEP WELCOME_DIALOG_ID with conversation dialogId: " + error);
                }
            }
        }).execute();
    }

    public DataBaseCommand<Void> updateMessagesDialogServerID(String serverDialogId) {
        return new DataBaseCommand(() -> {
            ContentValues contentValues = new ContentValues();
            contentValues.put("dialogId", serverDialogId);
            int updatedRows = this.getDB().update(contentValues, "dialogId=?", new String[]{"TEMP_DIALOG"});
            LPLog.INSTANCE.d(TAG, "updateMessagesConversationServerID , updatedRows = " + updatedRows);
            this.updateAllMessagesForDialog(serverDialogId);
            return null;
        });
    }

    public DataBaseCommand<Void> updateMessageDialogServerIdAndTime(long messageRowId, String dialogId) {
        return new DataBaseCommand(() -> {
            ContentValues contentValues = new ContentValues();
            contentValues.put("dialogId", dialogId);
            int updatedRows = this.getDB().update(contentValues, "_id=? ", new String[]{String.valueOf(messageRowId)});
            LPLog.INSTANCE.d(TAG, "updateMessageDialogServerIdAndTime , rowId to update = " + messageRowId + ", updated = " + updatedRows);
            this.updateMessageByRowIdOnDbThread(messageRowId);
            return null;
        });
    }

    public void updateMessageState(long messageRowId, MessagingChatMessage.MessageState state) {
        DataBaseExecutor.execute(() -> {
            ContentValues contentValues = new ContentValues();
            contentValues.put("status", Integer.valueOf(state.ordinal()));
            int updatedRows = this.getDB().update(contentValues, "_id=? ", new String[]{String.valueOf(messageRowId)});
            LPLog.INSTANCE.d(TAG, "updateMessageState , rowId to update = " + messageRowId + ", updated = " + updatedRows);
            this.updateMessageByRowIdOnDbThread(messageRowId);
        });
    }

    public void updateMessageFileChanged(long messageRowId) {
        if (messageRowId < 0L) {
            LPLog.INSTANCE.w(TAG, "updateMessageFileChanged cannot be lower than zero! " + messageRowId);
            return;
        }
        DataBaseExecutor.execute(() -> this.updateMessageByRowIdOnDbThread(messageRowId));
    }

    private MessagesListener getMessagesListener() {
        if (this.mMessagesListener != null) {
            return this.mMessagesListener;
        }
        return this.mNullMessagesListener;
    }

    @Override
    public void addOnUpdateListener(MessagesListener messagesListener, MessagesSortedBy messagesSortedByType, String typeValue) {
        this.mMessagesListener = messagesListener;
        int limit = messagesListener.getLoadLimit();
        this.executePendingListenerTasks();
        DataBaseExecutor.execute(() -> {
            ArrayList<FullMessageRow> searchedMessageList = this.loadMessagesOnDbThread(messagesSortedByType, typeValue, limit, -1L, -1L);
            this.getMessagesListener().initMessages(searchedMessageList);
        });
    }

    @Override
    public void removeOnUpdateListener() {
        this.mMessagesListener = null;
    }

    @Override
    public boolean hasListener() {
        return this.mMessagesListener != null;
    }

    @Override
    public DataBaseCommand<ArrayList<FullMessageRow>> loadMessages(MessagesSortedBy messagesSortedByType, String typeValue, int limit, long olderThanTimestamp, long newerThanTimestamp) {
        return new DataBaseCommand(() -> this.loadMessagesOnDbThread(messagesSortedByType, typeValue, limit, olderThanTimestamp, newerThanTimestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ArrayList<FullMessageRow> loadMessagesOnDbThread(MessagesSortedBy messagesSortedByType, String typeValue, int limit, long olderThanTimestamp, long newerThanTimestamp) {
        Cursor cursor = null;
        LPLog.INSTANCE.d(TAG, "Loading " + limit + " messages by " + (Object)((Object)messagesSortedByType));
        switch (messagesSortedByType) {
            case TargetId: {
                cursor = this.messagesByTarget(typeValue, limit, olderThanTimestamp, newerThanTimestamp);
                break;
            }
            case ConversationId: {
                cursor = this.messagesByConversationID(typeValue, limit);
                break;
            }
            case DialogId: {
                cursor = this.messagesByDialogID(typeValue, limit);
            }
        }
        ArrayList<FullMessageRow> searchedMessageList = null;
        if (cursor != null) {
            try {
                searchedMessageList = new ArrayList<FullMessageRow>(cursor.getCount());
                if (cursor.moveToFirst()) {
                    do {
                        searchedMessageList.add(new FullMessageRow(cursor));
                    } while (cursor.moveToNext());
                }
            }
            finally {
                cursor.close();
            }
        }
        return searchedMessageList;
    }

    @Override
    public String getMyUserId(String targetId) {
        return this.mController.getOriginatorId(targetId);
    }

    @Override
    public MessagingUserProfile loadMessagingUserProfile(String originatorId) {
        return (MessagingUserProfile)this.mController.amsUsers.getUserById(originatorId).executeSynchronously();
    }

    @NonNull
    private FullMessageRow createFullMessageRow(long messageRowId, @NonNull MessagingChatMessage message, long fileRowId) {
        MessagingUserProfile messagingUserProfile;
        if (messageRowId > 0L) {
            message.setLocalId(messageRowId);
        }
        String avatarUrl = (messagingUserProfile = this.getUserProfile(message.getOriginatorId())) == null ? "" : messagingUserProfile.getAvatarUrl();
        String agentNickname = messagingUserProfile == null ? "" : messagingUserProfile.getNickname();
        FileMessage fileMessage = fileRowId != -1L ? this.mController.amsFiles.getFileByFileRowIdOnDbThread(fileRowId) : this.mController.amsFiles.getFileByMessageRowId(messageRowId);
        FullMessageRow fullMessageRow = new FullMessageRow(message, avatarUrl, fileMessage);
        fullMessageRow.setAgentNickName(agentNickname);
        return fullMessageRow;
    }

    private synchronized MessagingUserProfile getUserProfile(String originatorId) {
        MessagingUserProfile profile = this.mMessagingProfiles.get(originatorId);
        if (profile == null) {
            profile = (MessagingUserProfile)this.mController.amsUsers.getUserById(originatorId).executeSynchronously();
            this.mMessagingProfiles.put(originatorId, profile);
            return profile;
        }
        return profile;
    }

    public DataBaseCommand<Integer> clearMessagesOfClosedConversations(String targetId) {
        return new DataBaseCommand(() -> {
            String whereString = "_id in (select m._id from messages m, dialogs d where d.target_id=? and d.state=? and d.dialog_id=m.dialogId or m.dialogId=?)";
            Object[] whereArgs = new String[]{targetId, String.valueOf(DialogState.CLOSE.ordinal()), "KEY_WELCOME_DIALOG_ID"};
            int removed = this.getDB().removeAll(whereString, (String[])whereArgs);
            LPLog.INSTANCE.d(TAG, "clearMessagesOfClosedConversations: removed: " + removed + " where: " + whereString + ", whereArgs: " + Arrays.toString(whereArgs));
            this.getMessagesListener().removeAllClosedConversations(targetId);
            return removed;
        });
    }

    public DataBaseCommand<Integer> clearAllMessages(String targetId) {
        return new DataBaseCommand(() -> {
            int removed = this.getDB().removeAll(null, null);
            LPLog.INSTANCE.d(TAG, "clearAllMessages from messages table");
            this.getMessagesListener().clearAllMessages(targetId);
            return removed;
        });
    }

    private void updateMessages(boolean firstNotification, String dialogId, int firstSequence, int lastSequence) {
        long firstTimestamp = this.getTimestampMessage(dialogId, firstSequence);
        long lastTimestamp = this.getTimestampMessage(dialogId, lastSequence);
        if (firstNotification) {
            LPLog.INSTANCE.d(TAG, "updateMessages first notification event. onQueryMessagesResult ");
            this.getMessagesListener().onQueryMessagesResult(firstTimestamp, lastTimestamp);
        } else {
            LPLog.INSTANCE.d(TAG, "updateMessages NOT first notification event. onUpdateMessages ");
            this.getMessagesListener().onUpdateMessages(firstTimestamp, lastTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessageByEventId(String eventId) {
        Cursor cursor = this.getDB().query(null, "eventId = ?", new String[]{eventId}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    MessagingChatMessage message = AmsMessages.getSingleMessageFromCursor(cursor);
                    int rowId = cursor.getInt(cursor.getColumnIndex("_id"));
                    this.getMessagesListener().onUpdateMessage(this.createFullMessageRow(rowId, message, -1L));
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEventIdForMessage(String dialogId, int sequence) {
        String eventId = null;
        Cursor cursor = this.getDB().rawQuery("SELECT eventId FROM messages WHERE dialogId =? AND serverSequence =? ", new Object[]{dialogId, sequence});
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    eventId = cursor.getString(cursor.getColumnIndex("eventId"));
                }
            }
            finally {
                cursor.close();
            }
        }
        return eventId;
    }

    public DataBaseCommand<MessagingChatMessage> getMessageByEventId(String eventId) {
        if (TextUtils.isEmpty((CharSequence)eventId)) {
            LPLog.INSTANCE.w(TAG, "getMessageByEventId - eventId is empty");
            return null;
        }
        return new DataBaseCommand(() -> {
            try (Cursor cursor = this.getDB().query(null, "eventId = ?", new String[]{eventId}, null, null, null);){
                if (cursor != null) {
                    MessagingChatMessage messagingChatMessage = AmsMessages.getSingleMessageFromCursor(cursor);
                    return messagingChatMessage;
                }
            }
            return null;
        });
    }

    public DataBaseCommand<Boolean> isResolveMessageForDialogAdded(String dialogId) {
        if (TextUtils.isEmpty((CharSequence)dialogId)) {
            LPLog.INSTANCE.w(TAG, "getResolveMessageForDialog - dialogId is empty");
            return null;
        }
        return new DataBaseCommand(() -> {
            String queryString = "SELECT dialogId FROM messages WHERE dialogId=? AND serverSequence=?";
            try (Cursor cursor = this.getDB().rawQuery(queryString, new Object[]{dialogId, -2});){
                if (cursor == null) return false;
                if (!cursor.moveToFirst()) return false;
                String dbDialogId = cursor.getString(cursor.getColumnIndex("dialogId"));
                Boolean bl = dbDialogId.equals(dialogId);
                return bl;
            }
            catch (Exception e) {
                LPLog.INSTANCE.w(TAG, e.getMessage(), (Throwable)e);
            }
            return false;
        });
    }

    public DataBaseCommand<Long> getRowIdByEventId(String eventId) {
        if (TextUtils.isEmpty((CharSequence)eventId)) {
            LPLog.INSTANCE.w(TAG, "getRowIdByEventId - eventId is empty");
            return null;
        }
        return new DataBaseCommand(() -> {
            try (Cursor cursor = this.getDB().query(new String[]{"_id"}, "eventId = ?", new String[]{eventId}, null, null, null);){
                if (cursor == null) return -1L;
                Long l = cursor.getLong(cursor.getColumnIndex("_id"));
                return l;
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000087, "Exception while getting a rowId by eventId", (Throwable)e);
            }
            return -1L;
        });
    }

    private void updateMessageByRowIdOnDbThread(long messageRowId) {
        MessagingChatMessage message = this.getMessageByRowIdOnDbThread(messageRowId);
        if (message != null) {
            this.getMessagesListener().onUpdateMessage(this.createFullMessageRow(messageRowId, message, -1L));
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000088, "updateMessageByRowIdOnDbThread - message does not exist");
        }
    }

    public DataBaseCommand<Void> updateFileMessageByRowId(long messageRowId, long fileRowId) {
        return new DataBaseCommand(() -> {
            MessagingChatMessage message = this.getMessageByRowIdOnDbThread(messageRowId);
            if (message == null) {
                message = this.getMessagesFileRowId(fileRowId);
            }
            FullMessageRow messageRow = this.createFullMessageRow(messageRowId, message, fileRowId);
            this.getMessagesListener().onUpdateMessage(messageRow);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private MessagingChatMessage getMessageByRowIdOnDbThread(long messageRowId) {
        Cursor cursor = this.getDB().query(null, "_id = ?", new String[]{String.valueOf(messageRowId)}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    MessagingChatMessage messagingChatMessage = AmsMessages.getSingleMessageFromCursor(cursor);
                    return messagingChatMessage;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private MessagingChatMessage getMessagesFileRowId(long fileRowId) {
        String request = this.getBasicMessagesQuery().append(" inner join files on ").append("files.relatedMessageRowID").append(" = ").append("messages._id").append(" where files._id = ?").append(" LIMIT 1").toString();
        try (Cursor cursor = this.getDB().rawQuery(request, new Object[]{fileRowId});){
            if (cursor.moveToFirst()) {
                MessagingChatMessage messagingChatMessage2 = new FullMessageRow(cursor).getMessagingChatMessage();
                return messagingChatMessage2;
            }
            MessagingChatMessage messagingChatMessage = null;
            return messagingChatMessage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void updateMessageByRowId(long rowId, MessagingChatMessage message) {
        this.getMessagesListener().onUpdateMessage(this.createFullMessageRow(rowId, message, -1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllMessagesForDialog(String dialogId) {
        Cursor cursor = this.getDB().query(new String[]{"MIN(timeStamp)", "MAX(timeStamp)"}, "dialogId = ?", new String[]{dialogId}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    long firstMessageTimestampForConversation = cursor.getLong(0);
                    long lastMessageTimestampForConversation = cursor.getLong(1);
                    this.getMessagesListener().onUpdateMessages(firstMessageTimestampForConversation, lastMessageTimestampForConversation);
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    private void showErrorToast(MessagingChatMessage message) {
        int toastTextResId;
        switch (message.getMessageType()) {
            case CONSUMER: 
            case CONSUMER_MASKED: {
                toastTextResId = R.string.lp_failed_to_send_message;
                break;
            }
            case CONSUMER_URL: 
            case CONSUMER_URL_MASKED: {
                toastTextResId = R.string.lp_failed_to_send_link;
                break;
            }
            case CONSUMER_FORM: {
                toastTextResId = R.string.lp_failed_to_send_secure_form_answer;
                break;
            }
            default: {
                toastTextResId = -1;
            }
        }
        MessagesListener listener = this.getMessagesListener();
        if (toastTextResId != -1 && listener != null) {
            listener.showErrorToast(toastTextResId);
        }
    }

    public void updateFetchHistoryEnded(boolean updated) {
        DataBaseExecutor.execute(() -> {
            if (updated) {
                this.getMessagesListener().onHistoryFetched();
            } else {
                this.getMessagesListener().onHistoryFetchedFailed();
            }
        });
    }

    public void updateAgentDetailsUpdated(String dialogId) {
        this.updateAllMessagesForDialog(dialogId);
    }

    public void updateHandledExConversation(boolean emptyNotification) {
        this.getMessagesListener().onExConversationHandled(emptyNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimestampMessage(String dialogId, int sequence) {
        long timestamp = 0L;
        Cursor cursor = this.getDB().rawQuery("SELECT timeStamp FROM messages WHERE dialogId =? AND serverSequence =? ", new Object[]{dialogId, sequence});
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    timestamp = cursor.getLong(cursor.getColumnIndex("timeStamp"));
                }
            }
            finally {
                cursor.close();
            }
        }
        return timestamp;
    }

    public void shutDown() {
        this.mMessageTimeoutQueue.removeAll();
    }

    public void clear() {
    }

    public void removeAllMessages(String brandId) {
        this.getMessagesListener().clearAllMessages(brandId);
    }

    private void executePendingListenerTasks() {
        if (this.shouldAddWelcomeMessage) {
            this.shouldAddWelcomeMessage = false;
            this.getMessagesListener().addFirstWelcomeMessage();
        }
    }

    private static void addMessageStatus(List<MessagesStatusHolder> statuses, MessagesStatusHolder holder) {
        ListIterator<MessagesStatusHolder> iterator = statuses.listIterator();
        if (iterator.hasNext()) {
            boolean shouldAdd = false;
            while (iterator.hasNext()) {
                MessagesStatusHolder existed = (MessagesStatusHolder)iterator.next();
                if (existed.getMaxSequence() > holder.getMaxSequence() || existed.getState().ordinal() > holder.getState().ordinal()) continue;
                iterator.remove();
                shouldAdd = true;
            }
            if (shouldAdd) {
                statuses.add(holder);
            }
        } else {
            statuses.add(holder);
        }
    }

    private static class MessagesStatusHolder {
        private final String mDialogId;
        private final TreeSet<Integer> mSequence;
        private final MessagingChatMessage.MessageState mState;
        private final boolean mApplyForDialog;

        private MessagesStatusHolder(String dialogId, TreeSet<Integer> sequence, MessagingChatMessage.MessageState state, boolean applyForDialog) {
            this.mDialogId = dialogId;
            this.mSequence = sequence;
            this.mState = state;
            this.mApplyForDialog = applyForDialog;
        }

        public String getDialogId() {
            return this.mDialogId;
        }

        public TreeSet<Integer> getSequence() {
            return this.mSequence;
        }

        public MessagingChatMessage.MessageState getState() {
            return this.mState;
        }

        public boolean isApplyForAllDialog() {
            return this.mApplyForDialog;
        }

        public int getMaxSequence() {
            if (this.mSequence.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            return this.mSequence.last();
        }
    }

    public static interface MessagesListener {
        public void initMessages(ArrayList<FullMessageRow> var1);

        public void onQueryMessagesResult(long var1, long var3);

        public void onUpdateMessages(long var1, long var3);

        public void onNewMessage(FullMessageRow var1);

        public void onUpdateMessage(FullMessageRow var1);

        public void onUpdateFileMessage(String var1, long var2, FileMessage var4);

        public void onInitialMessagesReceived(List<FullMessageRow> var1);

        public void removeAllClosedConversations(String var1);

        public void clearAllMessages(String var1);

        public void onHistoryFetched();

        public void onExConversationHandled(boolean var1);

        public void onHistoryFetchedFailed();

        public void addFirstWelcomeMessage();

        public void onAgentReceived(MessagingUserProfile var1);

        public void showErrorToast(@StringRes int var1);

        public int getLoadLimit();
    }

    public static enum MessagesSortedBy {
        TargetId,
        ConversationId,
        DialogId;

    }
}

