/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import com.liveperson.api.response.model.ConversationINCADetails;
import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.model.Participants;
import com.liveperson.api.response.model.Result;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.commands.tasks.FetchConversationManager;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.Dialog;
import java.util.ArrayList;
import java.util.Arrays;

public class ConversationData
implements Comparable<ConversationData> {
    private static final String TAG = "ConversationData";
    public String conversationId;
    public String brandId;
    public String targetId;
    public String consumerId;
    public ConversationState state;
    public long requestId;
    public Participants participants;
    public DialogData[] dialogs;
    public CSAT csat;
    public CloseReason closeReason;
    public long endTs;
    public long startTs;
    public long ttrValue;
    public long manualTTR;
    public int unreadMessages;
    public TTRType conversationTTRType;
    public long delayTillWhen;
    public FetchConversationManager.DATA_SOURCE source;

    public ConversationData(ConversationState conversationState, Result result, String mBrandID) {
        this.conversationId = result.conversationId;
        this.brandId = mBrandID;
        this.targetId = mBrandID;
        this.consumerId = this.getConsumerId(result.conversationDetails.participants);
        this.conversationTTRType = TTRType.valueOf(result.conversationDetails.ttr != null ? result.conversationDetails.ttr.ttrType : "");
        this.state = conversationState;
        this.participants = result.conversationDetails.participants;
        this.requestId = -1L;
        this.csat = result.conversationDetails.csat;
        this.closeReason = result.conversationDetails.closeReason;
        this.endTs = result.conversationDetails.endTs;
        this.startTs = result.conversationDetails.startTs;
        this.ttrValue = result.conversationDetails.ttr.value * 1000;
        this.manualTTR = result.conversationDetails.manualETTR;
        if (result.conversationDetails.delay != null) {
            this.delayTillWhen = result.conversationDetails.delay.tillWhen;
        }
        this.source = FetchConversationManager.DATA_SOURCE.UMS;
        this.dialogs = result.conversationDetails.dialogs;
        if (this.dialogs == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000061, "The data from server did not include any dialog, injecting an inducted dialog from the conversation's data");
            this.dialogs = DialogData.extractDialogsData(this);
        }
        if (this.dialogs.length == 1 && this.dialogs[0].state == DialogState.OPEN && this.state == ConversationState.CLOSE) {
            this.dialogs = DialogData.extractDialogsData(this);
        }
    }

    public ConversationData(ConversationINCADetails conv, String mBrandID) {
        this.conversationId = conv.conversationId;
        this.brandId = mBrandID;
        this.targetId = mBrandID;
        this.consumerId = this.getConsumerId(conv.participants);
        this.conversationTTRType = TTRType.NORMAL;
        this.state = conv.getState();
        this.participants = conv.participants;
        this.requestId = -1L;
        this.csat = conv.csat;
        this.closeReason = conv.closeReason;
        this.endTs = conv.endTs;
        this.startTs = conv.startTs;
        this.delayTillWhen = -1L;
        this.unreadMessages = 0;
        this.source = FetchConversationManager.DATA_SOURCE.INCA;
        this.dialogs = conv.dialogs;
    }

    public ConversationData(String brandId, Conversation conversation) {
        this(brandId, conversation, new ArrayList<Dialog>());
    }

    public ConversationData(String brandId, Conversation conversation, ArrayList<Dialog> dialogs) {
        this.brandId = brandId;
        this.conversationId = conversation.getConversationId();
        this.targetId = conversation.getTargetId();
        this.conversationTTRType = TTRType.NORMAL;
        this.state = conversation.getState();
        this.requestId = -1L;
        this.closeReason = conversation.getCloseReason();
        this.endTs = conversation.getEndTimestamp();
        this.setDialogs(dialogs);
    }

    public ConversationData() {
    }

    private String getConsumerId(Participants participants) {
        String[] consumers = participants.CONSUMER;
        if (consumers != null && consumers.length > 0) {
            return consumers[0];
        }
        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000062, "Failed to retrieve the consumer id for conversation: " + LPLog.INSTANCE.mask((Object)participants));
        return "";
    }

    public String getAssignedAgentId() {
        String agentOriginatorId = "";
        if (this.participants != null && this.participants.AGENTS.length > 0) {
            agentOriginatorId = this.participants.AGENTS[0];
        } else if (this.participants != null && this.participants.ASSIGNED_AGENT.length > 0) {
            agentOriginatorId = this.participants.ASSIGNED_AGENT[0];
        }
        return agentOriginatorId;
    }

    @Override
    public int compareTo(ConversationData another) {
        long timeDiff = this.startTs - another.startTs;
        if (timeDiff < 0L) {
            return 1;
        }
        if (timeDiff > 0L) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "{ data: {conversationId: " + this.conversationId + ", state: " + (Object)((Object)this.state) + ", dialogs: " + Arrays.toString(this.dialogs) + "} }";
    }

    public void setDialogs(ArrayList<Dialog> dialogs) {
        if (dialogs != null && dialogs.size() > 0) {
            DialogData[] dialogsData = new DialogData[dialogs.size()];
            for (int i = 0; i < dialogsData.length; ++i) {
                dialogsData[i] = new DialogData(dialogs.get(i));
            }
            this.dialogs = dialogsData;
        }
    }
}

