package com.liveperson.messaging.model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.concurrent.TimeUnit;

/**
 * Created by Ilya Gazman on 9/7/2015.
 */
public class TimeBundle implements Parcelable {
    public final int diffDays;
    public final int diffHours;
    public final int diffMinutes;
    private long mTimeToRespondMilliseconds;

    public TimeBundle(long timeToRespondMilliseconds) {
        mTimeToRespondMilliseconds = timeToRespondMilliseconds;
        timeToRespondMilliseconds += 60 * 1000;
        diffDays = (int) TimeUnit.MILLISECONDS.toDays(timeToRespondMilliseconds);
        diffHours = (int) (TimeUnit.MILLISECONDS.toHours(timeToRespondMilliseconds) - (diffDays * 24));
        diffMinutes = (int) (TimeUnit.MILLISECONDS.toMinutes(timeToRespondMilliseconds) - (TimeUnit.MILLISECONDS.toHours(timeToRespondMilliseconds) * 60));
    }

    protected TimeBundle(Parcel in) {
        diffDays = in.readInt();
        diffHours = in.readInt();
        diffMinutes = in.readInt();
        mTimeToRespondMilliseconds = in.readLong();
    }

    @Override
    public boolean equals(Object o) {
        if(o instanceof Long){
            return mTimeToRespondMilliseconds == (long) o;
        }
        return super.equals(o);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(diffDays);
        dest.writeInt(diffHours);
        dest.writeInt(diffMinutes);
        dest.writeLong(mTimeToRespondMilliseconds);
    }

    @Override
    public String toString() {
        return diffDays + " : " + diffHours + " : " + diffMinutes;
    }

    public static final Creator<TimeBundle> CREATOR = new Creator<TimeBundle>() {
        @Override
        public TimeBundle createFromParcel(Parcel in) {
            return new TimeBundle(in);
        }

        @Override
        public TimeBundle[] newArray(int size) {
            return new TimeBundle[size];
        }
    };
}